## 1 闭包

方法做参数。

```groovy
task helloClosure {
  //使用闭包
  customEach { //默认参数 it
    println it
  }
}
//自定义闭包
def customEach(closure){
   for(int i in 1..10){
     closure(i)
   }
}
//out:
1
2
3
4
5
6
7
8
9
10
```

## 2 向闭包传参数

```groovy
task closureMap {
  mapEach{k,v ->
    println "$k,$v"
  }
}
def mapEach(closure){
   def map = ['name':'Java','price':"90.00"];
   map.each{
      closure(it.key,it.value)
   }
}
//out:
name,Java
price,90.00
```

## 3 闭包委托

Groovy 闭包支持方法的委托，有 thisObject、owner、delegate 三个属性。delegate 和 owner 是相等的，但是 delegate  可以被修改。

```groovy
class Student{
  private String name;
  private int age;
  
  def dumpStudent(){
     println "${name};${age}"
  }
}

task configClosure {
   student{
      name = "张三"
	  age = 58
	  dumpStudent()
   }
}

def student(Closure<Person> closure){
     Student s = new Student()
	 closure.delegate = s
	 //委托优先
	 closure.setResolveStrategy(Closure.DELEGATE_FIRST)
	 closure(s)
}
//out:
张三;58
```

