## 1 配置步骤

1. 下载 Gradle
2. 配置系统环境
3. 新建 build.gradle

```Groovy
task hello { //执行一个名称为 hello 的 Task（任务）
   doLast{
      println 'Hello World!'
   }
}
```

4. 使用 gradle -q hello 执行任务

![](../asset/gradle.png)

## 2 Gradle Wrapper

### 2.1 Wrapper

就是对 Gradle 的一层包装，在开发中统一 Gradle 构建的版本。

### 2.2 生成 Wrapper 

使用 gradle wrapper 生成。

![](../asset/wrapper.png)



![](../asset/wrappertest.png)

```groovy
//wrapper 配置
--gradle-version 指定版本
--gradle-distribution-url 指定下载的地址
```

### 2.3 gradle-wrapper.properties 配置文件

```gr
//下载 Gradle 压缩包解压后存储的主目录
distributionBase=GRADLE_USER_HOME 
//Gradle 压缩包路径
distributionPath=wrapper/dists  
//同 distributionBase ，存放的是 zip
zipStoreBase=GRADLE_USER_HOME
//同 distributionPath ，存放的是 zip
zipStorePath=wrapper/dists
//指定 Gradle 下载的地址
distributionUrl=https\://services.gradle.org/distributions/gradle-6.7.1-bin.zip
```

## 3 Gradle 日志

### 3.1日志级别

| 级别      | 作用 |
| --------- | ---- |
| ERROR     | 错误 |
| QUIET     | 重要 |
| WARNING   | 警告 |
| LIFECYCLE | 进度 |
| INFO      | 信息 |
| DEBUG     | 调试 |

```groovy
例：
#输出 QUIET 级别及以上的日志
gradle -q tasks
```

### 3.2 输出错误堆栈信息

```gr
-s 或者 --stacktrace 关键堆栈信息（推荐使用）
-S 或者 --full-stacktrace 全部堆栈信息
```

### 3.3 使用日志调试

```groovy
println('println')
logger.quiet('quiet日志信息.')
logger.error('error日志信息.')
logger.warn('warn日志信息.')
logger.lifecycle('lifecycle日志信息.')
logger.info('info日志信息.')
logger.debug('debug日志信息.')
```

## 4 Gradle 命令

```groovy
//1.帮助
./gradlew -?
./gradlew -h
./gradlew -help

//2.查看所有可执行的 Tasks
./gradlew tasks

//3.Gradle Help 任务：帮助 Task 使用
./gradlew help -task

//5.强制刷新依赖
./gradlew --refresh-dependencies assemble

//6.多任务调用
例如先 clean 再生成 jar
./gradlew clean jar

//7.通过任务名字缩写执行：任务名字太长，可以缩写
./gradlew connectCheck = ./gradlew cc
```

## 5 Hello World

```groovy
task hello {//task（任务） 和 action （动作） 是 Gradle 重要元素
    doLast {
        println 'Hello world'
    }
}

task hello << {// <<  = doLast
      println 'Hello world'
}
```

## 6 任务

task 是 Gradle 重要元素之一。

### 6.1 创建任务

```groovy
//1.直接创建
def Task hello = task(hello)
hello.doLast {
    println 'Hello world'
}

//2.任务名称 + 配置
def Task hello = task(hello,group:BasePlugin.BUILD_GROUP)
hello.doLast {
    println 'Hello world'
}

//3.TaskContainer
tasks.create(name:'hello')<< {
    println 'Hello world'
}

```

### 6.2 创建依赖

使用 **dependsOn**

```groovy
task hello << {
   println 'Hello world'
}

task hello2(dependsOn:hello) << { //hello 会先执行
   println 'Hello world2'
}
```

### 6.3 动态定义任务

```groovy
3.times {number ->  //3.times 循环创建
    task "task$number" << {
        println 'Hello world$number'
    }
}
```

### 6.4 任务的分组和描述

```groovy
task hello {
    group = 'build' //任务组，便于管理任务
    description = 'hello world'
    doLast {
    println 'Hello world'
    }
}
```

## 7 Gradle 插件基础

### 7.1 应用 Gradle 插件

两个步骤：

* 解析插件
* 把插件应用到项目中

两种类型插件：

* 脚本插件
* 对象插件（实现 Plugin 接口的类，二进制插件）

### 7.2 脚本插件

```groovy
//build.gradle
apply from: 'other.gradle' //配置插件
task test {
    doLast {
        println "${version};${url}"
    }
}

//other.gradle
ext{
   version = '1.1'
   url = 'http://baidu.com' 
}
```

### 7.3 对象插件

实现 **org.gradle.api.plugins<Project>** 接口的插件，可以分为：

* 内部插件
* 第三方插件

```groovy
//1.内部插件 比如 语言插件、集成插件、软件开发插件
//build.gradle
apply plugin: org.gradle.api.plugins.JavaPlugin

//gradle 默认导入 org.gradle.api.plugins
apply plugin: JavaPlugin

apply plugin: 'cpp'

//2.第三方插件 第三方插件通常是 jar 文件 使用 buildscript 来设置依赖
buildscript { //插件所在的仓库和插件的依赖
    repositories {
        google()
        jcenter()
        
    }
    dependencies {
        classpath 'com.android.tools.build:gradle:3.5.3'
    }
}

apply plugin: 'com.android.application' //添加 Android Gradle 依赖
```

### 7.4 插件 DSL

Gradle 的特性有四种状态，Internal、Incubation、Public、Deprecated

```groovy
//build.gralde 可以这样写
plugins {
    id 'java'
}

//build.gralde 可以这样写 不需要配置 buildscript
plugins {
    id "com.jfrog.bintray" version "1.8.3"
}

```

### 7.5 自定义 Gradle 插件

* build.gradle 编写
* buildSrc 工程项目中编写
* 独立项目中编写

#### 7.5.1 build.gradle 编写

```groovy
//1.简单的自定义插件
apply plugin:CustomPlugin
class CustomPlugin implements Plugin<Project>{

    @Override
    void apply(Project target) {
        target.task('CustomPluginTask'){
            doLast{
                println('自定义插件')
            }
        }

    }
}
//gradlew.bat CustomPlugin

//2.自定义插件扩展
apply plugin:CustomPlugin
class CustomPluginExtension{
    String msg = 'from CustomPlugin'
}

class CustomPlugin implements Plugin<Project>{

    @Override
    void apply(Project target) {
        def ext = target.extensions.create('custom', CustomPluginExtension)
        target.task('CustomPlugin'){
            doLast{
                println('自定义插件')
                println ext.msg
            }
        }

    }
}
```



#### 7.5.2 buildSrc 工程项目中编写

在根目录创建 **buildSrc/src/main/groovy/MyCustomPlugin.groovy** 文件

```groovy
import org.gradle.api.Plugin
import org.gradle.api.Project

class MyCustomPlugin implements Plugin<Project>{

    @Override
    void apply(Project target) {
        target.task('MyCustomPlugin'){
            doLast{
                println('我的自定义插件')
            }
        }

    }
}

apply plugin:MyCustomPlugin
```

#### 7.5.3 独立项目中编写

buildSrc 只能在自己项目中使用，独立项目使用要配置

```groovy
//build.gradle
apply plugin: 'groovy'
dependencies {
    compile gradleApi()
    compile localGroovy()
}

//创建插件
package com.test.groovy

import org.gradle.api.Plugin
import org.gradle.api.Project

class MyCustomPlugin2 implements Plugin<Project>{

    @Override
    void apply(Project target) {
        target.task('MyCustomPlugin2'){
            doLast{
                println('MyCustomPlugin2 自定义插件')
            }
        }

    }
}

//配置 properties 
```

