## 1 Groovy 概述

Groovy 是 Apache  基于 JVM 的面向对象的编程语言，完全和 Java 兼容。

## 2 语法

### 2.1 变量

```groovy
//1.变量
def a  = 1
def int b = 1
def c = 'Hello World'
def d = "Hello World"
def e = '''Hello World'''
```

### 2.2 方法

```groovy
//1.定义一个方法
def method(int a,int b){
  println a + b
}
task test << {
    method(1,2)
	method 1,2 //可以省略()
}

//2.可以省略 return
def test1(int a,int b){
   if(a > b){
     a  //和 Kotlin 一样
   } else {
     b
   }
}

task test2 {
	def m1 = method1 1,2
	def m2 = method1 6,2
	println "$m1,$m2"
}
//输出：
2,6

//3.代码块可以作为参数
numList.each({println it})
//简化
numList.each {
   println it
}
```

### 2.3 类

```groovy
class Person {
    String name; //和 Java 不同，默认就有 getter/setter
    int age;   
}
task test4 {
  def p = new Person()
  p.name = '张三'
  p.age = 22
  println "$p.name;$p.age"
}
//out:
张三;22
```

### 2.4 断言

```groovy
//断言一直处于开启状态
task test5 {
    assert 1 + 1 == 5    
}
//out：
 assert 1 + 1 == 5
           |   |
           2   false
```

### 2.5 for

```groovy
def x = 0
for (i in 0..3){
    println "${i}"
}

//遍历 map
def a = ['a':1,'b':2]
for (v in a.values()){
    println "${v}"
}

```

### 2.6 switch

```groovy
task test6 {
    def x = 0
    switch(x){
        case 0:
        println "${x}"
        break
    }
}

```

### 2.7 字符串

```groovy
def c = 'Hello World'
def d = "Hello World"
def e = '''Hello World
       The World
''' //三引号，可以保留换行、缩进等
```

### 2.8 List

```groovy
task test7 {
    def a = [1,2,3]
    def d = [1,2,3] as LinkedList //可以使用 as 强制转换
    println "${a[0]}" //1
    println "${a[-1]}" //3
}
```

### 2.9 map

```groovy
task test8 {
    def a = ['a':2,'b':3]
    println "${a['a']}" //2
}
```

### 2.10 闭包

闭包就是一个开放的、匿名的、可以接受参数和返回值的代码块。

```groovy
def a = {println it}
a(4)

task helloClosure {
  //使用闭包
  customEach { //默认参数 it
    println it
  }
}
//自定义闭包
def customEach(closure){
   for(int i in 1..10){
     closure(i)
   }
}
```

## 2.11 I/O操作

```groovy
//读取
def path = "D:/testGradle/file.txt"
def file = new File(path)
file.eachLine{
    println it   
}
println file.text

//写入
file.withPrintWriter{
    it.println("test22")
}

```

### 2.12 其他

```groovy
//asType 数据类型就转换
def b = 23
def x = a.asType(Integer)
assert x intanceof java.lang.Integer

//判断是否为真
def name = ''
if(name){
    
}

//安全取值
println person?.name

//with
class Person{
    String name
    Integer age
}

def p = new Person()
p.with{
    name = "test"
    age = 58
}
```

