## 1 匿名分支

```python
# 例
$ git add 1.txt
$ git commit -m "1.txt"

$ git add 2.txt
$ git commit -m "2.txt"

$ git add 3.txt
$ git commit -m "3.txt"

$ git log --online --all --graph
* 485c78e (HEAD -> master) 3.txt
* abcf805 2.txt
* a742c31 1.txt

$ git checkout HEAD~
Note: checking out 'HEAD~'.

You are in 'detached HEAD' state. You can look around, make experimental
changes and commit them, and you can discard any commits you make in this
state without impacting any branches by performing another checkout.

If you want to create a new branch to retain commits you create, you may
do so (now or later) by using -b with the checkout command again. Example:

  git checkout -b <new-branch-name>

HEAD is now at abcf805... 2.txt
# 使用了 checkout 命令但没有指定分支名， Git 会自动创建了一个匿名分支，当切换到别的分支时，这个匿名分支中的所有提交都会被丢弃掉。
# 作用：用于测试、实验性代码时候
```

##  2 checkout

* 从历史快照（或暂存区域）中拷贝文件到工作目录
* 切换分支

```python
1.当给定某个文件名时，Git 会指定的提交文件中拷贝到暂存区域和工作目录，比如 git checkout HEAD~。
2.没有指定具体的快照 ID，则将中暂存区域恢复指定文件到工作目录。
```

## 3 reset 和 checkout 区别

```python
1.checkout 对工作目录是安全的，它会通过检查来确保不会将已更改的文件弄丢；而 reset --hard 则会不做检查就全面地替换所有东西。
2.reset 会移动 HEAD 分支的指向（即 HEAD 指向的分支的指向），而 checkout 只会移动 HEAD 自身来指向另一个分支。
```

![](../../asset/git_reset_checkout.png)

