## 1 初次使用配置

在命令行模式下输入以下命令。

```python
git config --global user.name "用户名"
git config --global user.email "邮箱"
    
# 使用以下命令查看配置信息
git config --list    
```

## 2 理论基础

### 2.1 Git 记录是什么

Git 会将每个版本独立保存。

### 2.2 三棵树

* 工作区域（Working Directory）：存放项目的地方
* 暂存区域（State（Index））：临时存放改动的地方
* Git仓库（Repository（HEAD））：最终存放版本文件的地方

## 3  Git 工作流程

### 3.1 工作流程

1. 在工作目录中添加、修改文件
2. 将需要进行版本管理的文件放入到暂存区域
3. 将暂存区域的文件提交到 Git 仓库

### 3.2 Git 管理文件的三中状态

* 已修改（modified）
* 已暂存（staged）
* 已提交（committed）

## 4 步骤

```python
# 初始化仓库
git init
# 添加文件到暂存区域
git add README.md
# 将暂存区域的文件提交到 Git 仓库
git commit -m "add a readme file"
```

