## 1 填充（Padding）

给其子节点添加填充（留白），和边距效果类似。

```dart
Padding({
  ...
  EdgeInsetsGeometry padding,//一般使用EdgeInsets类
  Widget child,
}
```

### EdgeInsets

- `fromLTRB(double left, double top, double right, double bottom)`：分别指定四个方向的填充。
- `all(double value)` : 所有方向均使用相同数值的填充。
- `only({left, top, right ,bottom })`：可以设置具体某个方向的填充(可以同时指定多个方向)。
- `symmetric({ vertical, horizontal })`：用于设置对称方向的填充，`vertical`指`top`和`bottom`，`horizontal`指`left`和`right`。

## 2 尺寸限制类容器

用于限制容器大小。

* ConstrainedBox：对子组件添加额外的约束

* BoxConstraints：用于设置限制条件

  ```dart
  //最小高度为50，宽度尽可能大的红色容器。
  ConstrainedBox(
    constraints: BoxConstraints(
      minWidth: double.infinity, //宽度尽可能大
      minHeight: 50.0 //最小高度为50像素
    ),
    child: Container(
        height: 5.0, 
        child: redBox 
    ),
  )
  ```

* SizedBox

  用于给子元素指定固定的宽高

  ```dart
  SizedBox(
    width: 80.0,
    height: 80.0,
    child: redBox
  )
  ```

* UnconstrainedBox:不会对子组件产生任何限制，它允许其子组件按照其本身大小绘制,“去除”父级限制

## 3 装饰容器DecoratedBox

可以在其子组件绘制前(或后)绘制一些装饰（Decoration），如背景、边框、渐变等

```dart
const DecoratedBox({
  Decoration decoration, //BoxDecoration
  DecorationPosition position = DecorationPosition.background,
  Widget child
})
```

## 4 变换（Transform）

在其子组件绘制时对其应用一些矩阵变换来实现一些特效。

* Transform.translate：平移
* Transform.rotate：旋转
* Transform.scale：缩放

RotatedBox：是在layout阶段，会影响在子组件的位置和大小

## 5 Container

组合类容器。

```dart
Container({
  this.alignment,
  this.padding, //容器内补白，属于decoration的装饰范围
  Color color, // 背景色
  Decoration decoration, // 背景装饰
  Decoration foregroundDecoration, //前景装饰
  double width,//容器的宽度
  double height, //容器的高度
  BoxConstraints constraints, //容器大小的限制条件
  this.margin,//容器外补白，不属于decoration的装饰范围
  this.transform, //变换
  this.child,
})
```

## 6 Scaffold、TabBar、底部导航

* Scaffold:是一个路由页的骨架

* AppBar:是一个Material风格的导航栏，通过它可以设置导航栏标题、导航栏菜单、导航栏底部的Tab标题

* TabBar:快速生成Tab菜单

* TabBarView:配合TabBar来实现同步切换和滑动状态同步

* Drawer:抽屉菜单

* FloatingActionButton:一种特殊Button，通常悬浮在页面的某一个位置作为某种常用动作的快捷入口

* 通过`Scaffold`的`bottomNavigationBar`属性来设置底部导航。

  ```dart
  bottomNavigationBar: BottomAppBar(
    color: Colors.white,
    shape: CircularNotchedRectangle(), // 底部导航栏打一个圆形的洞
    child: Row(
      children: [
        IconButton(icon: Icon(Icons.home)),
        SizedBox(), //中间位置空出
        IconButton(icon: Icon(Icons.business)),
      ],
      mainAxisAlignment: MainAxisAlignment.spaceAround, //均分底部导航栏横向空间
    ),
  )
  ```

  