## 1 简介

布局类组件都会包含一个或多个子组件，不同的布局类组件对子组件排版(layout)方式不同，分为三类：

| Widget                        | 对应的Element                  | 用途                                                         |
| ----------------------------- | ------------------------------ | ------------------------------------------------------------ |
| LeafRenderObjectWidget        | LeafRenderObjectElement        | Widget树的叶子节点，用于没有子节点的widget，通常基础组件都属于这一类，如Image。 |
| SingleChildRenderObjectWidget | SingleChildRenderObjectElement | 包含一个子Widget，如：ConstrainedBox、DecoratedBox等         |
| MultiChildRenderObjectWidget  | MultiChildRenderObjectElement  | 包含多个子Widget，一般都有一个children参数，接受一个Widget数组。如Row、Column、Stack等 |

## 2 线性布局

* Row:类似`LinearLayout`控件
* Column:垂直方向排列其子组件

```dart
Row({
  ...  
  TextDirection textDirection,//子组件的布局顺序    
  MainAxisSize mainAxisSize = MainAxisSize.max,//在主轴(水平)方向占用的空间    
  MainAxisAlignment mainAxisAlignment = MainAxisAlignment.start,//子组件在Row所占用的水平空间内对齐方式
  VerticalDirection verticalDirection = VerticalDirection.down,//纵轴（垂直）的对齐方向  
  CrossAxisAlignment crossAxisAlignment = CrossAxisAlignment.center,//子组件在纵轴方向的对齐方式
  List<Widget> children = const <Widget>[],
})
```

## 3 弹性布局（Flex）

子组件按照一定比例来分配父容器空间，类似 Android 中的 FlexboxLayout。

```dart
Flex({
  ...
  @required this.direction, //弹性布局的方向, Row默认为水平方向，Column默认为垂直方向
  List<Widget> children = const <Widget>[],
})
    
//Expanded 比例“扩伸” Row、Column和Flex子组件所占用的空间。
const Expanded({
  int flex = 1, 
  @required Widget child,
})
```

## 4 流式布局

* Wrap
* Flow

```dart
Wrap(
  spacing: 8.0, // 主轴(水平)方向间距
  runSpacing: 4.0, // 纵轴（垂直）方向间距
  alignment: WrapAlignment.center, //沿主轴方向居中
  children: <Widget>[
    new Chip(
      avatar: new CircleAvatar(backgroundColor: Colors.blue, child: Text('A')),
      label: new Text('Hamilton'),
    ),
    new Chip(
      avatar: new CircleAvatar(backgroundColor: Colors.blue, child: Text('M')),
      label: new Text('Lafayette'),
    ),
    new Chip(
      avatar: new CircleAvatar(backgroundColor: Colors.blue, child: Text('H')),
      label: new Text('Mulligan'),
    ),
    new Chip(
      avatar: new CircleAvatar(backgroundColor: Colors.blue, child: Text('J')),
      label: new Text('Laurens'),
    ),
  ],
)
```

Flow:

很少用，过于复杂，需要自己实现子widget的位置转换，用于一些需要自定义布局策略或性能要求较高(如动画中)的场景。

## 5 层叠布局

* Stack：允许子组件堆叠
* Positioned 用于根据 Stack 的四个角来确定子组件的位置。

## 6 对齐与相对定位（Align）

Align 组件可以调整子组件的位置，并且可以根据子组件的宽高来确定自身的的宽高，只要一个子组件。

```dart
Align({
  Key key,
  this.alignment = Alignment.center,
  this.widthFactor,
  this.heightFactor,
  Widget child,
})
```

