﻿## 1 Linux 目录结构

linux 的目录中有且只要一个根目录 / ，各个目录存放的内容是规划好，不用乱放文件，在 linux 系统，一切皆为文件。

![](../asset/linux目录结构.jpg)

- lib
  
- 系统开机所需要最基本的动态链接共享库，其作用类似于Windows里的DLL文件。几乎所有的应用程序都需要用到这些共享库。
  
- lost+found
  
  - 一般情况下是空的，当系统非法关机后，这里就存放了一些文件。
- etc [重点]
  
  - 所有系统管理所需要的配置文件和子目录，my.conf
- usr
  
- 用户的很多应用程序和文件都放在这个目录下。类似于Windows下的program.files目录
  
- bin [重点]

  * usr/bin、/usr/local/bin： Unix System Resource，即Unix系统资源的缩写]

  - 是Binary的缩写，这个目录存放着经常使用的命令

- sbin

  * usr/sbin、/usr/local/sbin

  - s就是s per user的意思，这里存放的是系统管理员使用的系统管理程序

- home [重点]
  
- 存放普通用户的主目录，在Linux中的每个用户都有一个自己的目录，一般该目录一用户的账号名命名
  
- root [重点]
  
- 该目录为系统管理员，超级权限者的用户目录
  
- boot
  
- 存放的启动Linux时使用的一些核心文件，包括一些链接文件和镜像文件
  
- proc 
  
- 虚拟目录，是系统内存的映射，访问这个目录来获取系统信息。
  
- srv 
  
- service 的缩写，该目录是存放一些服务启动之后需要提取的数据
  
- sys
  
- Linux2.6内核的一个很大变化，该目录安装了2.6内核中新出现的一个文件系统
  
- tmp
  
- 存放临时文件
  
- dev
  
- 类似于 windows的设备管理器,把所有的硬件用文件的形式存储
  
- media [重点]
  
  - Linux系统会自动识别一些设备,例如U盘、光驱等等,当识别后,Linux 会把识别的设备挂载到这个目录下。
- mnt [重点]

- 系统提供该目录是为了让用户临时挂载别的文件系统的,我们可以将外部的存储挂载在/mnt/上,然后进入该目录就可以查看里的内容了。d:/ myshare

- opt
  
  - 这是给主机额外安装软件所摆放的目录。如安装 ORACLE数据库就可放到该目录下。默认为空。
- usr/local [重点]
  
  - 这是另个给主机额外安装软件所安装的目录。一般是通过编译源码方式安装的程序。
- var [重点]
  
- 这个目录中存放着在不断扩充着的东西,习惯将经常被修改的目录放在这个目录下。包括各种日志文件。
  
- selinux [security-enhanced linux] 

  * 类似 360

  - Selinux是一种安全子系统,它能控制程序只能访同特定文件。

## 2 常用命令

* ls：显示目录文件

  * -a   显示所有文件，包括隐藏文件
  * -l   详细信息显示
  * -d   查看目录属性
* mkdir：创建新目录 

  * -p：递归创建
* cd：切换目录
* pwd：显示当前目录
* rmdir：删除空目录
* cp：复制文件或目录

  * -r：复制目录
  * -p：保留文件属性
* rm：删除文件

  * -r：删除目录
  * -f：强制执行
* touch：创建空文件
* cat：显示文件内容   

  * -n：显示行号
* more：分页显示文件内容 

  * 空格、f：翻页   
  * Enter：换行  
  * q、Q：退出
* less：分页显示文件内容（可向上翻页）

  * 按下 / 后可以搜索 会反显高亮  按q退出（more也可以）
* head：显示文件前面几行  

  * -n：指定行数
* tail：显示文件后面几行

  * -n：指定行数   
  * -f：动态显示文件末尾内容 
* ln：生成链接文件

  * -s：创建软链接 
* find：文件搜索
* grep：在文件中搜寻字串匹配的行并输出，grep  -iv [指定字串] [文件] 

  * -i：不区分大小写 

  * -v：排除指定字串      
* man：帮助 

  * 空格、f；翻页
  * Enter：换行
  * q、Q：退出 
* useradd：添加新用户 
* passwd：设置用户
* who：查看登录用户信息 
* w：查看登录用户详细信息 
* gzip：压缩文件 
* tar：打包目录 压缩后文件格式：.tar.gz
  * -c：打包      
  
    * -v ：显示详细信息
  
    * -f：指定文件名
    * -z：打包同时压缩 
  
  * -x   解包      
  
    * -v：显示详细信息      
  
    * -f：指定解压文件      
  
    * -z：解压缩 

* zip：压缩文件或目录 
  * -r：压缩目录 

* unzip：解压.zip的压缩文件 
* netstat：显示网络相关信息

## 3  文件系统管理

### 3.1 分区类型 

* 主分区：总共最多只能分四个 

* 扩展分区：只能有一个，也算作主分区的一种，也就是说主分区加扩展分区最多有四个。但是扩展分区不能存储数据和格式化，必须再划分成逻辑分区才能使用。 

* 逻辑分区：逻辑分区是在扩展分区中划分的，如果是IDE硬盘，Linux最多支持59个逻辑分区，如果是SCSI硬盘Linux最多支持11个逻辑分区

### 3.2 文件系统 

* ext2：是ext文件系统的升级版本，Red Hat Linux7.2版本以前的系统默认都是ext2 文件系统。1993年发布，最大支持16TB 的分区和最大2TB的文件（1TB=1024GB=1024*1024KB）
* ext3： ext3文件系统是ext2文件系统的升级版本，最大的区别就是带日志功能，以在系统突然停止时提高文件系统的可靠性。支持最大16TB的分区和最大2TB的文件
* ext4：它是ext3文件系统的升级版。ext4 在性能、伸缩性和可靠性方面进行了大量改进。EXT4 的变化可以说是翻天覆地的，比如向下兼容EXT3、最大1EB文件系统和16TB文件、无限数量子目录、Extents连续数据块概念、多块分配、延迟分配、持久预分配、快速FSCK、日志校验、无日志模式、在线碎片整理、inode增强、默认启用barrier等。是CentOS 6.3的默认文件系统（1EB=1024PB=1024*1024TB）