## 1 简介

绘制优化主要是**界面流畅度**的优化。

## 2 绘制原理

View 绘制流程：measure、layout、draw，运行在系统应用框架层，真正将数据渲染到屏幕上的是系统 Native 层 **SurfaceFlinger** 服务来完成。

FPS：帧数， 1 秒时间内传输数据的图片的量，View 的最佳绘制频率为 **60fps**，要求每帧绘制时间 <= 16ms。

## 3 产生卡顿原因

* 布局 Layout 过于复杂，无法在 16ms 完成渲染。
* 同一个**时间动画执行的次数**过多，导致 CPU 或 GPU 负载过重。
* View 过度绘制，导致某些像素在同一帧时间内被绘制多次。
* 在 UI 线程中做了耗时操作。
* GC 回收时暂停时间过长或者频繁的 GC 产生大量的暂停时间。

## 4 布局调优工具

### 4.1 Profile GPU Rendering

Android手机上自带的一个辅助图形监测工具，用于渲染、绘制性能追踪。

### 4.2 TraceView



### 4.3 Systrace



## 5 布局优化方式

### 5.1 合理运用布局

RelativeLayout 存在性能低的问题，原因是 RelativeLayout 会对子 View 做两次测量。但如果在 LinearLayout 中有 weight 属性，也需要进行两次测量，但是因为没有更多的依赖关系，所以仍然会比RelativeLayout的效率高。

### 5.2 使用 Merge 标签去除多余层级

### 5.3 使用 ViewStub 提高加载速度

### 5.4 避免 GPU 过度绘制



### 

参考阅读

* [Android绘制优化（一）绘制性能分析](http://liuwangshu.cn/application/performance/draw-1-performance.html)
* [Android绘制优化（二）布局优化](http://liuwangshu.cn/application/performance/draw-2-layout.html)
* [Android性能优化之绘制优化](https://juejin.cn/post/6844904080989487118)
* [必知必会 | Android 性能优化的方面方面都在这儿](https://mp.weixin.qq.com/s/QVOYF2nfoWMCbM5YsxQgRQ?)