## 1 简介

协程通过将复杂性放入库来简化异步编程。程序的逻辑可以在协程中顺序地表达，而底层库会为我们解决其异步性。该库可以将用户代码的相关部分包装为回调、订阅相关事件、在不同线程（甚至不同机器）上调度执行，而代码则保持如同顺序执行一样简单。

简单来说，协程是一种并发的设计模式，是一个轻量级的线程。

### 2 基础

```kotlin
class MainActivity : AppCompatActivity() {
    private var TAG = "Test_Main"

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        test1()
    }
    private fun test1() {
        GlobalScope.launch {
            delay(1000L)
            println("World")
        }
        println("Hello")
        Thread.sleep(2000L)
    }
}

```

