# App Intro with Expo and Lottie

![foo](https://user-images.githubusercontent.com/26605247/70745742-63455780-1d1c-11ea-9bd8-6aeeca8a9439.gif)

## Overview

The technologies used in this app are the following:

* Front end: [Expo](https://docs.expo.io/versions/latest/workflow/expo-cli/).

* Navigation is done with: [react-navigation](https://reactnavigation.org/).

* Layout: [styled-components](https://www.styled-components.com/).

* Animations: [Lottie](https://github.com/react-native-community/lottie-react-native).

## Prerequisites

* [Node JS](https://nodejs.org/en/download/) with [NPM](https://docs.npmjs.com/downloading-and-installing-node-js-and-npm)

* [Expo CLI](https://docs.expo.io/versions/latest/workflow/expo-cli/)
  * `npm install -g expo-cli`
  
## Run the project

1. Clone this repo to your local machine.

```
git clone https://github.com/yhenni1989/app-intro-lottie-expo.git

cd app-intro-lottie-expo
```

2. Install client dependencies.

```
yarn

# or

npm install
```

3. Launch the metro bundler.

```
yarn start
```

This will start the metro bundler in your browser.

4. Lanuch the simulator on your machine

If you have Xcode or Android Emulator installed, then you can launch the simulator using one of the following commands.

```
yarn ios

# or

yarn android
```

If you don't have a simulator installed in your machine, skip to step 5.

5. Test the app in your device.

 * You must install the Expo Client app on your phone. Links in Section 2 of the [docs](https://docs.expo.io/versions/v36.0.0/get-started/installation/).
 
 * Scan the QR code provided by expo. Located at the bottom left corner in the Metro Bundler browser page.

<img width="1441" alt="Metro Bundler" src="https://user-images.githubusercontent.com/26605247/70796392-0d16f980-1d9a-11ea-90b3-102ad457cb19.png">


## Step by step tutorial

* Read the full series of articles detailing the building process of this app [here.](https://medium.com/@henni1989younes/app-intro-with-react-native-expo-and-airbnb-lottie-668af1dbe401)
