简体中文 | [English](./README.md)

<div align="center">

# 你不需要
<a href="https://github.com/you-dont-need">
  <img src="logo.jpg" width="200" alt="Logo"></img>
</a>  

开发者选择流行的项目，往往不是因为它适用于他们的问题。 

[![Awesome](https://awesome.re/badge.svg)](https://awesome.re)


</div>

## 内容

- [包](#packages)
  - [JavaScript包](#javascript-packages)
- [语言](#languages)
- [编程实践](#programming-practices)
- [其他](#miscellaneous)

## 包

### JavaScript包

- [你（或许）不需要 Lodash/Underscore](https://github.com/you-dont-need/You-Dont-Need-Lodash-Underscore) - 你可以使用的原生JavaScript方法列表+ ESLint 插件。
- [你（或许）不需要 need Moment.js](https://github.com/you-dont-need/You-Dont-Need-Momentjs) - 你可以使用的原生日期函数列表，用于替代Moment.js。
- [你（或许）不需要 Need Redux](https://medium.com/@dan_abramov/you-might-not-need-redux-be46360cf367) - 如果你只是学习 React，那么不要让 Redux 成为你的第一选择。
- [你（或许）不需要 React Router](https://www.freecodecamp.org/news/you-might-not-need-react-router-38673620f3d) - Facebook的大多数项目甚至不使用它。
- [你（或许）不需要 jQuery](http://youmightnotneedjquery.com/) - 如果你的目标只是更现代的浏览器，那么你可能只需要浏览器自带的东西。
- [你（或许）不需要 Axios](https://danlevy.net/you-may-not-need-axios/) - 标准的 `window.fetch` 有你所需要的全部特性。
- [你（或许）不需要 Gatsby](https://johnny.sh/blog/you-might-not-need-gatsby/) - 一个更简单的静态React堆栈。

## 语言

- [你不需要 JavaScript](https://github.com/you-dont-need/You-Dont-Need-JavaScript) - CSS 非常强大，大多数时候你都不需要使用JS。
- [你（或许）不需要 TypeScript (或者静态类型)](https://medium.com/javascript-scene/you-might-not-need-typescript-or-static-types-aa7cb670a77b#.8oxodypn7) - 毫无疑问，静态类型感觉很好。咬一口热乎乎的甜甜圈感觉很好。但它真的对你有好处吗?

## 编程实践

- [你不需要循环 ➿](https://github.com/you-dont-need/You-Dont-Need-Loops) - 循环太扯了！让我们拥抱 wholemeal 编程！
- [你可能不需要状态驱动 (React)](https://reactjs.org/blog/2018/06/07/you-probably-dont-need-derived-state.html) - 作为一条准则，状态驱动应该谨慎使用。我们看到的所有状态驱动的问题都可以归结为：根据props无条件的更新状态，或者props和状态不匹配时更新状态。
- [你可能不需要编译你的JavaScript](https://www.freecodecamp.org/news/you-might-not-need-to-transpile-your-javascript-4d5e0a438ca) - 换句话说，如果你将JavaScript转换为ES5，你将使你的代码变得不必要的庞大和变慢，以支持少数用户，而他们可能会在你配置Webpack和Babel时升级他们的系统! 😉

## 其他

- [你不需要 GUI](https://github.com/you-dont-need/You-Dont-Need-GUI) - 停止依赖GUI；**ROCKS** 脚手架。
