const colors = require('tailwindcss/colors');

module.exports = {
  // first theme default
  '.theme-light': {
    primary: colors.indigo[500],
    'primary-focus': colors.indigo[700],
    'primary-content': colors.white,
    secondary: colors.pink[500],
    'secondary-focus': colors.pink[700],
    'secondary-content': colors.white,
    accent: colors.teal[500],
    'accent-focus': colors.teal[700],
    'accent-content': colors.white,
    neutral: colors.neutral[400],
    'neutral-focus': colors.neutral[600],
    'neutral-content': colors.white,
    'base-100': colors.white,
    'base-200': colors.gray[200],
    'base-300': colors.gray[300],
    'base-content': colors.gray[800],
    info: colors.blue[500],
    success: colors.green[500],
    warning: colors.yellow[300],
    error: colors.red[500],
  },
  '.theme-dark': {
    primary: colors.indigo[500],
    'primary-focus': colors.indigo[700],
    'primary-content': colors.white,
    secondary: colors.pink[500],
    'secondary-focus': colors.pink[700],
    'secondary-content': colors.white,
    accent: colors.emerald[400],
    'accent-focus': colors.emerald[600],
    'accent-content': colors.white,
    neutral: colors.neutral[600],
    'neutral-focus': colors.neutral[500],
    'neutral-content': colors.white,
    'base-100': colors.gray[800],
    'base-200': colors.gray[600],
    'base-300': colors.gray[500],
    'base-content': colors.gray[100],
    info: colors.blue[500],
    success: colors.green[500],
    warning: colors.yellow[300],
    error: colors.red[500],
  },
  '.theme-blue': {
    primary: colors.blue[600],
    'primary-focus': colors.blue[800],
    'primary-content': colors.white,
    secondary: colors.slate[400],
    'secondary-focus': colors.slate[500],
    'secondary-content': colors.white,
    accent: colors.emerald[400],
    'accent-focus': colors.emerald[500],
    'accent-content': colors.white,
    neutral: colors.neutral[400],
    'neutral-focus': colors.neutral[600],
    'neutral-content': colors.neutral[100],
    'base-100': colors.white,
    'base-200': colors.slate[200],
    'base-300': colors.slate[300],
    'base-content': colors.slate[900],
    info: colors.blue[500],
    success: colors.green[500],
    warning: colors.yellow[300],
    error: colors.red[500],
    '--navbar-bg-color': colors.blue[500],
    '--navbar-border-color': colors.blue[600],
    '--navbar-text-color': colors.white,
    // any css value
  },
  '.theme-red': {
    primary: colors.yellow[300],
    'primary-focus': colors.yellow[400],
    'primary-content': colors.black,
    secondary: colors.orange[500],
    'secondary-focus': colors.orange[600],
    'secondary-content': colors.black,
    accent: colors.lime[300],
    'accent-focus': colors.lime[400],
    'accent-content': colors.black,
    neutral: colors.gray[400],
    'neutral-focus': colors.gray[500],
    'neutral-content': colors.white,
    'base-100': colors.white,
    'base-200': colors.gray[200],
    'base-300': colors.gray[300],
    'base-content': colors.black,
    info: colors.blue[500],
    success: colors.green[500],
    warning: colors.yellow[300],
    error: colors.red[500],
    '--navbar-bg-color': colors.red[500],
    '--navbar-border-color': colors.red[600],
    '--navbar-text-color': colors.white,
  },
  '.theme-green': {
    primary: colors.green[700],
    'primary-focus': colors.green[900],
    'primary-content': colors.white,
    secondary: colors.emerald[200],
    'secondary-focus': colors.emerald[300],
    'secondary-content': colors.emerald[900],
    accent: colors.rose[200],
    'accent-focus': colors.rose[300],
    'accent-content': colors.rose[900],
    neutral: colors.neutral[500],
    'neutral-focus': colors.neutral[600],
    'neutral-content': colors.white,
    'base-100': colors.neutral[200],
    'base-200': colors.neutral[400],
    'base-300': colors.neutral[500],
    'base-content': colors.neutral[900],
    info: colors.blue[500],
    success: colors.green[500],
    warning: colors.yellow[300],
    error: colors.red[500],
    '--navbar-bg-color': colors.green[500],
    '--navbar-border-color': colors.green[600],
    '--navbar-text-color': colors.white,
  },
  '.theme-black': {
    primary: colors.blue[800],
    'primary-focus': colors.blue[700],
    'primary-content': colors.neutral[300],
    secondary: colors.red[800],
    'secondary-focus': colors.red[700],
    'secondary-content': colors.neutral[300],
    accent: colors.yellow[500],
    'accent-focus': colors.yellow[400],
    'accent-content': colors.neutral[800],
    'base-100': colors.neutral[800],
    'base-200': colors.neutral[700],
    'base-300': colors.neutral[500],
    'base-content': colors.neutral[300],
    neutral: colors.neutral[500],
    'neutral-focus': colors.neutral[400],
    'neutral-content': colors.white,
    info: colors.blue[500],
    success: colors.green[500],
    warning: colors.yellow[300],
    error: colors.red[500],
  },
};
