---
title: Releasing Yew 0.20
authors: [hamza] tags: [release]
---

The Yew team is happy to announce a new, long overdue, version of Yew: v0.20.
Yew is a framework for creating reliable and efficient web applications.

<!--truncate-->

## What's new

This release comes with new features aimed at improving the user experience, such as server-rendering and render-as-you-fetch approach for data-fetching.

### SSR

Yew now fully supports rendering on the server. Rendering on the server means users will get a rendered HTML and will not have to wait to be able to see anything until the entire WebAssembly bundle is downloaded and initial render has completed. With SSR, the page will be visible instantly, and interactable as soon as hydration finishes.

Learn more at [Server-side rendering](/docs/advanced-topics/server-side-rendering)

### Data fetching

With SSR comes new ways of data-fetching. The newly added [`use_prepared_state!`](https://api.yew.rs/next/yew/functional/macro.use_prepared_state.html) hook can be used to fetch data while rendering on the server and seemlessly use it in the component.

For client-side fetching, Yew now supports render-as-you-fetch approach with [Suspense](/docs/concepts/suspense).

## How to upgrade

There have been breaking changes in this release. Our [migration guides](/docs/migration-guides/yew/from-0_19_0-to-0_20_0) go over how to upgrade each over of the new crates.

## Thanks!

Many people came together to help make this release happen. We couldn't have done it without all of you. Thanks!
