use std::io::Write;

use anyhow::Result;
use semver::Version;

use crate::yew_package::YewPackage;

pub fn write_changelog_file(
    fixes_logs: &[u8],
    features_logs: &[u8],
    breaking_changes_logs: &[u8],
    package: YewPackage,
    next_version: Version,
) -> Result<Vec<u8>> {
    let mut version_only_changelog = Vec::default();

    writeln!(version_only_changelog, "# Changelog")?;
    writeln!(version_only_changelog)?;

    writeln!(
        version_only_changelog,
        "## ✨ {package} **{next_version}** *({release_date})* Changelog",
        next_version = next_version,
        package = package,
        release_date = chrono::Utc::now().format("%Y-%m-%d")
    )?;
    writeln!(version_only_changelog)?;

    if fixes_logs.is_empty() && features_logs.is_empty() && breaking_changes_logs.is_empty() {
        writeln!(version_only_changelog, "No changes")?;
        writeln!(version_only_changelog)?;
    }

    if !fixes_logs.is_empty() {
        writeln!(version_only_changelog, "### 🛠 Fixes")?;
        writeln!(version_only_changelog)?;
        version_only_changelog.extend(fixes_logs);
        writeln!(version_only_changelog)?;
    }

    if !features_logs.is_empty() {
        writeln!(version_only_changelog, "### ⚡️ Features")?;
        writeln!(version_only_changelog)?;
        version_only_changelog.extend(features_logs);
        writeln!(version_only_changelog)?;
    }

    if !breaking_changes_logs.is_empty() {
        writeln!(version_only_changelog, "### 🚨 Breaking changes")?;
        writeln!(version_only_changelog)?;
        version_only_changelog.extend(breaking_changes_logs);
        writeln!(version_only_changelog)?;
    }

    Ok(version_only_changelog)
}
