<div align="center">
  <a href="https://yew.rs/" target="_blank"><img src="https://yew.rs/img/logo.png" width="150" /></a>

  <h1>Yew</h1>

  <p>
    <strong>Rust / Wasm client web app framework</strong>
  </p>

  <p>
    <a href="https://crates.io/crates/yew"><img alt="Crate Info" src="https://img.shields.io/crates/v/yew.svg"/></a>
    <a href="https://docs.rs/yew/"><img alt="API Docs" src="https://img.shields.io/badge/docs.rs-yew-green"/></a>
    <a href="https://discord.gg/VQck8X4"><img alt="Discord Chat" src="https://img.shields.io/discord/701068342760570933"/></a>
    <a href="https://gitlocalize.com/repo/7052/whole_project?utm_source=badge"> <img src="https://gitlocalize.com/repo/7052/whole_project/badge.svg" /> </a>
    <a href="https://blog.rust-lang.org/2020/12/31/Rust-1.56.1.html"><img alt="Rustc Version 1.56.1+" src="https://img.shields.io/badge/rustc-1.56%2B-lightgrey.svg"/></a>
  </p>

  <h4>
    <a href="https://yew.rs/">Documentation (stable)</a>
    <span> | </span>
    <a href="https://yew.rs/docs/next/">Documentation (latest)</a>
    <span> | </span>
    <a href="https://github.com/yewstack/yew/tree/master/examples">Examples</a>
    <span> | </span>
    <a href="https://github.com/yewstack/yew/blob/master/CHANGELOG.md">Changelog</a>
    <span> | </span>
    <a href="https://yew.rs/docs/more/roadmap">Roadmap</a>
    <span> | </span>
    <a href="https://yew.rs/zh-Hans">简体中文文档</a>
    <span> | </span>
    <a href="https://yew.rs/zh-Hant">繁體中文文檔</a>
    <span> | </span>
    <a href="https://yew.rs/ja">ドキュメント</a>
  </h4>
</div>

## About

**Yew** is a modern Rust framework for creating multi-threaded front-end web apps with WebAssembly.

* Features a macro for declaring interactive HTML with Rust expressions. Developers who have experience using JSX in React should feel quite at home when using Yew.
* Achieves high performance by minimizing DOM API calls for each page render and by making it easy to offload processing to background web workers.
* Supports JavaScript interoperability, allowing developers to leverage NPM packages and integrate with existing JavaScript applications.

*Note: Yew is not 1.0 yet. Be prepared to do major refactoring due to breaking API changes.*

## Contributing

Yew is a community effort and we welcome all kinds of contributions, big or small, from developers of all backgrounds. We want the Yew community to be a fun and friendly place, so please review our [Code of Conduct](https://github.com/yewstack/yew/blob/master/CODE_OF_CONDUCT.md) to learn what behavior will not be tolerated.

#### 🤠 New to Yew?

Start learning about the framework by helping us improve our [documentation](https://github.com/yewstack/yew/tree/master/website/docs). Pull requests which improve test coverage are also very welcome.

#### 😎 Looking for inspiration?

Check out the community curated list of awesome things related to Yew / WebAssembly at [jetli/awesome-yew](https://github.com/jetli/awesome-yew).

#### 🤔 Confused about something?

Feel free to drop into our [Discord chatroom](https://discord.gg/VQck8X4) or open a [new "Question" issue](https://github.com/yewstack/yew/issues/new/choose) to get help from contributors. Often questions lead to improvements to the ergonomics of the framework, better documentation, and even new features!

#### 🙂 Ready to dive into the code?

After reviewing the [Contribution Guide](https://github.com/yewstack/yew/blob/master/CONTRIBUTING.md), check out the ["Good First Issues"](https://github.com/yewstack/yew/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22) (they are eager for attention!). Once you find one that interests you, feel free to assign yourself to an issue and don't hesitate to reach out for guidance, the issues vary in complexity.

#### 😱 Found a bug?

Please [report all bugs!](https://github.com/yewstack/yew/issues/new/choose) We are happy to help support developers fix the bugs they find if they are interested and have the time.

#### 🤓 Want to help translate?

Translations can be submitted on the [Yew GitLocalize Repo](https://gitlocalize.com/repo/7052). If you are interested in being the official moderator for a language, please reach out on Discord.

## Contributors

### Code Contributors

This project exists thanks to all the people who contribute.
<a href="https://github.com/yewstack/yew/graphs/contributors"><img src="https://opencollective.com/yew/contributors.svg?width=890&button=false" /></a>

### Financial Contributors

Become a financial contributor and help us sustain our community. [[Contribute](https://opencollective.com/yew/contribute)]

#### Individuals

<a href="https://opencollective.com/yew"><img src="https://opencollective.com/yew/individuals.svg?width=890"></a>

#### Organizations

Support this project with your organization. Your logo will show up here with a link to your website. [[Contribute](https://opencollective.com/yew/contribute)]

<a href="https://opencollective.com/yew/organization/0/website"><img src="https://opencollective.com/yew/organization/0/avatar.svg"></a>
<a href="https://opencollective.com/yew/organization/1/website"><img src="https://opencollective.com/yew/organization/1/avatar.svg"></a>
<a href="https://opencollective.com/yew/organization/2/website"><img src="https://opencollective.com/yew/organization/2/avatar.svg"></a>
<a href="https://opencollective.com/yew/organization/3/website"><img src="https://opencollective.com/yew/organization/3/avatar.svg"></a>
<a href="https://opencollective.com/yew/organization/4/website"><img src="https://opencollective.com/yew/organization/4/avatar.svg"></a>
<a href="https://opencollective.com/yew/organization/5/website"><img src="https://opencollective.com/yew/organization/5/avatar.svg"></a>
<a href="https://opencollective.com/yew/organization/6/website"><img src="https://opencollective.com/yew/organization/6/avatar.svg"></a>
<a href="https://opencollective.com/yew/organization/7/website"><img src="https://opencollective.com/yew/organization/7/avatar.svg"></a>
<a href="https://opencollective.com/yew/organization/8/website"><img src="https://opencollective.com/yew/organization/8/avatar.svg"></a>
<a href="https://opencollective.com/yew/organization/9/website"><img src="https://opencollective.com/yew/organization/9/avatar.svg"></a>
