# The UI guided experience for Synthetic Data generation

[YData Fabric provides a robust, guided user interface (UI) specifically designed to streamline synthetic data generation](https://ydata.ai/products/fabric).
This interface is tailored to support users at every level, ensuring that both novice users and experienced data scientists can efficiently generate
synthetic datasets while adhering to best practices.

## Step-by-Step Workflow
The YData Fabric UI organizes the synthetic data generation process into a structured, step-by-step workflow. 
Each stage of the process is clearly defined and supported by guidance within the interface, helping users navigate tasks like data profiling,
metadata and synthesizer configuration and synthetic data quality evaluation.

- **Data Upload and Profiling:** Users start by uploading their datasets directly into the platform. YData Fabric’s profiling tool automatically scans
the data, generating insights into key attributes such as data distributions, correlations, and missing values. 
These insights are presented in an intuitive, visual format, ensuring users can quickly assess the quality and structure of their data.
- **Alerts for Data Issues:** The UI will alert users to potential issues such as data imbalances, outliers, or incomplete fields that may affect the
quality of the synthetic data. 
- **Synthetic Data Generation Model Configuration:** Once the data is profiled, the UI supports metadata configuration (categorical, numerical, dates, etc),
anonymization integration.
- **Model Performance Insights:** During the model training phase, YData Fabric monitors key performance indicators (KPIs) like fidelity, utility and privacy.
These KPIs, such as data fidelity and privacy scores, are displayed on the dashboard, allowing users to evaluate how closely the synthetic data aligns with the original dataset.
- **Customization and Advanced Controls:** For more experienced users, YData Fabric provides customization options within the guided UI. 
Users have access to advanced settings, such as [conditional synthetic data generation](https://ydata.ai/resources/conditional-synthetic-data-generation-for-robust-machine-learning-applications) or business rules.
- **Preserving Data Integrity:** For datasets requiring strict adherence to structural patterns (e.g., time-series data, healthcare records or databases).

### Getting started with YData Fabric (Community version)
YData Fabric’s Community Version offers users a free, accessible entry point to explore synthetic data generation. 
To get started, users can [sign up for the Community Version and access the guided UI directly](https://ydata.ai/register).
Once registered, users are provided with a range of features, including data profiling, synthetic data generation, pipelines and access to YData’s proprietary models for data quality!