# Open Data Cities Analysis
This repository provides an interactive and welcoming environment for data enthusiasts to learn and gain valuable experience through working with real-world open data from cities around the world.

We warmly welcome users to explore and analyze open data from cities worldwide, and share their insightful findings with the community by contributing their analyses. Moreover, we strongly support data transparency in cities, encouraging them to make their data available to the public. Our shared goal is to build a thriving community that embraces open data initiatives and collaborative learning.

## Projects
| No  | City       | Project                 | Description                                                                  | Author     |
| --- | ---------- | ----------------------- | ---------------------------------------------------------------------------- | ---------- |
| 1   | BeerSheba  | [Beersheba-Trees-Heatmap](https://github.com/yamtimor/Open-Data-Cities-Analysis/tree/main/BeerSheba/Beersheba-Trees-Heatmap) | The project aims to generate a heatmap using Beersheba municipality's API to visualize the distribution of trees in the city. | [Yam Timor](https://github.com/yamtimor) |

## How to contribute:
1. **Explore the Project:** Familiarize yourself with the project's goals and guidelines.
2. **select a city that has an open data portal:** If your city (or another city that interests you) has a public data portal, great! Otherwise, if you're looking for a good starting point, New York City has an excellent Open Data Portal, which you can find [here]( https://opendata.cityofnewyork.us/).
3. **Find a dataset that catches your interest:**  It's even cooler if there's a public API access instead of dealing with files.
4. **Fork the Repository:** Click the `Fork` button on the top right of the repository page.
5. **Create a New Branch:** On your forked repository, create a new branch using:
```
git checkout -b new-branch-name
```

6. **Make Your Changes:** Edit/add files and make your desired contributions.

- Each city should have its own folder: Create a new folder with the city's name if it doesn't exist, and avoid duplicating it if it already does.

- Each project should have its own folder inside the city folder: For existing city projects, place your files in the appropriate folder. For new projects in the city, create a new folder with a descriptive title for your project.

7. **Commit Your Changes:**
```
git commit -m "Your commit message"
```
8. **Push to Your Fork:**
```
git push origin new-branch-name
```
9. **Submit a Pull Request:** To create a pull request, click on `compare and pull requests`
10. **Add appropriate title and description:** Ensure your PR title and description include the name of the project and the related city.
11. **Click on `Create Pull Request`**
12. **Awsome! You've made a PR to the Open-Data-Cities-Analysis Project! 🚀**

## Contributors
<a href="https://github.com/yamtimor/Open-Data-Cities-Analysis/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=yamtimor/Open-Data-Cities-Analysis" />
</a>