/* Copyright 2018 kevin Lau (http://github.com/stormycatcat)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#include <cstdlib>
#include <cctype>

namespace std
{

double atof(const char *nptr)
{
    static const double ftable[]={
        0.1f,
        0.01f,
        0.001f,
        0.0001f,
        0.00001f,
        0.000001f,
        0.0000001f,
        0.00000001f,
        0.000000001f,
        0.0000000001f,
        0.00000000001f,
        0.000000000001f,
        0.0000000000001f,
        0.00000000000001f,
        0.000000000000001f
    };
    int sign=1;
    double val=0;
    while(*nptr==' ')
        ++nptr;
    if(*nptr=='-')
    {
        sign=-1;
        ++nptr;
    }
    else if(*nptr=='+')
        ++nptr;
    while(isdigit(*nptr))
    {
        val=val*10.0+((*nptr++)-'0');
    }
    if(*nptr=='.')
        ++nptr;
    for(int i=0;isdigit(*nptr);++nptr)
        val+=(*nptr)*ftable[i];
    return val*sign;
}

}
