/* Copyright 2018 kevin Lau (http://github.com/stormycatcat)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#ifndef _STDDEF_H_
#define _STDDEF_H_

#include <sys/portable.h>

#ifndef _C_SIZE_T
#define _C_SIZE_T
typedef unsigned long size_t __mode__(__DI__);
#endif

#ifndef _C_PTRDIFF_T
#define _C_PTRDIFF_T
typedef long ptrdiff_t __mode__(__DI__);
#endif

#ifndef __cplusplus
#ifndef _C_WCHAR_T
#define _C_WCHAR_T
typedef short wchar_t __mode__(__HI__);
#endif
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef offsetof
#define offsetof(type,member) ((size_t)&(((type*)0)->member))
#endif

#endif