# Why write docs


## You will be using your code in 6 months
Code that you wrote 6 months ago is often indistinguishable from code that someone else has written. You will look upon a file with a fond sense of remembrance. Then a sneaking feeling of foreboding, knowing that someone less experienced, less wise, had written it.

As you go through this selfless act of untangling things that were obvious or clever months ago, you will start to empathize with your users. If only I had written down why I had done this. Life would be so much simpler. Documentation allows you to transfer the why behind code. Much in the same way code comments explain the why, and not the how, documentation serves the same purpose.


## You want people to use your code
You have written a piece of code, and released it into the world. You have done this because you think that others might find it useful. However, people need to understand why your code might be useful for them, before they decide to use it. Documentation tells people that this project is for them.

> If people don’t know why your project exists, they won’t use it.
>
> If people can’t figure out how to install your code, they won’t use it.
>
> If people can’t figure out how to use your code, they won’t use it.

There are a small number of people who will source dive and use any code out there. That is a vanishingly small number of people, compared to people who will use your code when properly documented. If you really love your project, document it, and let other people use it.


## You want people to help out
Open source is this magical thing right? You release code, and the code gnomes come and make it better for you.

Not quite.

There are lots of ways that open source is amazing, but it doesn’t exist outside the laws of physics. You have to put work in, to get work out.
