# Contributing to PineDocs

Please take a moment to review this document in order to make the contribution process easy and effective for everyone involved.


## Reporting bugs

* Update to the most recent master release; the bug may already be fixed.
* Search for existing issues; it's possible someone has already encountered this bug.
* Try to isolate the problem and include steps to reproduce it.
* Share as much information as possible (e.g. browser/OS environment, log output, stack trace, screenshots, etc.).

All these details will help people to fix any potential bugs.


## Feature requests

Feature requests are welcome. But take a moment to find out whether your idea fits with the scope and aims of the project. It's up to you to make a strong case to convince the project's developers of the merits of this feature. Please provide as much detail and context as possible.


## Pull requests

Pull requests are a great help. They should remain focused in scope and avoid containing unrelated commits.

Any pull request should be based on the `master` branch.


## Coding style

* Use tabs for indentation
* No trailing whitespace; blank lines should have no spaces; new line at end-of-file
* Use the same coding style as the rest of the codebase
