/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbMakerConfigException;
import org.lionsoul.ip2region.DbSearcher;
import org.lionsoul.ip2region.Util;

public class TestSearcher {
    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("| Usage: java -jar ip2region-{version}.jar [ip2region db file]");
            return;
        }
        File file = new File(argv[0]);
        if (!file.exists()) {
            System.out.println("Error: Invalid ip2region.db file");
            return;
        }
        int algorithm = 1;
        String algoName = "B-tree";
        if (argv.length > 1) {
            if (argv[1].equalsIgnoreCase("binary")) {
                algoName = "Binary";
                algorithm = 2;
            } else if (argv[1].equalsIgnoreCase("memory")) {
                algoName = "Memory";
                algorithm = 3;
            }
        }
        try {
            System.out.println("initializing " + algoName + " ... ");
            DbConfig config = new DbConfig();
            DbSearcher searcher = new DbSearcher(config, argv[0]);
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            Method method = null;
            switch (algorithm) {
                case 1: {
                    method = searcher.getClass().getMethod("btreeSearch", String.class);
                    break;
                }
                case 2: {
                    method = searcher.getClass().getMethod("binarySearch", String.class);
                    break;
                }
                case 3: {
                    method = searcher.getClass().getMethod("memorySearch", String.class);
                }
            }
            System.out.println("+----------------------------------+");
            System.out.println("| ip2region test shell             |");
            System.out.println("| Author: chenxin619315@gmail.com  |");
            System.out.println("| Type 'quit' to exit program      |");
            System.out.println("+----------------------------------+");
            double sTime = 0.0;
            double cTime = 0.0;
            String line = null;
            DataBlock dataBlock = null;
            while (true) {
                System.out.print("ip2region>> ");
                line = reader.readLine().trim();
                if (line.length() < 2) continue;
                if (line.equalsIgnoreCase("quit")) break;
                if (!Util.isIpAddress(line)) {
                    System.out.println("Error: Invalid ip address");
                    continue;
                }
                sTime = System.nanoTime();
                dataBlock = (DataBlock)method.invoke((Object)searcher, line);
                cTime = ((double)System.nanoTime() - sTime) / 1000000.0;
                System.out.printf("%s in %.5f millseconds\n", dataBlock, cTime);
            }
            reader.close();
            searcher.close();
            System.out.println("+--Bye");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DbMakerConfigException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

