/*
 * Decompiled with CFR 0.152.
 */
package org.queryString.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.queryString.util.ByteArrayOutputStream2;
import org.queryString.util.IO;
import org.queryString.util.MultiMap;
import org.queryString.util.TypeUtil;
import org.queryString.util.Utf8Appendable;
import org.queryString.util.Utf8StringBuffer;
import org.queryString.util.Utf8StringBuilder;

public class UrlEncoded
extends MultiMap<String>
implements Cloneable {
    public static final Charset ENCODING;

    static {
        Charset encoding;
        try {
            String charset = System.getProperty("org.eclipse.jetty.util.UrlEncoding.charset");
            encoding = charset == null ? StandardCharsets.UTF_8 : Charset.forName(charset);
        }
        catch (Exception e) {
            encoding = StandardCharsets.UTF_8;
        }
        ENCODING = encoding;
    }

    public UrlEncoded(UrlEncoded url) {
        super(url);
    }

    public UrlEncoded() {
    }

    public UrlEncoded(String query) {
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, ENCODING);
    }

    public void decode(String query) {
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, ENCODING);
    }

    public void decode(String query, Charset charset) {
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, charset);
    }

    public String encode() {
        return this.encode(ENCODING, false);
    }

    public String encode(Charset charset) {
        return this.encode(charset, false);
    }

    public synchronized String encode(Charset charset, boolean equalsForNullValue) {
        return UrlEncoded.encode(this, charset, equalsForNullValue);
    }

    public static String encode(MultiMap<String> map, Charset charset, boolean equalsForNullValue) {
        if (charset == null) {
            charset = ENCODING;
        }
        StringBuilder result = new StringBuilder(128);
        boolean delim = false;
        for (Map.Entry entry : map.entrySet()) {
            String key = ((String)entry.getKey()).toString();
            List list = (List)entry.getValue();
            int s = list.size();
            if (delim) {
                result.append('&');
            }
            if (s == 0) {
                result.append(UrlEncoded.encodeString(key, charset));
                if (equalsForNullValue) {
                    result.append('=');
                }
            } else {
                int i = 0;
                while (i < s) {
                    if (i > 0) {
                        result.append('&');
                    }
                    String val = (String)list.get(i);
                    result.append(UrlEncoded.encodeString(key, charset));
                    if (val != null) {
                        String str = val.toString();
                        if (str.length() > 0) {
                            result.append('=');
                            result.append(UrlEncoded.encodeString(str, charset));
                        } else if (equalsForNullValue) {
                            result.append('=');
                        }
                    } else if (equalsForNullValue) {
                        result.append('=');
                    }
                    ++i;
                }
            }
            delim = true;
        }
        return result.toString();
    }

    public static void decodeTo(String content, MultiMap<String> map, String charset) {
        UrlEncoded.decodeTo(content, map, charset == null ? null : Charset.forName(charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String content, MultiMap<String> map, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        if (charset == StandardCharsets.UTF_8) {
            UrlEncoded.decodeUtf8To(content, 0, content.length(), map);
            return;
        }
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int mark = -1;
            boolean encoded = false;
            int i = 0;
            while (i < content.length()) {
                char c = content.charAt(i);
                switch (c) {
                    case '&': {
                        int l = i - mark - 1;
                        value = l == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l, charset) : content.substring(mark + 1, i));
                        mark = i;
                        encoded = false;
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        value = null;
                        break;
                    }
                    case '=': {
                        if (key != null) break;
                        key = encoded ? UrlEncoded.decodeString(content, mark + 1, i - mark - 1, charset) : content.substring(mark + 1, i);
                        mark = i;
                        encoded = false;
                        break;
                    }
                    case '+': {
                        encoded = true;
                        break;
                    }
                    case '%': {
                        encoded = true;
                    }
                }
                ++i;
            }
            if (key != null) {
                int l = content.length() - mark - 1;
                value = l == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l, charset) : content.substring(mark + 1));
                map.add(key, value);
            } else if (mark < content.length()) {
                String string = key = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                if (key != null && key.length() > 0) {
                    map.add(key, "");
                }
            }
        }
    }

    public static void decodeUtf8To(String query, MultiMap<String> map) {
        UrlEncoded.decodeUtf8To(query, 0, query.length(), map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(String query, int offset, int length, MultiMap<String> map) {
        Utf8StringBuilder buffer = new Utf8StringBuilder();
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int end = offset + length;
            int i = offset;
            while (i < end) {
                char c = query.charAt(i);
                try {
                    switch (c) {
                        case '&': {
                            value = buffer.toReplacedString();
                            buffer.reset();
                            if (key != null) {
                                map.add(key, value);
                            } else if (value != null && value.length() > 0) {
                                map.add(value, "");
                            }
                            key = null;
                            value = null;
                            break;
                        }
                        case '=': {
                            if (key != null) {
                                buffer.append(c);
                                break;
                            }
                            key = buffer.toReplacedString();
                            buffer.reset();
                            break;
                        }
                        case '+': {
                            buffer.append((byte)32);
                            break;
                        }
                        case '%': {
                            if (i + 2 < end) {
                                if ('u' == query.charAt(i + 1)) {
                                    if (++i + 4 < end) {
                                        char top = query.charAt(++i);
                                        char hi = query.charAt(++i);
                                        char lo = query.charAt(++i);
                                        char bot = query.charAt(++i);
                                        buffer.getStringBuilder().append(Character.toChars((TypeUtil.convertHexDigit(top) << 12) + (TypeUtil.convertHexDigit(hi) << 8) + (TypeUtil.convertHexDigit(lo) << 4) + TypeUtil.convertHexDigit(bot)));
                                        break;
                                    }
                                    buffer.getStringBuilder().append('\ufffd');
                                    i = end;
                                    break;
                                }
                                char hi = query.charAt(++i);
                                char lo = query.charAt(++i);
                                buffer.append((byte)((TypeUtil.convertHexDigit(hi) << 4) + TypeUtil.convertHexDigit(lo)));
                                break;
                            }
                            buffer.getStringBuilder().append('\ufffd');
                            i = end;
                            break;
                        }
                        default: {
                            buffer.append(c);
                            break;
                        }
                    }
                }
                catch (Utf8Appendable.NotUtf8Exception hi) {
                }
                catch (NumberFormatException e) {
                    buffer.append(Utf8Appendable.REPLACEMENT_UTF8, 0, 3);
                }
                ++i;
            }
            if (key != null) {
                value = buffer.toReplacedString();
                buffer.reset();
                map.add(key, value);
            } else if (buffer.length() > 0) {
                map.add(buffer.toReplacedString(), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode88591To(InputStream in, MultiMap<String> map, int maxLength, int maxKeys) throws IOException {
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            int b;
            StringBuffer buffer = new StringBuffer();
            String key = null;
            String value = null;
            int totalLength = 0;
            while ((b = in.read()) >= 0) {
                switch ((char)b) {
                    case '&': {
                        value = buffer.length() == 0 ? "" : buffer.toString();
                        buffer.setLength(0);
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        value = null;
                        if (maxKeys <= 0 || map.size() <= maxKeys) break;
                        throw new IllegalStateException("Form too many keys");
                    }
                    case '=': {
                        if (key != null) {
                            buffer.append((char)b);
                            break;
                        }
                        key = buffer.toString();
                        buffer.setLength(0);
                        break;
                    }
                    case '+': {
                        buffer.append(' ');
                        break;
                    }
                    case '%': {
                        int code1;
                        int code0 = in.read();
                        if (117 == code0) {
                            int code3;
                            int code2;
                            code1 = in.read();
                            if (code1 < 0 || (code2 = in.read()) < 0 || (code3 = in.read()) < 0) break;
                            buffer.append(Character.toChars((TypeUtil.convertHexDigit(code0) << 12) + (TypeUtil.convertHexDigit(code1) << 8) + (TypeUtil.convertHexDigit(code2) << 4) + TypeUtil.convertHexDigit(code3)));
                            break;
                        }
                        if (code0 < 0 || (code1 = in.read()) < 0) break;
                        buffer.append((char)((TypeUtil.convertHexDigit(code0) << 4) + TypeUtil.convertHexDigit(code1)));
                        break;
                    }
                    default: {
                        buffer.append((char)b);
                    }
                }
                if (maxLength < 0 || ++totalLength <= maxLength) continue;
                throw new IllegalStateException("Form too large");
            }
            if (key != null) {
                value = buffer.length() == 0 ? "" : buffer.toString();
                buffer.setLength(0);
                map.add(key, value);
            } else if (buffer.length() > 0) {
                map.add(buffer.toString(), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(InputStream in, MultiMap<String> map, int maxLength, int maxKeys) throws IOException {
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            int b;
            Utf8StringBuilder buffer = new Utf8StringBuilder();
            String key = null;
            String value = null;
            int totalLength = 0;
            while ((b = in.read()) >= 0) {
                try {
                    switch ((char)b) {
                        case '&': {
                            value = buffer.toReplacedString();
                            buffer.reset();
                            if (key != null) {
                                map.add(key, value);
                            } else if (value != null && value.length() > 0) {
                                map.add(value, "");
                            }
                            key = null;
                            value = null;
                            if (maxKeys > 0 && map.size() > maxKeys) {
                                throw new IllegalStateException("Form too many keys");
                            }
                            break;
                        }
                        case '=': {
                            if (key != null) {
                                buffer.append((byte)b);
                                break;
                            }
                            key = buffer.toReplacedString();
                            buffer.reset();
                            break;
                        }
                        case '+': {
                            buffer.append((byte)32);
                            break;
                        }
                        case '%': {
                            int code1;
                            int code0 = in.read();
                            boolean decoded = false;
                            if (117 == code0) {
                                int code3;
                                int code2;
                                code0 = in.read();
                                if (code0 >= 0 && (code1 = in.read()) >= 0 && (code2 = in.read()) >= 0 && (code3 = in.read()) >= 0) {
                                    buffer.getStringBuilder().append(Character.toChars((TypeUtil.convertHexDigit(code0) << 12) + (TypeUtil.convertHexDigit(code1) << 8) + (TypeUtil.convertHexDigit(code2) << 4) + TypeUtil.convertHexDigit(code3)));
                                    decoded = true;
                                }
                            } else if (code0 >= 0 && (code1 = in.read()) >= 0) {
                                buffer.append((byte)((TypeUtil.convertHexDigit(code0) << 4) + TypeUtil.convertHexDigit(code1)));
                                decoded = true;
                            }
                            if (!decoded) {
                                buffer.getStringBuilder().append('\ufffd');
                            }
                            break;
                        }
                        default: {
                            buffer.append((byte)b);
                            break;
                        }
                    }
                }
                catch (Utf8Appendable.NotUtf8Exception code0) {
                }
                catch (NumberFormatException e) {
                    buffer.append(Utf8Appendable.REPLACEMENT_UTF8, 0, 3);
                }
                if (maxLength < 0 || ++totalLength <= maxLength) continue;
                throw new IllegalStateException("Form too large");
            }
            if (key != null) {
                value = buffer.toReplacedString();
                buffer.reset();
                map.add(key, value);
            } else if (buffer.length() > 0) {
                map.add(buffer.toReplacedString(), "");
            }
        }
    }

    public static void decodeUtf16To(InputStream in, MultiMap<String> map, int maxLength, int maxKeys) throws IOException {
        InputStreamReader input = new InputStreamReader(in, StandardCharsets.UTF_16);
        StringWriter buf = new StringWriter(8192);
        IO.copy(input, buf, (long)maxLength);
        UrlEncoded.decodeTo(buf.getBuffer().toString(), map, StandardCharsets.UTF_16);
    }

    public static void decodeTo(InputStream in, MultiMap<String> map, String charset, int maxLength, int maxKeys) throws IOException {
        if (charset == null) {
            if (ENCODING.equals(StandardCharsets.UTF_8)) {
                UrlEncoded.decodeUtf8To(in, map, maxLength, maxKeys);
            } else {
                UrlEncoded.decodeTo(in, map, ENCODING, maxLength, maxKeys);
            }
        } else if ("utf-8".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf8To(in, map, maxLength, maxKeys);
        } else if ("iso-8859-1".equalsIgnoreCase(charset)) {
            UrlEncoded.decode88591To(in, map, maxLength, maxKeys);
        } else if ("utf-16".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf16To(in, map, maxLength, maxKeys);
        } else {
            UrlEncoded.decodeTo(in, map, Charset.forName(charset), maxLength, maxKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(InputStream in, MultiMap<String> map, Charset charset, int maxLength, int maxKeys) throws IOException {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(in, map, maxLength, maxKeys);
            return;
        }
        if (StandardCharsets.ISO_8859_1.equals(charset)) {
            UrlEncoded.decode88591To(in, map, maxLength, maxKeys);
            return;
        }
        if (StandardCharsets.UTF_16.equals(charset)) {
            UrlEncoded.decodeUtf16To(in, map, maxLength, maxKeys);
            return;
        }
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int totalLength = 0;
            Throwable throwable = null;
            Object var11_11 = null;
            try (ByteArrayOutputStream2 output = new ByteArrayOutputStream2();){
                int c;
                int size = 0;
                while ((c = in.read()) > 0) {
                    switch ((char)c) {
                        case '&': {
                            size = output.size();
                            value = size == 0 ? "" : output.toString(charset);
                            output.setCount(0);
                            if (key != null) {
                                map.add(key, value);
                            } else if (value != null && value.length() > 0) {
                                map.add(value, "");
                            }
                            key = null;
                            value = null;
                            if (maxKeys <= 0 || map.size() <= maxKeys) break;
                            throw new IllegalStateException("Form too many keys");
                        }
                        case '=': {
                            if (key != null) {
                                output.write(c);
                                break;
                            }
                            size = output.size();
                            key = size == 0 ? "" : output.toString(charset);
                            output.setCount(0);
                            break;
                        }
                        case '+': {
                            output.write(32);
                            break;
                        }
                        case '%': {
                            int code1;
                            int code0 = in.read();
                            if (117 == code0) {
                                int code3;
                                int code2;
                                code1 = in.read();
                                if (code1 < 0 || (code2 = in.read()) < 0 || (code3 = in.read()) < 0) break;
                                output.write(new String(Character.toChars((TypeUtil.convertHexDigit(code0) << 12) + (TypeUtil.convertHexDigit(code1) << 8) + (TypeUtil.convertHexDigit(code2) << 4) + TypeUtil.convertHexDigit(code3))).getBytes(charset));
                                break;
                            }
                            if (code0 < 0 || (code1 = in.read()) < 0) break;
                            output.write((TypeUtil.convertHexDigit(code0) << 4) + TypeUtil.convertHexDigit(code1));
                            break;
                        }
                        default: {
                            output.write(c);
                        }
                    }
                    if (maxLength < 0 || ++totalLength <= maxLength) continue;
                    throw new IllegalStateException("Form too large");
                }
                size = output.size();
                if (key != null) {
                    value = size == 0 ? "" : output.toString(charset);
                    output.setCount(0);
                    map.add(key, value);
                } else if (size > 0) {
                    map.add(output.toString(charset), "");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static String decodeString(String encoded) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), ENCODING);
    }

    public static String decodeString(String encoded, int offset, int length, Charset charset) {
        if (charset == null || StandardCharsets.UTF_8.equals(charset)) {
            Utf8Appendable buffer = null;
            int i = 0;
            while (i < length) {
                block49: {
                    char c = encoded.charAt(offset + i);
                    if (c < '\u0000' || c > '\u00ff') {
                        if (buffer == null) {
                            buffer = new Utf8StringBuffer(length);
                            ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, offset, offset + i + 1);
                        } else {
                            ((Utf8StringBuffer)buffer).getStringBuffer().append(c);
                        }
                    } else if (c == '+') {
                        if (buffer == null) {
                            buffer = new Utf8StringBuffer(length);
                            ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, offset, offset + i);
                        }
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(' ');
                    } else if (c == '%') {
                        if (buffer == null) {
                            buffer = new Utf8StringBuffer(length);
                            ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, offset, offset + i);
                        }
                        if (i + 2 < length) {
                            try {
                                if ('u' == encoded.charAt(offset + i + 1)) {
                                    if (i + 5 < length) {
                                        int o = offset + i + 2;
                                        i += 5;
                                        String unicode = new String(Character.toChars(TypeUtil.parseInt(encoded, o, 4, 16)));
                                        ((Utf8StringBuffer)buffer).getStringBuffer().append(unicode);
                                    } else {
                                        i = length;
                                        ((Utf8StringBuffer)buffer).getStringBuffer().append('\ufffd');
                                    }
                                    break block49;
                                }
                                int o = offset + i + 1;
                                i += 2;
                                byte b = (byte)TypeUtil.parseInt(encoded, o, 2, 16);
                                buffer.append(b);
                            }
                            catch (Utf8Appendable.NotUtf8Exception o) {
                            }
                            catch (NumberFormatException e) {
                                ((Utf8StringBuffer)buffer).getStringBuffer().append('\ufffd');
                            }
                        } else {
                            ((Utf8StringBuffer)buffer).getStringBuffer().append('\ufffd');
                            i = length;
                        }
                    } else if (buffer != null) {
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(c);
                    }
                }
                ++i;
            }
            if (buffer == null) {
                if (offset == 0 && encoded.length() == length) {
                    return encoded;
                }
                return encoded.substring(offset, offset + length);
            }
            return buffer.toReplacedString();
        }
        StringBuffer buffer = null;
        int i = 0;
        while (i < length) {
            char c = encoded.charAt(offset + i);
            if (c < '\u0000' || c > '\u00ff') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded, offset, offset + i + 1);
                } else {
                    buffer.append(c);
                }
            } else if (c == '+') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded, offset, offset + i);
                }
                buffer.append(' ');
            } else if (c == '%') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded, offset, offset + i);
                }
                byte[] ba = new byte[length];
                int n = 0;
                while (c >= '\u0000' && c <= '\u00ff') {
                    block50: {
                        if (c == '%') {
                            if (i + 2 < length) {
                                try {
                                    if ('u' == encoded.charAt(offset + i + 1)) {
                                        if (i + 6 < length) {
                                            int o = offset + i + 2;
                                            i += 6;
                                            String unicode = new String(Character.toChars(TypeUtil.parseInt(encoded, o, 4, 16)));
                                            byte[] reencoded = unicode.getBytes(charset);
                                            System.arraycopy(reencoded, 0, ba, n, reencoded.length);
                                            n += reencoded.length;
                                        } else {
                                            ba[n++] = 63;
                                            i = length;
                                        }
                                        break block50;
                                    }
                                    int o = offset + i + 1;
                                    i += 3;
                                    ba[n] = (byte)TypeUtil.parseInt(encoded, o, 2, 16);
                                    ++n;
                                }
                                catch (Exception e) {
                                    ba[n++] = 63;
                                }
                            } else {
                                ba[n++] = 63;
                                i = length;
                            }
                        } else if (c == '+') {
                            ba[n++] = 32;
                            ++i;
                        } else {
                            ba[n++] = (byte)c;
                            ++i;
                        }
                    }
                    if (i >= length) break;
                    c = encoded.charAt(offset + i);
                }
                --i;
                buffer.append(new String(ba, 0, n, charset));
            } else if (buffer != null) {
                buffer.append(c);
            }
            ++i;
        }
        if (buffer == null) {
            if (offset == 0 && encoded.length() == length) {
                return encoded;
            }
            return encoded.substring(offset, offset + length);
        }
        return buffer.toString();
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, ENCODING);
    }

    public static String encodeString(String string, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        byte[] bytes = null;
        bytes = string.getBytes(charset);
        int len = bytes.length;
        byte[] encoded = new byte[bytes.length * 3];
        int n = 0;
        boolean noEncode = true;
        int i = 0;
        while (i < len) {
            byte b = bytes[i];
            if (b == 32) {
                noEncode = false;
                encoded[n++] = 43;
            } else if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57) {
                encoded[n++] = b;
            } else {
                noEncode = false;
                encoded[n++] = 37;
                byte nibble = (byte)((b & 0xF0) >> 4);
                encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
                nibble = (byte)(b & 0xF);
                encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            }
            ++i;
        }
        if (noEncode) {
            return string;
        }
        return new String(encoded, 0, n, charset);
    }

    @Override
    public Object clone() {
        return new UrlEncoded(this);
    }
}

