/*
 * Decompiled with CFR 0.152.
 */
package org.queryString.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.queryString.util.AbstractTrie;

public class TreeTrie<V>
extends AbstractTrie<V> {
    private static final int[] __lookup;
    private static final int INDEX = 32;
    private final TreeTrie<V>[] _nextIndex;
    private final List<TreeTrie<V>> _nextOther = new ArrayList<TreeTrie<V>>();
    private final char _c;
    private String _key;
    private V _value;

    static {
        int[] nArray = new int[128];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        nArray[12] = -1;
        nArray[13] = -1;
        nArray[14] = -1;
        nArray[15] = -1;
        nArray[16] = -1;
        nArray[17] = -1;
        nArray[18] = -1;
        nArray[19] = -1;
        nArray[20] = -1;
        nArray[21] = -1;
        nArray[22] = -1;
        nArray[23] = -1;
        nArray[24] = -1;
        nArray[25] = -1;
        nArray[26] = -1;
        nArray[27] = -1;
        nArray[28] = -1;
        nArray[29] = -1;
        nArray[30] = -1;
        nArray[31] = -1;
        nArray[32] = 31;
        nArray[33] = -1;
        nArray[34] = -1;
        nArray[35] = -1;
        nArray[36] = -1;
        nArray[37] = -1;
        nArray[38] = -1;
        nArray[39] = -1;
        nArray[40] = -1;
        nArray[41] = -1;
        nArray[42] = -1;
        nArray[43] = 26;
        nArray[44] = -1;
        nArray[45] = 27;
        nArray[46] = 30;
        nArray[47] = -1;
        nArray[48] = -1;
        nArray[49] = -1;
        nArray[50] = -1;
        nArray[51] = -1;
        nArray[52] = -1;
        nArray[53] = -1;
        nArray[54] = -1;
        nArray[55] = -1;
        nArray[56] = -1;
        nArray[57] = -1;
        nArray[58] = 28;
        nArray[59] = 29;
        nArray[60] = -1;
        nArray[61] = -1;
        nArray[62] = -1;
        nArray[63] = -1;
        nArray[64] = -1;
        nArray[66] = 1;
        nArray[67] = 2;
        nArray[68] = 3;
        nArray[69] = 4;
        nArray[70] = 5;
        nArray[71] = 6;
        nArray[72] = 7;
        nArray[73] = 8;
        nArray[74] = 9;
        nArray[75] = 10;
        nArray[76] = 11;
        nArray[77] = 12;
        nArray[78] = 13;
        nArray[79] = 14;
        nArray[80] = 15;
        nArray[81] = 16;
        nArray[82] = 17;
        nArray[83] = 18;
        nArray[84] = 19;
        nArray[85] = 20;
        nArray[86] = 21;
        nArray[87] = 22;
        nArray[88] = 23;
        nArray[89] = 24;
        nArray[90] = 25;
        nArray[91] = -1;
        nArray[92] = -1;
        nArray[93] = -1;
        nArray[94] = -1;
        nArray[95] = -1;
        nArray[96] = -1;
        nArray[98] = 1;
        nArray[99] = 2;
        nArray[100] = 3;
        nArray[101] = 4;
        nArray[102] = 5;
        nArray[103] = 6;
        nArray[104] = 7;
        nArray[105] = 8;
        nArray[106] = 9;
        nArray[107] = 10;
        nArray[108] = 11;
        nArray[109] = 12;
        nArray[110] = 13;
        nArray[111] = 14;
        nArray[112] = 15;
        nArray[113] = 16;
        nArray[114] = 17;
        nArray[115] = 18;
        nArray[116] = 19;
        nArray[117] = 20;
        nArray[118] = 21;
        nArray[119] = 22;
        nArray[120] = 23;
        nArray[121] = 24;
        nArray[122] = 25;
        nArray[123] = -1;
        nArray[124] = -1;
        nArray[125] = -1;
        nArray[126] = -1;
        nArray[127] = -1;
        __lookup = nArray;
    }

    public TreeTrie() {
        super(true);
        this._nextIndex = new TreeTrie[32];
        this._c = '\u0000';
    }

    private TreeTrie(char c) {
        super(true);
        this._nextIndex = new TreeTrie[32];
        this._c = c;
    }

    @Override
    public void clear() {
        Arrays.fill(this._nextIndex, null);
        this._nextOther.clear();
        this._key = null;
        this._value = null;
    }

    @Override
    public boolean put(String s, V v) {
        TreeTrie<V> t = this;
        int limit = s.length();
        int k = 0;
        while (k < limit) {
            int index;
            char c = s.charAt(k);
            int n = index = c >= '\u0000' && c < '\u007f' ? __lookup[c] : -1;
            if (index >= 0) {
                if (t._nextIndex[index] == null) {
                    t._nextIndex[index] = new TreeTrie<V>(c);
                }
                t = t._nextIndex[index];
            } else {
                TreeTrie<V> n2 = null;
                int i = t._nextOther.size();
                while (i-- > 0) {
                    n2 = t._nextOther.get(i);
                    if (n2._c == c) break;
                    n2 = null;
                }
                if (n2 == null) {
                    n2 = new TreeTrie<V>(c);
                    t._nextOther.add(n2);
                }
                t = n2;
            }
            ++k;
        }
        t._key = v == null ? null : s;
        t._value = v;
        return true;
    }

    @Override
    public V get(String s, int offset, int len) {
        TreeTrie<V> t = this;
        int i = 0;
        while (i < len) {
            int index;
            char c = s.charAt(offset + i);
            int n = index = c >= '\u0000' && c < '\u007f' ? __lookup[c] : -1;
            if (index >= 0) {
                if (t._nextIndex[index] == null) {
                    return null;
                }
                t = t._nextIndex[index];
            } else {
                TreeTrie<V> n2 = null;
                int j = t._nextOther.size();
                while (j-- > 0) {
                    n2 = t._nextOther.get(j);
                    if (n2._c == c) break;
                    n2 = null;
                }
                if (n2 == null) {
                    return null;
                }
                t = n2;
            }
            ++i;
        }
        return t._value;
    }

    @Override
    public V get(ByteBuffer b, int offset, int len) {
        TreeTrie<V> t = this;
        int i = 0;
        while (i < len) {
            int index;
            byte c = b.get(offset + i);
            int n = index = c >= 0 && c < 127 ? __lookup[c] : -1;
            if (index >= 0) {
                if (t._nextIndex[index] == null) {
                    return null;
                }
                t = t._nextIndex[index];
            } else {
                TreeTrie<V> n2 = null;
                int j = t._nextOther.size();
                while (j-- > 0) {
                    n2 = t._nextOther.get(j);
                    if (n2._c == c) break;
                    n2 = null;
                }
                if (n2 == null) {
                    return null;
                }
                t = n2;
            }
            ++i;
        }
        return t._value;
    }

    @Override
    public V getBest(byte[] b, int offset, int len) {
        TreeTrie<V> t = this;
        int i = 0;
        while (i < len) {
            int index;
            byte c = b[offset + i];
            int n = index = c >= 0 && c < 127 ? __lookup[c] : -1;
            if (index >= 0) {
                if (t._nextIndex[index] == null) break;
                t = t._nextIndex[index];
            } else {
                TreeTrie<V> n2 = null;
                int j = t._nextOther.size();
                while (j-- > 0) {
                    n2 = t._nextOther.get(j);
                    if (n2._c == c) break;
                    n2 = null;
                }
                if (n2 == null) break;
                t = n2;
            }
            if (t._key != null) {
                V best = t.getBest(b, offset + i + 1, len - i - 1);
                if (best == null) break;
                return best;
            }
            ++i;
        }
        return t._value;
    }

    @Override
    public V getBest(String s, int offset, int len) {
        TreeTrie<V> t = this;
        int i = 0;
        while (i < len) {
            int index;
            byte c = (byte)(0xFF & s.charAt(offset + i));
            int n = index = c >= 0 && c < 127 ? __lookup[c] : -1;
            if (index >= 0) {
                if (t._nextIndex[index] == null) break;
                t = t._nextIndex[index];
            } else {
                TreeTrie<V> n2 = null;
                int j = t._nextOther.size();
                while (j-- > 0) {
                    n2 = t._nextOther.get(j);
                    if (n2._c == c) break;
                    n2 = null;
                }
                if (n2 == null) break;
                t = n2;
            }
            if (t._key != null) {
                V best = t.getBest(s, offset + i + 1, len - i - 1);
                if (best == null) break;
                return best;
            }
            ++i;
        }
        return t._value;
    }

    @Override
    public V getBest(ByteBuffer b, int offset, int len) {
        if (b.hasArray()) {
            return this.getBest(b.array(), b.arrayOffset() + b.position() + offset, len);
        }
        return this.getBestByteBuffer(b, offset, len);
    }

    private V getBestByteBuffer(ByteBuffer b, int offset, int len) {
        TreeTrie<V> t = this;
        int pos = b.position() + offset;
        int i = 0;
        while (i < len) {
            byte c;
            int index;
            int n = index = (c = b.get(pos++)) >= 0 && c < 127 ? __lookup[c] : -1;
            if (index >= 0) {
                if (t._nextIndex[index] == null) break;
                t = t._nextIndex[index];
            } else {
                TreeTrie<V> n2 = null;
                int j = t._nextOther.size();
                while (j-- > 0) {
                    n2 = t._nextOther.get(j);
                    if (n2._c == c) break;
                    n2 = null;
                }
                if (n2 == null) break;
                t = n2;
            }
            if (t._key != null) {
                V best = t.getBest(b, offset + i + 1, len - i - 1);
                if (best == null) break;
                return best;
            }
            ++i;
        }
        return t._value;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        TreeTrie.toString(buf, this);
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return buf.toString();
    }

    private static <V> void toString(Appendable out, TreeTrie<V> t) {
        if (t != null) {
            if (t._value != null) {
                try {
                    out.append(',');
                    out.append(t._key);
                    out.append('=');
                    out.append(t._value.toString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            int i = 0;
            while (i < 32) {
                if (t._nextIndex[i] != null) {
                    TreeTrie.toString(out, t._nextIndex[i]);
                }
                ++i;
            }
            i = t._nextOther.size();
            while (i-- > 0) {
                TreeTrie.toString(out, t._nextOther.get(i));
            }
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        TreeTrie.keySet(keys, this);
        return keys;
    }

    private static <V> void keySet(Set<String> set, TreeTrie<V> t) {
        if (t != null) {
            if (t._key != null) {
                set.add(t._key);
            }
            int i = 0;
            while (i < 32) {
                if (t._nextIndex[i] != null) {
                    TreeTrie.keySet(set, t._nextIndex[i]);
                }
                ++i;
            }
            i = t._nextOther.size();
            while (i-- > 0) {
                TreeTrie.keySet(set, t._nextOther.get(i));
            }
        }
    }

    @Override
    public boolean isFull() {
        return false;
    }
}

