/*
 * Decompiled with CFR 0.152.
 */
package org.queryString.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.queryString.util.AbstractTrie;

public class ArrayTrie<V>
extends AbstractTrie<V> {
    private static final int ROW_SIZE = 32;
    private static final int[] __lookup;
    private final char[] _rowIndex;
    private final String[] _key;
    private final V[] _value;
    private char[][] _bigIndex;
    private char _rows;

    static {
        int[] nArray = new int[128];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        nArray[12] = -1;
        nArray[13] = -1;
        nArray[14] = -1;
        nArray[15] = -1;
        nArray[16] = -1;
        nArray[17] = -1;
        nArray[18] = -1;
        nArray[19] = -1;
        nArray[20] = -1;
        nArray[21] = -1;
        nArray[22] = -1;
        nArray[23] = -1;
        nArray[24] = -1;
        nArray[25] = -1;
        nArray[26] = -1;
        nArray[27] = -1;
        nArray[28] = -1;
        nArray[29] = -1;
        nArray[30] = -1;
        nArray[31] = -1;
        nArray[32] = 31;
        nArray[33] = -1;
        nArray[34] = -1;
        nArray[35] = -1;
        nArray[36] = -1;
        nArray[37] = -1;
        nArray[38] = -1;
        nArray[39] = -1;
        nArray[40] = -1;
        nArray[41] = -1;
        nArray[42] = -1;
        nArray[43] = 26;
        nArray[44] = -1;
        nArray[45] = 27;
        nArray[46] = 30;
        nArray[47] = -1;
        nArray[48] = -1;
        nArray[49] = -1;
        nArray[50] = -1;
        nArray[51] = -1;
        nArray[52] = -1;
        nArray[53] = -1;
        nArray[54] = -1;
        nArray[55] = -1;
        nArray[56] = -1;
        nArray[57] = -1;
        nArray[58] = 28;
        nArray[59] = 29;
        nArray[60] = -1;
        nArray[61] = -1;
        nArray[62] = -1;
        nArray[63] = -1;
        nArray[64] = -1;
        nArray[66] = 1;
        nArray[67] = 2;
        nArray[68] = 3;
        nArray[69] = 4;
        nArray[70] = 5;
        nArray[71] = 6;
        nArray[72] = 7;
        nArray[73] = 8;
        nArray[74] = 9;
        nArray[75] = 10;
        nArray[76] = 11;
        nArray[77] = 12;
        nArray[78] = 13;
        nArray[79] = 14;
        nArray[80] = 15;
        nArray[81] = 16;
        nArray[82] = 17;
        nArray[83] = 18;
        nArray[84] = 19;
        nArray[85] = 20;
        nArray[86] = 21;
        nArray[87] = 22;
        nArray[88] = 23;
        nArray[89] = 24;
        nArray[90] = 25;
        nArray[91] = -1;
        nArray[92] = -1;
        nArray[93] = -1;
        nArray[94] = -1;
        nArray[95] = -1;
        nArray[96] = -1;
        nArray[98] = 1;
        nArray[99] = 2;
        nArray[100] = 3;
        nArray[101] = 4;
        nArray[102] = 5;
        nArray[103] = 6;
        nArray[104] = 7;
        nArray[105] = 8;
        nArray[106] = 9;
        nArray[107] = 10;
        nArray[108] = 11;
        nArray[109] = 12;
        nArray[110] = 13;
        nArray[111] = 14;
        nArray[112] = 15;
        nArray[113] = 16;
        nArray[114] = 17;
        nArray[115] = 18;
        nArray[116] = 19;
        nArray[117] = 20;
        nArray[118] = 21;
        nArray[119] = 22;
        nArray[120] = 23;
        nArray[121] = 24;
        nArray[122] = 25;
        nArray[123] = -1;
        nArray[124] = -1;
        nArray[125] = -1;
        nArray[126] = -1;
        nArray[127] = -1;
        __lookup = nArray;
    }

    public ArrayTrie() {
        this(128);
    }

    public ArrayTrie(int capacity) {
        super(true);
        this._value = new Object[capacity];
        this._rowIndex = new char[capacity * 32];
        this._key = new String[capacity];
    }

    @Override
    public void clear() {
        this._rows = '\u0000';
        Arrays.fill(this._value, null);
        Arrays.fill(this._rowIndex, '\u0000');
        Arrays.fill(this._key, null);
    }

    @Override
    public boolean put(String s, V v) {
        int t = 0;
        int limit = s.length();
        int k = 0;
        while (k < limit) {
            char c = s.charAt(k);
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = t * 32 + index;
                if ((t = this._rowIndex[idx]) == 0) {
                    this._rows = (char)(this._rows + '\u0001');
                    if (this._rows >= this._value.length) {
                        return false;
                    }
                    this._rowIndex[idx] = this._rows;
                    t = this._rowIndex[idx];
                }
            } else {
                if (c > '\u007f') {
                    throw new IllegalArgumentException("non ascii character");
                }
                if (this._bigIndex == null) {
                    this._bigIndex = new char[this._value.length][];
                }
                if (t >= this._bigIndex.length) {
                    return false;
                }
                char[] big = this._bigIndex[t];
                if (big == null) {
                    this._bigIndex[t] = new char[128];
                    big = this._bigIndex[t];
                }
                if ((t = big[c]) == 0) {
                    if (this._rows == this._value.length) {
                        return false;
                    }
                    big[c] = this._rows = (char)(this._rows + '\u0001');
                    t = this._rows;
                }
            }
            ++k;
        }
        if (t >= this._key.length) {
            this._rows = (char)this._key.length;
            return false;
        }
        this._key[t] = v == null ? null : s;
        this._value[t] = v;
        return true;
    }

    @Override
    public V get(String s, int offset, int len) {
        int t = 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(offset + i);
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = t * 32 + index;
                if ((t = this._rowIndex[idx]) == 0) {
                    return null;
                }
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
                if (big == null) {
                    return null;
                }
                t = big[c];
                if (t == 0) {
                    return null;
                }
            }
            ++i;
        }
        return this._value[t];
    }

    @Override
    public V get(ByteBuffer b, int offset, int len) {
        int t = 0;
        int i = 0;
        while (i < len) {
            byte c = b.get(offset + i);
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = t * 32 + index;
                if ((t = this._rowIndex[idx]) == 0) {
                    return null;
                }
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
                if (big == null) {
                    return null;
                }
                t = big[c];
                if (t == 0) {
                    return null;
                }
            }
            ++i;
        }
        return this._value[t];
    }

    @Override
    public V getBest(byte[] b, int offset, int len) {
        return this.getBest(0, b, offset, len);
    }

    @Override
    public V getBest(ByteBuffer b, int offset, int len) {
        if (b.hasArray()) {
            return this.getBest(0, b.array(), b.arrayOffset() + b.position() + offset, len);
        }
        return this.getBest(0, b, offset, len);
    }

    @Override
    public V getBest(String s, int offset, int len) {
        return this.getBest(0, s, offset, len);
    }

    private V getBest(int t, String s, int offset, int len) {
        int pos = offset;
        int i = 0;
        while (i < len) {
            int nt;
            char c;
            int index;
            if ((index = __lookup[(c = s.charAt(pos++)) & 0x7F]) >= 0) {
                int idx = t * 32 + index;
                nt = this._rowIndex[idx];
                if (nt == 0) break;
                t = nt;
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
                if (big == null) {
                    return null;
                }
                nt = big[c];
                if (nt == 0) break;
                t = nt;
            }
            if (this._key[t] != null) {
                V best = this.getBest(t, s, offset + i + 1, len - i - 1);
                if (best != null) {
                    return best;
                }
                return this._value[t];
            }
            ++i;
        }
        return this._value[t];
    }

    private V getBest(int t, byte[] b, int offset, int len) {
        int i = 0;
        while (i < len) {
            int nt;
            byte c = b[offset + i];
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = t * 32 + index;
                nt = this._rowIndex[idx];
                if (nt == 0) break;
                t = nt;
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
                if (big == null) {
                    return null;
                }
                nt = big[c];
                if (nt == 0) break;
                t = nt;
            }
            if (this._key[t] != null) {
                V best = this.getBest(t, b, offset + i + 1, len - i - 1);
                if (best == null) break;
                return best;
            }
            ++i;
        }
        return this._value[t];
    }

    private V getBest(int t, ByteBuffer b, int offset, int len) {
        int pos = b.position() + offset;
        int i = 0;
        while (i < len) {
            int nt;
            byte c;
            int index;
            if ((index = __lookup[(c = b.get(pos++)) & 0x7F]) >= 0) {
                int idx = t * 32 + index;
                nt = this._rowIndex[idx];
                if (nt == 0) break;
                t = nt;
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
                if (big == null) {
                    return null;
                }
                nt = big[c];
                if (nt == 0) break;
                t = nt;
            }
            if (this._key[t] != null) {
                V best = this.getBest(t, b, offset + i + 1, len - i - 1);
                if (best == null) break;
                return best;
            }
            ++i;
        }
        return this._value[t];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf, 0);
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return buf.toString();
    }

    private void toString(Appendable out, int t) {
        char[] big;
        if (this._value[t] != null) {
            try {
                out.append(',');
                out.append(this._key[t]);
                out.append('=');
                out.append(this._value[t].toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        int i = 0;
        while (i < 32) {
            int idx = t * 32 + i;
            if (this._rowIndex[idx] != '\u0000') {
                this.toString(out, this._rowIndex[idx]);
            }
            ++i;
        }
        char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
        if (big != null) {
            char[] cArray2 = big;
            int n = big.length;
            int n2 = 0;
            while (n2 < n) {
                char i2 = cArray2[n2];
                if (i2 != '\u0000') {
                    this.toString(out, i2);
                }
                ++n2;
            }
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        this.keySet(keys, 0);
        return keys;
    }

    private void keySet(Set<String> set, int t) {
        char[] big;
        if (t < this._value.length && this._value[t] != null) {
            set.add(this._key[t]);
        }
        int i = 0;
        while (i < 32) {
            int idx = t * 32 + i;
            if (idx < this._rowIndex.length && this._rowIndex[idx] != '\u0000') {
                this.keySet(set, this._rowIndex[idx]);
            }
            ++i;
        }
        char[] cArray = big = this._bigIndex == null || t >= this._bigIndex.length ? null : this._bigIndex[t];
        if (big != null) {
            char[] cArray2 = big;
            int n = big.length;
            int n2 = 0;
            while (n2 < n) {
                char i2 = cArray2[n2];
                if (i2 != '\u0000') {
                    this.keySet(set, i2);
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean isFull() {
        return this._rows + '\u0001' >= this._key.length;
    }
}

