---
type: "Intro"
category: "Introduction"
parent: "Information"
title: "Information"
description: "Project information."
---

<p></p>

<p align="center">
  <a href="https://xtendui.com/" title="Xtend UI" style="display: inline-block;">
    <img src="https://raw.githubusercontent.com/xtendui/xtendui/master/public/logo-bg.svg" loading="eager" alt="Xtend UI" width="200">
  </a>
</p>

<p align="center">
  <a href="https://xtendui.com/intro" target="_blank">Intro</a>&nbsp;&nbsp;·&nbsp;&nbsp;<a href="https://xtendui.com/components" target="_blank">Components</a>&nbsp;&nbsp;·&nbsp;&nbsp;<a href="https://xtendui.com/themes" target="_blank">Themes</a>
  <br/><br/>
  <a href="https://github.com/xtendui/xtendui/blob/master/LICENSE.txt" target="_blank" title="License" style="display: inline-block;">
    <img src="https://img.shields.io/npm/l/xtendui.svg?style=flat-square" alt="License" loading="eager">
  </a>
  <a href="https://twitter.com/intent/tweet?text=Xtend%20UI%20a%20new%20powerful%20frontend%20library%20of%20tailwind%20components%20enhanced%20by%20vanilla%20js&url=https://xtendui.com/&via=xtendui&hashtags=xtendui" target="_blank" title="Tweet" style="display: inline-block;">
    <img src="https://img.shields.io/twitter/url/http/shields.io.svg?style=social" alt="Tweet" loading="eager">
  </a>
  <a href="https://github.com/xtendui/xtendui" target="_blank" title="Star" style="display: inline-block;">
    <img src="https://img.shields.io/github/stars/xtendui/xtendui?style=social" alt="Star" loading="eager">
  </a>
</p>

## Custom UI made easy with simplicity and total freedom

Xtend UI is a powerful frontend library of Tailwind CSS components enhanced by vanilla js. It helps you build interfaces with advanced interactions and animations. Check out [Xtend UI features](https://xtendui.com/intro/features).

* Css with [Tailwind CSS](https://tailwindcss.com/) and [Postcss](https://postcss.org/)
* Some animations and interactions with [Gsap](https://greensock.com/gsap/)
* Positioning with [Popperjs](https://popper.js.org/)
* Focus trap with [Focus Trap](https://github.com/focus-trap/focus-trap)
* Docs with [Nextjs](https://nextjs.org/)
* Release with [Semantic Release](https://github.com/semantic-release/semantic-release)
* Polyfill with [Babel](https://babeljs.io/) and [Core Js](https://github.com/zloirock/core-js)
* Icons with [Feather Icons](https://feathericons.com/)
* Hosting with [Github Pages](https://pages.github.com/) and [Cloudflare](https://www.cloudflare.com/)

[Supported browsers](https://github.com/xtendui/xtendui/blob/master/.browserslistrc) are browsers that supports mainly `optional chaining`, `JavaScript modules`, `es6-module`, `es6-module-dynamic-import`, `IntersectionObserver`, `async`, `flexbox gap`, `webp`, `Variable fonts`, `css variables`, `css grid`.

## Setup

For a complete css and js setup guide visit [online setup page](https://xtendui.com/intro/setup) or [github setup page](https://github.com/xtendui/xtendui/blob/master/SETUP.md).

## Frameworks

Xtend UI is a framework agnostic vanilla javascript library, you can use inside [any javascript framework](https://xtendui.com/intro/frameworks).

## Contributing

Read our [contributing docs](https://github.com/xtendui/xtendui/blob/master/.github/CONTRIBUTING.md) before submitting a pull request.

## Documentation

* Clone the repository `git clone https://github.com/xtendui/xtendui.git`
* Install required npm packages with `pnpm install`
* Use `pnpm dev` to serve a develop version with watch
* Use `pnpm build && pnpm serve` to serve a production version

## Documentation v1.0

* Clone the repository `git clone https://github.com/xtendui/xtendui.git`
* Switch branch with `git checkout 1.0-dev`
* Install required npm packages with `yarn install`
* Use `yarn dev` to serve a develop version with watch
* Use `yarn build && yarn serve` to serve a production version

## Sponsors

<a href="https://www.webgriffe.com/" target="_blank" rel="noopener" title="Webgriffe" style="display: inline-block;">
  <img src="https://raw.githubusercontent.com/xtendui/xtendui/master/public/support/webgriffe.svg" loading="eager" alt="Webgriffe" width="130px">
</a>
&nbsp;&nbsp;

## Copyright and License

Copyright 2017-2024 Riccardo Caroli.

Code licensed [MIT](https://github.com/xtendui/xtendui/blob/master/LICENSE.txt).

Docs licensed [CC-BY-4.0](https://github.com/xtendui/xtendui/blob/master/LICENSE-DOCS.txt)
