---
type: "Components"
category: "Toggle"
parent: "Tooltip"
title: "Content"
date: "2030-10-10"
---

## Variant

Use **Tailwind CSS** to assign variant (e.g. [border-color](https://tailwindcss.com/docs/border-color), [background-color](https://tailwindcss.com/docs/background-color), [text-color](https://tailwindcss.com/docs/text-color)).

This example has **icons** with `inline-block`, complex markup and `<br/>` to make a **multiline tooltip**.

<demo>
  <demoinline src="demos/components/tooltip/variant">
  </demoinline>
</demo>

## Size

Use **Tailwind CSS** to assign size (e.g. [padding](https://tailwindcss.com/docs/padding), [font-size](https://tailwindcss.com/docs/font-size)).

Use **Tailwind CSS** to assign width (e.g. [width](https://tailwindcss.com/docs/width), [max-width](https://tailwindcss.com/docs/max-width)).

<demo>
  <demoinline src="demos/components/tooltip/size">
  </demoinline>
</demo>

## Complex

Use other [card content](/components/card/content) to make complex design.

> This demos use [card](/components/card) see documentation for more info.

<demo>
  <div class="docs_demo_item" data-iframe="demos/themes/implementation/tooltip-implementation-v1">
  </div>
</demo>

## Other Content

You can put **any content** inside this component.

<demo>
  <demoinline src="demos/components/tooltip/other-content">
  </demoinline>
</demo>
