---
type: "Components"
category: "Other"
parent: "Tabs"
title: "Tabs"
description: "Tabs is a component to group up buttons, inputs and other content."
---

## Usage

Use **Tailwind CSS** to assign styles (e.g. [border-radius](https://tailwindcss.com/docs/border-radius)).

Use **Tailwind CSS** to assign alignment (e.g. margin auto, [align-items](https://tailwindcss.com/docs/align-items), [justify-content](https://tailwindcss.com/docs/justify-content)).

Use `.flex-auto` to expand items to **fill width**.

You can set activation styles by adding the class `.on`.

> This demos use [list](/components/list) see documentation for more info.

> For accessibility purpose use `<nav></nav>` with an accessible name assigning `[aria-label]` or `[aria-labelledby]`.

<demo>
  <demoinline src="demos/components/tabs/usage">
  </demoinline>
</demo>

## Implementation

Check out [tabs themes](/themes/tabs) for **advanced implementations**.

<demo>
  <div class="docs_demo_item" data-iframe="demos/themes/implementation/tabs-implementation-v1">
  </div>
  <div class="docs_demo_item" data-iframe="demos/themes/implementation/tabs-implementation-v2">
  </div>
  <div class="docs_demo_item" data-iframe="demos/themes/implementation/tabs-implementation-v3">
  </div>
</demo>
