---
type: "Components"
category: "Core"
parent: "Table"
title: "Content"
date: "2030-10-10"
---

## Variant

Use **Tailwind CSS** to assign variant (e.g. [border-color](https://tailwindcss.com/docs/border-color), [background-color](https://tailwindcss.com/docs/background-color), [text-color](https://tailwindcss.com/docs/text-color)).

<demo>
  <demoinline src="demos/components/table/variant">
  </demoinline>
</demo>

To have **table border and border radius** use `.border-separate`, `overflow-hidden` and `border-spacing: 0`.

<demo>
  <demoinline src="demos/components/table/border">
  </demoinline>
</demo>

## Size

Use **Tailwind CSS** to assign size (e.g. [padding](https://tailwindcss.com/docs/padding), [font-size](https://tailwindcss.com/docs/font-size)).

<demo>
  <demoinline src="demos/components/table/size">
  </demoinline>
</demo>

## Interactive

Use **Tailwind CSS** to assign animation (e.g. [translate](https://tailwindcss.com/docs/translate), [transition-property](https://tailwindcss.com/docs/transition-property), [transition-duration](https://tailwindcss.com/docs/transition-duration), [transition-timing-function](https://tailwindcss.com/docs/transition-timing-function)).

<demo>
  <demoinline src="demos/components/table/interactive">
  </demoinline>
</demo>

## Overflow

Use **Tailwind CSS** to overflow with scroll when content is too long (**use narrow screen to see it in action**).

<demo>
  <demoinline src="demos/components/table/overflow">
  </demoinline>
</demo>
