---
type: "Components"
category: "Other"
parent: "Nav"
title: "Content"
date: "2030-10-10"
---

## Size

Use **Tailwind CSS** to assign size (e.g. [padding](https://tailwindcss.com/docs/padding), [font-size](https://tailwindcss.com/docs/font-size)).

Use **Tailwind CSS** to assign width (e.g. [width](https://tailwindcss.com/docs/width), [max-width](https://tailwindcss.com/docs/max-width)).

Use [list space](/components/list/content#space) to space content.

<demo>
  <demoinline src="demos/components/nav/size">
  </demoinline>
</demo>

## Border

Use **Tailwind CSS** to assign styles (e.g. [border-color](https://tailwindcss.com/docs/border-color), [border-radius](https://tailwindcss.com/docs/border-radius)).

<demo>
  <demoinline src="demos/components/nav/border">
  </demoinline>
</demo>

## Alignment and Icon

Use **Tailwind CSS** to assign alignment (e.g. [text-align](https://tailwindcss.com/docs/text-align), [align-items](https://tailwindcss.com/docs/align-items), [justify-content](https://tailwindcss.com/docs/justify-content)).

> To properly align horizontally also when newlines specify both [text-align](https://tailwindcss.com/docs/text-align) and [justify-content](https://tailwindcss.com/docs/justify-content).

> This demos use [icon](/components/icon) see documentation for more info.

<demo>
  <demoinline src="demos/components/nav/alignment">
  </demoinline>
</demo>

## Complex

Use other [list content](/components/list/content) to make complex design.

> This demos use [icon](/components/icon) see documentation for more info.

<demo>
  <demoinline src="demos/components/nav/complex">
  </demoinline>
</demo>

## Merge

You can make group a **single interactive object**, just put `button` tag including the interactive elements, be sure to use `group` class and variants.

<demo>
  <demoinline src="demos/components/nav/merge">
  </demoinline>
</demo>
