import { Xt } from 'xtendui'
import gsap from 'gsap'
import { ScrollTrigger } from 'gsap/ScrollTrigger'
if (typeof window !== 'undefined') {
  gsap.registerPlugin(ScrollTrigger)
}
import 'xtendui/src/slider'

Xt.mount({
  matches: '.demo--products-listing-v2 .listing-item',
  mount: ({ ref }) => {
    // vars

    const item = ref

    const mediaContainerScale = 0.015
    const mediaScale = 0.06
    const maskOpacityOn = 0.2
    const maskOpacityOff = 0.2
    const maskOpacityDone = 0.1

    // enter

    const enter = e => {
      const tr = e.target
      // media
      const media = tr.querySelector('.xt-media-container')
      gsap.to(media, {
        scale: 1 + mediaContainerScale,
        duration: 0.5,
        ease: 'quart.out',
      })
      const mediaInner = tr.querySelector('.xt-media')
      gsap.to(mediaInner, {
        scale: 1 + mediaScale,
        duration: 1.5,
        ease: 'quart.out',
      })
      // mask
      const mask = tr.querySelector('.xt-media-mask')
      gsap.killTweensOf(mask)
      gsap.set(mask, {
        height: 0,
        y: media.offsetHeight,
        skewY: 0,
        opacity: maskOpacityOff,
      })
      gsap.to(mask, {
        /***/
        // fix to cover height: '150%'
        /***/
        height: '150%',
        y: 0,
        opacity: maskOpacityOn,
        duration: 0.5,
        ease: 'quart.out',
      })
      gsap
        .to(mask, {
          skewY: -10,
          duration: 0.5 / 2,
          ease: 'quart.out',
        })
        .eventCallback('onComplete', () => {
          gsap.to(mask, {
            skewY: 0,
            duration: 0.5 / 2,
            ease: 'quart.out',
          })
        })
      gsap.to(mask, {
        opacity: maskOpacityDone,
        duration: 0.75,
        ease: 'quart.out',
        delay: 0.5,
      })
    }

    item.addEventListener('mouseenter', enter)

    // leave

    const leave = e => {
      const tr = e.target
      // media
      const media = tr.querySelector('.xt-media-container')
      gsap.to(media, {
        scale: 1,
        duration: 0.5,
        ease: 'quart.out',
      })
      const mediaInner = tr.querySelector('.xt-media')
      gsap.to(mediaInner, {
        scale: 1,
        duration: 1.5,
        ease: 'quart.out',
      })
      // mask
      const mask = tr.querySelector('.xt-media-mask')
      gsap.to(mask, {
        /***/
        // fix to cover height: '50%', y: '-100%'
        /***/
        height: '50%',
        y: '-100%',
        opacity: maskOpacityOff,
        duration: 0.5,
        ease: 'quart.out',
      })
      gsap
        .to(mask, {
          skewY: 10,
          duration: 0.5 / 2,
          ease: 'quart.out',
        })
        .eventCallback('onComplete', () => {
          gsap.to(mask, {
            skewY: 0,
            duration: 0.5 / 2,
            ease: 'quart.out',
          })
        })
    }

    item.addEventListener('mouseleave', leave)
  },
})

Xt.mount({
  matches: '.demo--products-listing-v2',
  mount: ({ ref }) => {
    // vars

    const scrollY = 15
    const scrollScale = 1.04

    // check if already done for content added dinamically

    const items = ref.querySelectorAll('.listing-item:not(.faded)')
    for (const item of items) {
      item.classList.add('faded')
    }

    // fade

    /***/
    ScrollTrigger.batch(items, {
      once: true,
      start: 'top bottom-=10%',
      end: 'bottom top+=10%',
      onEnter: (batch, scrollTriggers) => {
        const direction = scrollTriggers[0].direction
        const y = direction > 0 ? -scrollY : scrollY
        gsap.killTweensOf(batch)
        gsap.set(batch, {
          y: y,
          scale: scrollScale,
        })
        gsap.to(batch, {
          opacity: 1,
          y: 0,
          scale: 1,
          duration: 0.5,
          ease: 'quart.out',
          stagger: index => {
            return Math.min(0.6, index * 0.15)
          },
        })
      },
    })
    /***/
  },
})
