/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    long modelHandle;
    int topIndex;
    int selectionCountOnPress;
    int selectionCountOnRelease;
    static final int TEXT_COLUMN = 0;
    double cachedAdjustment;
    double currentAdjustment;
    boolean rowActivated;

    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(string, true);
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (iter == 0L) {
            this.error(14);
        }
        GTK.gtk_list_store_append(this.modelHandle, iter);
        GTK.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        OS.g_free(iter);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (0 > index || index > count) {
            this.error(6);
        }
        byte[] buffer = Converter.wcsToMbcs(string, true);
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (iter == 0L) {
            this.error(14);
        }
        if (index == count) {
            GTK.gtk_list_store_append(this.modelHandle, iter);
        } else {
            GTK.gtk_list_store_insert(this.modelHandle, iter, index);
        }
        GTK.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        OS.g_free(iter);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    @Override
    void createHandle(int index) {
        long columnHandle;
        long textRenderer;
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            this.scrolledHandle = GTK4.gtk_scrolled_window_new();
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            this.scrolledHandle = GTK3.gtk_scrolled_window_new(0L, 0L);
        }
        if (this.scrolledHandle == 0L) {
            this.error(2);
        }
        long[] types = new long[]{OS.G_TYPE_STRING()};
        this.modelHandle = GTK.gtk_list_store_newv(types.length, types);
        if (this.modelHandle == 0L) {
            this.error(2);
        }
        this.handle = GTK.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((textRenderer = GTK.gtk_cell_renderer_text_new()) == 0L) {
            this.error(2);
        }
        if ((columnHandle = GTK.gtk_tree_view_column_new()) == 0L) {
            this.error(2);
        }
        GTK.gtk_tree_view_column_pack_start(columnHandle, textRenderer, true);
        GTK.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.text, 0);
        GTK.gtk_tree_view_column_set_min_width(columnHandle, 0);
        GTK.gtk_tree_view_insert_column(this.handle, columnHandle, index);
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.scrolledHandle);
            GTK4.gtk_scrolled_window_set_child(this.scrolledHandle, this.handle);
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            GTK3.gtk_container_add(this.scrolledHandle, this.handle);
        }
        int mode = (this.style & 2) != 0 ? 3 : 2;
        long selectionHandle = GTK.gtk_tree_view_get_selection(this.handle);
        GTK.gtk_tree_selection_set_mode(selectionHandle, mode);
        GTK.gtk_tree_view_set_headers_visible(this.handle, false);
        int hsp = (this.style & 0x100) != 0 ? 1 : 2;
        int vsp = (this.style & 0x200) != 0 ? 1 : 2;
        GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
        if ((this.style & 0x800) != 0) {
            if (GTK.GTK4) {
                GTK4.gtk_scrolled_window_set_has_frame(this.scrolledHandle, true);
            } else {
                GTK3.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
        }
        if ((this.getShell().style & 0x4000) != 0) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        }
        this.setFontDescription(this.defaultFont().handle);
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        GTK.gtk_widget_realize(this.handle);
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if (size.x == 0 && wHint == -1) {
            size.x = 64;
        }
        if (size.y == 0 && hHint == -1) {
            size.y = this.getItemCount() * this.getItemHeightInPixels();
        }
        if (size.y == 0 && hHint == -1) {
            size.y = 64;
        }
        Rectangle trim = this.computeTrimInPixels(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        return size;
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(GTK.gtk_tree_view_get_selection(this.handle));
    }

    public void deselect(int index) {
        this.checkWidget();
        if (0 > index || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            return;
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        GTK.gtk_tree_selection_unselect_iter(selection, iter);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start < 0 && end < 0) {
            return;
        }
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (start >= count && end >= count) {
            return;
        }
        start = Math.min(count - 1, Math.max(0, start));
        end = Math.min(count - 1, Math.max(0, end));
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        for (int index = start; index <= end; ++index) {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
            GTK.gtk_tree_selection_unselect_iter(selection, iter);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            if (index < 0 || index > count - 1) continue;
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
            GTK.gtk_tree_selection_unselect_iter(selection, iter);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void deselectAll() {
        this.checkWidget();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_unselect_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        boolean selected = false;
        if (OS.isX11()) {
            boolean dragDetect;
            if (filter) {
                long[] path = new long[1];
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, x, y, path, null, null, null)) {
                    if (path[0] != 0L) {
                        long selection = GTK.gtk_tree_view_get_selection(this.handle);
                        if (GTK.gtk_tree_selection_path_is_selected(selection, path[0])) {
                            selected = true;
                        }
                        GTK.gtk_tree_path_free(path[0]);
                    }
                } else {
                    return false;
                }
            }
            if ((dragDetect = super.dragDetect(x, y, filter, false, consume)) && selected && consume != null) {
                consume[0] = true;
            }
            return dragDetect;
        }
        double[] startX = new double[1];
        double[] startY = new double[1];
        long[] path = new long[1];
        if (GTK.gtk_gesture_drag_get_start_point(this.dragGesture, startX, startY)) {
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)startX[0], (int)startY[0], path, null, null, null)) {
                if (path[0] != 0L) {
                    boolean dragDetect = super.dragDetect(x, y, filter, false, consume);
                    if (dragDetect && selected && consume != null) {
                        consume[0] = true;
                    }
                    return dragDetect;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    @Override
    long eventWindow() {
        return this.paintWindow();
    }

    public int getFocusIndex() {
        this.checkWidget();
        long[] path = new long[1];
        GTK.gtk_tree_view_get_cursor(this.handle, path, null);
        if (path[0] == 0L) {
            return -1;
        }
        long indices = GTK.gtk_tree_path_get_indices(path[0]);
        int[] index = new int[]{-1};
        if (indices != 0L) {
            C.memmove(index, indices, 4L);
        }
        GTK.gtk_tree_path_free(path[0]);
        return index[0];
    }

    public String getItem(int index) {
        this.checkWidget();
        if (0 > index || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        long[] ptr = new long[1];
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        GTK.gtk_tree_model_get(this.modelHandle, iter, 0, ptr, -1);
        OS.g_free(iter);
        if (ptr[0] == 0L) {
            return null;
        }
        int length = C.strlen(ptr[0]);
        byte[] buffer2 = new byte[length];
        C.memmove(buffer2, ptr[0], (long)length);
        OS.g_free(ptr[0]);
        return new String(Converter.mbcsToWcs(buffer2));
    }

    public int getItemCount() {
        this.checkWidget();
        return GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        this.checkWidget();
        boolean BASE_ITEM_PADDING = true;
        int[] h = new int[1];
        long layout = GTK.gtk_widget_create_pango_layout(this.handle, Converter.wcsToMbcs(" ", true));
        OS.pango_layout_get_pixel_size(layout, null, h);
        int height = h[0] + 2;
        OS.g_object_unref(layout);
        long column = GTK.gtk_tree_view_get_column(this.handle, 0);
        long textRenderer = this.getTextRenderer(column);
        int[] ypad = new int[1];
        if (textRenderer != 0L) {
            GTK.gtk_cell_renderer_get_padding(textRenderer, null, ypad);
        }
        return height += ypad[0] * 2;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long[] ptr = new long[1];
        String[] result = new String[count];
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        for (int index = 0; index < count; ++index) {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
            GTK.gtk_tree_model_get(this.modelHandle, iter, 0, ptr, -1);
            if (ptr[0] == 0L) continue;
            int length = C.strlen(ptr[0]);
            byte[] buffer = new byte[length];
            C.memmove(buffer, ptr[0], (long)length);
            OS.g_free(ptr[0]);
            result[index] = new String(Converter.mbcsToWcs(buffer));
        }
        OS.g_free(iter);
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] indices = this.getSelectionIndices();
        String[] result = new String[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            result[i] = this.getItem(indices[i]);
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        return GTK.gtk_tree_selection_count_selected_rows(selection);
    }

    public int getSelectionIndex() {
        long list;
        this.checkWidget();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        long originalList = list = GTK.gtk_tree_selection_get_selected_rows(selection, null);
        if (list != 0L) {
            int[] index = new int[1];
            boolean foundIndex = false;
            while (list != 0L) {
                long indices;
                long data = OS.g_list_data(list);
                if (!foundIndex && (indices = GTK.gtk_tree_path_get_indices(data)) != 0L) {
                    C.memmove(index, indices, 4L);
                    foundIndex = true;
                }
                list = OS.g_list_next(list);
                GTK.gtk_tree_path_free(data);
            }
            OS.g_list_free(originalList);
            return index[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        long list;
        this.checkWidget();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        long originalList = list = GTK.gtk_tree_selection_get_selected_rows(selection, null);
        if (list != 0L) {
            int count = OS.g_list_length(list);
            int[] treeSelection = new int[count];
            int length = 0;
            for (int i = 0; i < count; ++i) {
                long data = OS.g_list_data(list);
                long indices = GTK.gtk_tree_path_get_indices(data);
                if (indices != 0L) {
                    int[] index = new int[1];
                    C.memmove(index, indices, 4L);
                    treeSelection[length] = index[0];
                    ++length;
                }
                GTK.gtk_tree_path_free(data);
                list = OS.g_list_next(list);
            }
            OS.g_list_free(originalList);
            int[] result = new int[length];
            System.arraycopy(treeSelection, 0, result, 0, length);
            return result;
        }
        return new int[0];
    }

    long getTextRenderer(long column) {
        long list = GTK.gtk_cell_layout_get_cells(column);
        if (list == 0L) {
            return 0L;
        }
        long originalList = list;
        long textRenderer = 0L;
        while (list != 0L) {
            long renderer = OS.g_list_data(list);
            if (GTK.GTK_IS_CELL_RENDERER_TEXT(renderer)) {
                textRenderer = renderer;
                break;
            }
            list = OS.g_list_next(list);
        }
        OS.g_list_free(originalList);
        return textRenderer;
    }

    public int getTopIndex() {
        this.checkWidget();
        long vAdjustment = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.currentAdjustment = GTK.gtk_adjustment_get_value(vAdjustment);
        if (this.cachedAdjustment == this.currentAdjustment) {
            if (Device.DEBUG) {
                System.out.println("Using the cached GtkAdjustment, topIndex is " + this.topIndex);
            }
            return this.topIndex;
        }
        long[] path = new long[1];
        GTK.gtk_widget_realize(this.handle);
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, path, null, null, null)) {
            return 0;
        }
        if (path[0] == 0L) {
            return 0;
        }
        long indices = GTK.gtk_tree_path_get_indices(path[0]);
        int[] index = new int[1];
        if (indices != 0L) {
            C.memmove(index, indices, 4L);
        }
        GTK.gtk_tree_path_free(path[0]);
        if (Device.DEBUG) {
            System.out.println("Fetching the top index from GTK, topIndex is " + index[0]);
        }
        return index[0];
    }

    @Override
    long gtk_changed(long widget) {
        this.sendSelectionEvent(13);
        return 0L;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        long[] path;
        int button;
        long result = super.gtk_button_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        int eventType = GDK.gdk_event_get_event_type(event);
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        int[] eventState = new int[1];
        int[] eventButton = new int[1];
        if (GTK.GTK4) {
            eventButton[0] = GDK.gdk_button_event_get_button(event);
            eventState[0] = GDK.gdk_event_get_modifier_state(event);
            GDK.gdk_event_get_position(event, eventX, eventY);
        } else {
            GDK.gdk_event_get_button(event, eventButton);
            GDK.gdk_event_get_state(event, eventState);
            GDK.gdk_event_get_coords(event, eventX, eventY);
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && !OS.isX11() && eventType == 4) {
            long nextEvent = GDK.gdk_event_peek();
            if (nextEvent == 0L) {
                long[] path2 = new long[1];
                long selection = GTK.gtk_tree_view_get_selection(this.handle);
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)eventX[0], (int)eventY[0], path2, null, null, null) && path2[0] != 0L) {
                    this.selectionCountOnPress = this.getSelectionCount();
                    if (GTK.gtk_tree_selection_path_is_selected(selection, path2[0]) && ((eventState[0] & 5) == 0 || (eventState[0] & 4) != 0)) {
                        long gtk_false_funcPtr = GTK.GET_FUNCTION_POINTER_gtk_false();
                        GTK.gtk_tree_selection_set_select_function(selection, gtk_false_funcPtr, 0L, 0L);
                    }
                }
            } else {
                this.gdk_event_free(nextEvent);
            }
        }
        if ((button = eventButton[0]) == 3 && eventType == 4 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)eventX[0], (int)eventY[0], path = new long[1], null, null, null) && path[0] != 0L) {
            long selection = GTK.gtk_tree_view_get_selection(this.handle);
            if (GTK.gtk_tree_selection_path_is_selected(selection, path[0])) {
                result = 1L;
            }
            GTK.gtk_tree_path_free(path[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)eventX[0], (int)eventY[0], path = new long[1], null, null, null) && path[0] != 0L) {
            long selection = GTK.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_tree_view_set_cursor(this.handle, path[0], 0L, false);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_tree_path_free(path[0]);
        }
        if (eventType == 5 && this.rowActivated) {
            this.sendTreeDefaultSelection();
            this.rowActivated = false;
        }
        return result;
    }

    @Override
    void gtk_gesture_press_event(long gesture, int n_press, double x, double y, long event) {
        if (n_press == 1) {
            return;
        }
        super.gtk_gesture_press_event(gesture, n_press, x, y, event);
        if (n_press == 2 && this.rowActivated) {
            this.sendTreeDefaultSelection();
            this.rowActivated = false;
        }
    }

    @Override
    long gtk_row_activated(long tree, long path, long column) {
        this.rowActivated = true;
        return 0L;
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        int[] key = new int[1];
        if (GTK.GTK4) {
            key[0] = GDK.gdk_key_event_get_keyval(event);
        } else {
            GDK.gdk_event_get_keyval(event, key);
        }
        this.keyPressDefaultSelectionHandler(event, key[0]);
        return super.gtk_key_press_event(widget, event);
    }

    @Override
    long gtk_button_release_event(long widget, long event) {
        int[] eventState = new int[1];
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        if (GTK.GTK4) {
            eventState[0] = GDK.gdk_event_get_modifier_state(event);
            GDK.gdk_event_get_position(event, eventX, eventY);
        } else {
            GDK.gdk_event_get_state(event, eventState);
            GDK.gdk_event_get_coords(event, eventX, eventY);
        }
        long eventGdkResource = this.gdk_event_get_surface_or_window(event);
        if (GTK.GTK4 ? eventGdkResource != this.gtk_widget_get_surface(this.handle) : eventGdkResource != GTK.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && !OS.isX11()) {
            long[] path = new long[1];
            long selection = GTK.gtk_tree_view_get_selection(this.handle);
            GTK.gtk_tree_selection_set_select_function(selection, 0L, 0L, 0L);
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)eventX[0], (int)eventY[0], path, null, null, null) && path[0] != 0L && GTK.gtk_tree_selection_path_is_selected(selection, path[0])) {
                this.selectionCountOnRelease = this.getSelectionCount();
                if ((eventState[0] & 5) == 0) {
                    GTK.gtk_tree_view_set_cursor(this.handle, path[0], 0L, false);
                }
                if ((eventState[0] & 4) != 0 && this.selectionCountOnRelease == this.selectionCountOnPress) {
                    GTK.gtk_tree_selection_unselect_path(selection, path[0]);
                }
            }
        }
        return super.gtk_button_release_event(widget, event);
    }

    void keyPressDefaultSelectionHandler(long event, int key) {
        int keymask = this.gdk_event_get_state(event);
        switch (key) {
            case 65293: {
                if ((keymask & 0x1C000008) != 0) break;
                this.sendTreeDefaultSelection();
            }
        }
    }

    void sendTreeDefaultSelection() {
        Event event = new Event();
        event.index = this.getFocusIndex();
        if (event.index >= 0) {
            event.text = this.getItem(event.index);
        }
        this.sendSelectionEvent(14, event, false);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(selection, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        String[] items = this.getItems();
        for (int i = start; i < items.length; ++i) {
            if (!items[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        byte[] buffer = Converter.wcsToMbcs(Integer.toString(index), true);
        long path = GTK.gtk_tree_path_new_from_string(buffer);
        boolean answer = GTK.gtk_tree_selection_path_is_selected(selection, path);
        GTK.gtk_tree_path_free(path);
        return answer;
    }

    @Override
    long paintWindow() {
        GTK.gtk_widget_realize(this.handle);
        return GTK.gtk_tree_view_get_bin_window(this.handle);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(GTK.gtk_tree_view_get_selection(this.handle), this);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0L) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0L;
    }

    public void remove(int index) {
        this.checkWidget();
        if (0 > index || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_list_store_remove(this.modelHandle, iter);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (0 > start || start > end || end >= count) {
            this.error(6);
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        for (int index = end; index >= start; --index) {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
            GTK.gtk_list_store_remove(this.modelHandle, iter);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        int count = this.getItemCount();
        if (0 > start || start > end || end >= count) {
            this.error(6);
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        int last = -1;
        for (int i = 0; i < newIndices.length; ++i) {
            int index = newIndices[i];
            if (index == last) continue;
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
            GTK.gtk_list_store_remove(this.modelHandle, iter);
            last = index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void removeAll() {
        this.checkWidget();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (0 > index || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            return;
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        GTK.gtk_tree_selection_select_iter(selection, iter);
        if ((this.style & 4) != 0) {
            long path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
            GTK.gtk_tree_view_set_cursor(this.handle, path, 0L, false);
            GTK.gtk_tree_path_free(path);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        for (int index = start; index <= end; ++index) {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
            GTK.gtk_tree_selection_select_iter(selection, iter);
            if ((this.style & 4) == 0) continue;
            long path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
            GTK.gtk_tree_view_set_cursor(this.handle, path, 0L, false);
            GTK.gtk_tree_path_free(path);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        for (int i = 0; i < length; ++i) {
            int index = indices[i];
            if (0 > index || index >= count) continue;
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
            GTK.gtk_tree_selection_select_iter(selection, iter);
            if ((this.style & 4) == 0) continue;
            long path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
            GTK.gtk_tree_view_set_cursor(this.handle, path, 0L, false);
            GTK.gtk_tree_path_free(path);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(iter);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_select_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
    }

    void selectFocusIndex(int index) {
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (0 > index || index >= count) {
            return;
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        long path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_view_set_cursor(this.handle, path, 0L, false);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_path_free(path);
        OS.g_free(iter);
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        GTK.gtk_widget_realize(this.handle);
        return result;
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > index || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        byte[] buffer = Converter.wcsToMbcs(string, true);
        GTK.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        OS.g_free(iter);
    }

    public void setItems(String ... items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != null) continue;
            this.error(5);
        }
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (iter == 0L) {
            this.error(14);
        }
        for (int i = 0; i < items.length; ++i) {
            String string = items[i];
            byte[] buffer = Converter.wcsToMbcs(string, true);
            GTK.gtk_list_store_append(this.modelHandle, iter);
            GTK.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        }
        OS.g_free(iter);
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        GdkRGBA toSet = rgba == null ? this.display.COLOR_LIST_FOREGROUND_RGBA : rgba;
        this.setForegroundGdkRGBA(this.handle, toSet);
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        this.selectFocusIndex(index);
        this.showSelection();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        this.selectFocusIndex(start);
        if ((this.style & 2) != 0) {
            this.select(start, end);
        }
        this.showSelection();
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.selectFocusIndex(indices[0]);
        if ((this.style & 2) != 0) {
            this.select(indices);
        }
        this.showSelection();
    }

    public void setSelection(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        boolean first = true;
        block0: for (int i = 0; i < length; ++i) {
            int index = 0;
            String string = items[i];
            if (string == null) continue;
            while ((index = this.indexOf(string, index)) != -1) {
                if ((this.style & 2) != 0) {
                    if (first) {
                        first = false;
                        this.selectFocusIndex(index);
                    } else {
                        this.select(index);
                    }
                } else {
                    this.selectFocusIndex(index);
                    continue block0;
                }
                ++index;
            }
        }
        this.showSelection();
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        long vAdjustment = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.cachedAdjustment = GTK.gtk_adjustment_get_value(vAdjustment);
        this.topIndex = index;
        if (0 > index || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            return;
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        long path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
        GTK.gtk_tree_view_scroll_to_cell(this.handle, path, 0L, true, 0.0f, 0.0f);
        GTK.gtk_tree_path_free(path);
        OS.g_free(iter);
    }

    public void showSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index == -1) {
            return;
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        long path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
        GTK.gtk_widget_realize(this.handle);
        GTK.gtk_tree_view_scroll_to_cell(this.handle, path, 0L, false, 0.0f, 0.0f);
        GdkRectangle visibleRect = new GdkRectangle();
        GTK.gtk_tree_view_get_visible_rect(this.handle, visibleRect);
        GdkRectangle cellRect = new GdkRectangle();
        GTK.gtk_tree_view_get_cell_area(this.handle, path, 0L, cellRect);
        int[] tx = new int[1];
        int[] ty = new int[1];
        GTK.gtk_tree_view_convert_bin_window_to_tree_coords(this.handle, cellRect.x, cellRect.y, tx, ty);
        if (ty[0] < visibleRect.y) {
            GTK.gtk_tree_view_scroll_to_point(this.handle, -1, ty[0]);
        } else {
            int height = Math.min(visibleRect.height, cellRect.height);
            if (ty[0] + height > visibleRect.y + visibleRect.height) {
                ty[0] = ty[0] + (cellRect.height - visibleRect.height);
                GTK.gtk_tree_view_scroll_to_point(this.handle, -1, ty[0]);
            }
        }
        GTK.gtk_tree_path_free(path);
        OS.g_free(iter);
    }
}

