package cn.xianyum.extension.entity.po.server;


import cn.xianyum.common.utils.ArithUtils;

/**
 * 內存相关信息
 * @author zhangwei
 * @date 2019/4/1 10:46
 */
public class Mem {

    /**
     * 内存总量
     */
    private double total;

    /**
     * 已用内存
     */
    private double used;

    /**
     * 剩余内存
     */
    private double free;

    public double getTotal()
    {
        return ArithUtils.div(total, (1024 * 1024 * 1024), 2);
    }

    public void setTotal(long total)
    {
        this.total = total;
    }

    public double getUsed()
    {
        return ArithUtils.div(used, (1024 * 1024 * 1024), 2);
    }

    public void setUsed(long used)
    {
        this.used = used;
    }

    public double getFree()
    {
        return ArithUtils.div(free, (1024 * 1024 * 1024), 2);
    }

    public void setFree(long free)
    {
        this.free = free;
    }

    public double getUsage()
    {
        return ArithUtils.mul(ArithUtils.div(used, total, 4), 100);
    }
}
