# Generated by Django 2.2.14 on 2020-07-09 08:04

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='UserProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nick_name', models.CharField(help_text='昵称', max_length=64)),
                ('signature', models.CharField(blank=True, help_text='个性签名', max_length=255, null=True)),
                ('unicode_id', models.IntegerField(default=-1, help_text='唯一ID', unique=True)),
                ('img_path', models.CharField(default='/', help_text='头像地址', max_length=255)),
                ('friends', models.ManyToManyField(blank=True, related_name='_userprofile_friends_+', to='chat.UserProfile')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='profile', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': '用户信息',
                'verbose_name_plural': '用户信息',
            },
        ),
        migrations.CreateModel(
            name='ChatRoom',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('room_name', models.CharField(help_text='房间名称', max_length=64)),
                ('room_description', models.CharField(default='这里还没什么描述', help_text='房间描述', max_length=255)),
                ('img_path', models.CharField(default='/', help_text='头像地址', max_length=255)),
                ('channel_no', models.CharField(help_text='房间频道号', max_length=8, unique=True)),
                ('max_number', models.IntegerField(default=5, help_text='允许最大人数')),
                ('ordering', models.IntegerField(default=99, help_text='置顶权')),
                ('admins', models.ManyToManyField(help_text='房间管理', related_name='chat_admins', to='chat.UserProfile')),
                ('members', models.ManyToManyField(help_text='房间成员', related_name='chat_member', to='chat.UserProfile')),
            ],
            options={
                'verbose_name': '聊天室',
                'verbose_name_plural': '聊天室',
            },
        ),
        migrations.CreateModel(
            name='ChatLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('chat_datetime', models.DateTimeField(blank=True, db_index=True, help_text='接收时间', null=True)),
                ('content', models.TextField(blank=True, help_text='聊天内容', null=True)),
                ('msg_type', models.CharField(blank=True, help_text='消息类型', max_length=16, null=True)),
                ('said_together', models.CharField(blank=True, max_length=64, null=True)),
                ('status', models.CharField(default='read', help_text='消息状态', max_length=16)),
                ('said_to', models.ForeignKey(blank=True, db_constraint=False, help_text='接收者', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='said_to', to=settings.AUTH_USER_MODEL)),
                ('said_to_room', models.ForeignKey(blank=True, db_constraint=False, help_text='接收房间', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='said_to_room', to='chat.ChatRoom')),
                ('who_said', models.ForeignKey(db_constraint=False, help_text='发送者', on_delete=django.db.models.deletion.CASCADE, related_name='who_said', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': '聊天记录',
                'verbose_name_plural': '聊天记录',
            },
        ),
    ]
