﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Payment.Fuiou.Fuyou
{

    class BankNo
    {
        public static readonly string[,] strs = new string[,]{
                        {"中国工商银行","0102"},
                        {"中国农业银行","0103"},
                        {"中国银行","0104"},
                        {"中国建设银行","0105"},
                        {"国家开发银行","0201"},
                        {"中国进出口银行","0202"},
                        {"中国农业发展银行","0203"},
                        {"交通银行","0301"},
                        {"中信银行","0302"},
                        {"中国光大银行","0303"},
                        {"华夏银行","0304"},
                        {"中国民生银行","0305"},
                        {"广东发展银行","0306"},
                        {"深圳发展银行","0307"},
                        {"招商银行","0308"},
                        {"兴业银行","0309"},
                        {"上海浦东发展银行","0310"},
                        {"城市商业银行","0313"},
                        {"农村商业银行（江苏）","0314"},
                        {"恒丰银行","0315"},
                        {"浙商银行","0316"},
                        {"农村合作银行","0317"},
                        {"渤海银行股份有限公司","0318"},
                        {"徽商银行股份有限公司","0319"},
                        {"镇银行有限责任公司","0320"},
                        {"城市信用社","0401"},
                        {"农村信用社（含北京农村商业银行）","0402"},
                        {"中国邮政储蓄银行","0403"},
                        {"汇丰银行","0501"},
                        {"东亚银行","0502"},
                        {"南洋商业银行","0503"},
                        {"恒生银行(中国)有限公司","0504"},
                        {"中国银行（香港）有限公司","0505"},
                        {"集友银行有限公司","0506"},
                        {"创兴银行有限公司","0507"},
                        {"星展银行（中国）有限公司","0509"},
                        {"永亨银行（中国）有限公司","0510"},
                        {"永隆银行","0512"},
                        {"花旗银行（中国）有限公司","0531"},
                        {"美国银行有限公司","0532"},
                        {"摩根大通银行(中国)有限公司","0533"},
                        {"三菱东京日联银行(中国）有限公司","0561"},
                        {"日本三井住友银行股份有限公司","0563"},
                        {"瑞穗实业银行（中国）有限公司","0564"},
                        {"日本山口银行股份有限公司","0565"},
                        {"韩国外换银行股份有限公司","0591"},
                        {"友利银行(中国)有限公司","0593"},
                        {"韩国外换银行股份有限公司","0591"},
                        {"友利银行（中国）有限公司","0593"},
                        {"韩国产业银行","0594"},
                        {"新韩银行(中国)有限公司","0595"},
                        {"韩国中小企业银行有限公司","0596"},
                        {"韩亚银行（中国）有限公司","0597"},
                        {"华侨银行（中国）有限公司","0621"},
                        {"大华银行（中国）有限公司","0622"},
                        {"星展银行（中国）有限公司","0623"},
                        {"泰国盘谷银行(大众有限公司)","0631"},
                        {"奥地利中央合作银行股份有限公司","0641"},
                        {"比利时联合银行股份有限公司","0651"},
                        {"比利时富通银行有限公司","0652"},
                        {"荷兰银行","0661"},
                        {"荷兰安智银行股份有限公司","0662"},
                        {"渣打银行","0671"},
                        {"英国苏格兰皇家银行公众有限公司","0672"},
                        {"法国兴业银行（中国)有限公司","0691"},
                        {"法国东方汇理银行股份有限公司","0694"},
                        {"法国外贸银行股份有限公司","0695"},
                        {"德国德累斯登银行股份公司","0711"},
                        {"德意志银行（中国）有限公司","0712"},
                        {"德国商业银行股份有限公司","0713"},
                        {"德国西德银行股份有限公司","0714"},
                        {"德国巴伐利亚州银行","0715"},
                        {"德国北德意志州银行","0716"},
                        {"意大利联合圣保罗银行股份有限公司","0732"},
                        {"瑞士信贷银行股份有限公司","0741"},
                        {"瑞士银行","0742"},
                        {"加拿大丰业银行有限公司","0751"},
                        {"加拿大蒙特利尔银行有限公司","0752"},
                        {"澳大利亚和新西兰银行集团有限公司","0761"},
                        {"摩根士丹利国际银行（中国）有限公司","0771"},
                        {"联合银行(中国)有限公司","0775"},
                        {"荷兰合作银行有限公司","0776"},
                        {"厦门国际银行","0781"},
                        {"法国巴黎银行（中国）有限公司","0782"},
                        {"华商银行","0785"},
                        {"华一银行","0787"},
                        {"(澳门地区)银行","0969"},
                        {"(香港地区)银行","0989"}
        };

        public Dictionary<string, string> dic = new Dictionary<string, string>();

        public static readonly BankNo Instance = new BankNo();
        private BankNo()
        {
            dic = new Dictionary<string, string>();
            for (int i = 0; i < strs.Length / 2; i++)
            {

                try
                {
                    if (dic.ContainsKey(strs[i, 0]))
                        continue;
                    else

                        dic.Add(strs[i, 0], strs[i, 1]);
                }
                catch (System.Exception e)
                {

                }
            }
        }

    }

    /// <summary>
    /// 银行工具类
    /// </summary>
    public class Bank
    {
        /// <summary>
        /// 更具总行名字 获取代码
        /// </summary>
        /// <param name="bankName"></param>
        /// <returns></returns>
        public static string GetBankNo(string bankName)
        {
            if (BankNo.Instance.dic.ContainsKey(bankName))
                return BankNo.Instance.dic[bankName];
            return "";


        }
    }
}
