/** 统一失败和成功的请求结果的数据类型 */
export async function handleServiceResult<T = any>(error: Service.RequestError | null, data: any) {
  if (error) {
    const fail: Service.FailedResult = {
      error,
      data: null,
    };
    return fail;
  }
  const success: Service.SuccessResult<NonNullable<T>> = {
    error: null,
    data: data ?? "success",
  };
  return success;
}
