# echoping

A golang network utility using TCP/UDP-Datagram/QUIC messages to detect network stability.

## Why to write this network utility

It's difficult to detect network problems in real life. 

`echoping` uses TCP and UDP(Datagram or QUIC) protocols instead of ICMP used by traditional `ping`, and send messages more frequently.

`echoping` works more like a real network application, and reports network problems as the real one.


## How it works

1. Start a `echoping` server by `./echoping -listen IP:PORT`
2. Start `echoping` clients to use the `echoping` server: `./echoping -connect SERVER_IP:SERVER_PORT`
3. Every `echoping` client sends TCP/UDP-Datagram/QUIC requests to the server
4. The server sends every request as a response back to the client
5. The client collects the responses and calculates the packet loss ratio (UDP only) and round-trip time
6. If any network error occurs, the client will retry to connect and send requests forever. 
7. Every connection (ping session) has a unique session id which is generated by the connection time, it helps to distinguish different client connections, eg: if a network error occurs and a client re-connects, then there will be a new session id in logs.

⚠️ The server and client versions must match, otherwise the protocol may not work ⚠️

Usage:

```
  -connect string
    	Connect to 'tcp://ip:port/,udp://ip:port/,quic://ip:port/' (can be repeated, use comma as delimiter), or use 'ip:port' for all TCP/UDP/QUIC
  -listen string
    	Listen both TCP and UDP on ip:port (UDP also works for QUIC)
  -listen-tcp string
    	Listen TCP on ip:port
  -listen-udp string
    	Listen UDP on ip:port (UDP also works for QUIC)
  -loss-ratio string
    	The simulated UDP loss ratio on client side (must be used with "-connect"). "0.1"" means 10% packet loss, "0.1,0.2" means 0.1 for sending and 0.2 for receiving
  -payload-size int
    	The payload size of ping request (default 1300)
  -ping-interval duration
    	The interval between ping requests sent by client (default 20ms)
```

Server output:
```
2020/12/26 01:24:54 server stat udp:127.0.0.1:52032 (20201226-012449.458182): pps=10.0, tmperr=0
2020/12/26 01:24:54 server stat tcp:127.0.0.1:56524 (20201226-012449.458231): pps=10.0, tmperr=0
```

Client output:
```
2020/12/26 01:24:54 client stat udp:127.0.0.1:12345 (20201226-012449.458182): pps=11.0, recv=0.01MB/s, loss=0.0%, round-trip time (ms): avg=0.4, min=0.2, max=0.6, stddev=0.1
2020/12/26 01:24:54 client stat tcp:127.0.0.1:12345 (20201226-012449.458231): pps=11.0, recv=0.01MB/s, loss=0.0%, round-trip time (ms): avg=0.3, min=0.2, max=0.4, stddev=0.1
```

* "20201226-012449.458182" is the ping session id, which is generated by the time of the client starts the ping session.
* `pps` means "ping per second"
* The `loss` of TCP and QUIC is always 0% (of course)

## Develop and debug locally

```
./echoping -listen :12345 -connect 127.0.0.1:12345
```

Simulate delayed and dropped packets on Linux: https://stackoverflow.com/questions/614795/simulate-delayed-and-dropped-packets-on-linux
