
---
layout:     readme
title:      "日志类"
subtitle:   "Log class"
date:       2019-01-11 20:00:00
author:     "吴庆宝"
tags:
    - phpms框架
---

调用方法

```
\core\lib\log::init();
\core\lib\log::log($data);
```

CORE.'/lib/route.php';

```
<?php

namespace core\lib;

use core\lib\conf;

class log
{
	static $class;
	/**
	 * 1.确定日志储存方式
	 * 2.写日志	 
	 */
	static public function init(){
		//确定储存方式
		$drive = conf::get('DRIVE','log');
		$class = '\core\lib\drive\log\\'.$drive;		
		self::$class = new $class;
	}

	static public function log($name,$file='log'){
		self::$class->log($name,$file);	
	}
}
```

CORE.'/lib/drive/log/file.php';

```
<?php

namespace core\lib\drive\log;

use core\lib\conf;

class file
{	
	public function __construct(){
		$conf = conf::get('OPTION','log');
		$this->path = $conf['PATH'];
	}
	public function log($msg,$file = 'log'){
		/**
		 * 1.确定文件储存位置是否存在	
		 * 2.新建目录	
		 * 3.写入日志
		 */		
		$path = conf::get('OPTION','log');		
		if(!is_dir($this->path.date("YmdH",time()))){
			mkdir($this->path.date("YmdH",time()),'0777',true);
		}		
		return file_put_contents($this->path.date("YmdH",time()).'/'.$file.'.php', date("Y-m-d H:i:s").json_encode($msg).PHP_EOL,FILE_APPEND);
	}
}
```

CORE.'/lib/drive/log/file.php';

```
<?php
	return [
		'DRIVE'=>'file',
		'OPTION'=>[
			'PATH'=>PHPMSFRAME.'/log/'
		]
    ];
```