---
layout:     readme
title:      "类的自动加载"
subtitle:   "Automatic loading of classes"
date:       2019-01-11 20:00:00
author:     "吴庆宝"
tags:
    - phpms框架
---

```
spl_autoload_register('\core\phpmsframe::load');
```

CORE.'/phpmsframe.php';

```
<?php

namespace core;

class phpmsframe 
{
	public static $classMap = array();

	static public function run()
	{		
		$route = new \core\lib\route();
		$ctrlClass = $route->ctrl;
		$action = $route->action;		
		$ctrlfile = APP.'/ctrl/'.$ctrlClass.'Ctrl.php';
		$ctrlClass = '\\'.MODULE.'\ctrl\\'.$ctrlClass.'Ctrl';		
		if(is_file($ctrlfile)){			
			include $ctrlfile;
			$ctrl = new $ctrlClass();			
			$ctrl->$action();
		}else{	 
			echo '404';
		}
	}

	static public function load($class)
	{
		if(isset($classMap[$class])){
			return true;
		}else{
			$class  = str_replace('\\', '/', $class);
			$file = PHPMSFRAME.'/'.$class.'.php';
			if(is_file($file)){
				include $file;
				self::$classMap[$class] = $class; 
			}else{
				return false;
			}
		}
	}	 
```

## spl_autoload_register 是如何实现自动加载实例详解	

spl_autoload_register()函数应该是主流框架使用最多的也是非常核心的函数之一，可实现自动注册
函数和类，实现类似autoload() 函数功能，简化了类的调用与加载，提高了工作的效率
这里通过一个实验谈谈这个函数的部分特征。 

函数原型 
```
bool spl_autoload_register ([ callback $autoload_function [, bool $throw = true [, bool $prepend = false ]]] ) 
```

版本兼容 

PHP 5 >= 5.1.2 

### 实验过程 
第一步，使用spl_autoload_register()函数注册load()方法 

代码如下:
```
<?php 

function load(){ 

	require_once'lib.php'; 

} 

spl_autoload_register('load'); 

?>
```

其中lib.php文件代码如下 

代码如下:
```
<?php 

class className{ 

	function method(){ 

		echo 'a method in class'; 

    } 
} 

function onlyMethod(){ 

	echo 'method only'; 

} 
?>
```
说明：lib.php文件为一个className类和一个onlyMethod函数 

第二步，调用自动加载类 

代码如下:
```
$class = new className(); 

$class->method(); 

onlyMethod();
```
输出： 
```
a method in class

method only
```

说明：实例化className类，并调用类method()函数，同时调用onlyMethod()方法，输出正常，没有出现错误 

第三步，直接调用函数 

```
onlyMethod();
```

说明：没有实例化类，直接调用lib.php文件中的onlyMethod()函数 
输出： 
```
Fatal error: Call to undefined function onlyMethod() in '...(省略路径)' 
```

第四步，实例化className类，再直接调用 

```
$class = new className(); 

onlyMethod();
````
输出：method only 

从上面的四步实验发现，如果加载的文件包含函数，使用则一定需要实例化里面的类，否则就产生异常情况 Call to undefined function错误，具体在使用中要注意一下。