---
layout:     readme
title:      "入口文件"
subtitle:   "Entry file"
date:       2019-01-11 20:00:00
author:     "吴庆宝"
tags:
    - phpms框架
---

项目根目录

composer.json

```
{
	"name": "phpms frame",
    "description": "PHP Interview 2019 ,my phpms framework",
    "type": "Framework",
    "keywords": [
        "php",
        "php framework"
    ],
    "require": {
        "erusev/parsedown": "^1.7",
        "symfony/var-dumper":"*",
        "catfan/medoo":"*",
        "twig/twig":"*",
        "gregwar/captcha": "^1.1",
		"filp/whoops": "^2.3"     
    }
}
```


erusev/parsedown Markdown的解析器。

catfan/medoo 最轻的PHP数据库框架，以加速开发

symfony/var-dumper  用于探索和转储PHP变量的Symfony机制

twig/twig Twig，PHP的灵活，快速，安全的模板语言

gregwar/captcha 验证码

filp/whoops 为酷孩子解决php错误

```git
composer update
```

index.php

```
<?php
header("content-type:text/html;charset=utf-8");  
define('PHPMSFRAME',__DIR__);             
define('CORE',PHPMSFRAME.'/core');
define('APP',PHPMSFRAME.'/app');
define('MODULE','app');

define('DEBUG',true);

include "vendor/autoload.php";

if(DEBUG){
	$whoops = new \Whoops\Run;
	$whoops->pushHandler(new \Whoops\Handler\PrettyPageHandler);
	$whoops->register();
	ini_set('display_error', 'On');
}else{
	ini_set('display_error', 'Off');
}

include CORE.'/common/function.php';

include CORE.'/phpmsframe.php';

spl_autoload_register('\core\phpmsframe::load');

\core\phpmsframe::run();
```

CORE.'/common/function.php';

```
<?php

//------打印数据-----
function p($var){ echo "<pre>"; print_r($var); echo "</pre>";}

//------跳转------
function js_u($url,$time=0,$msg=''){    
    sleep($time);//调用了sleep()方法,效果也是x秒后执行跳转
    echo "<script language='javascript' type='text/javascript'>"; 
    if(!empty($msg)){
        echo "alert('".$msg."');";
    }
    echo "window.location.href='$url'"; 
    echo "</script>"; 
}
```

CORE.'/phpmsframe.php';

```
<?php

namespace core;

class phpmsframe 
{
    public static $classMap = array();

    public $assign;

   /* 这是一个魔术方法，当一个对象或者类获取其不存在的属性的值时，
    * 如：$obj = new BaseController ;
    * $a = $obj -> a ;
    * 该方法会被自动调用,这样做很友好，可以避免系统报错
    */
    public function __get($property_name){
        $msg = "属性 $property_name 不存在\n";
        self::reportingDog($msg);   
    }

   /* 这是一个魔术方法，当一个对象或者类给其不存在的属性赋值时，
    * 如：$obj = new BaseController ;
    * $obj -> a = 12 ;
    * 该方法(__set(属性名,属性值))会被自动调用,这样做很友好，可以避免系统报错
    */
    public function __set($property_name,$value){
        $msg = "属性 $property_name 不存在\n";
        self::reportingDog($msg);   
    }

   /* 这是一个魔术方法，当一个对象或者类的不存在属性进行isset()时，
    * 注意：isset 用于检查一个量是否被赋值 如果为NULL会返回false
    * 如：$obj = new BaseController ;
    * isset($obj -> a) ;
    * 该方法会被自动调用,这样做很友好，可以避免系统报错
    */
    public function __isset($property_name){
        $msg = "属性 $property_name 不存在\n";
        self::reportingDog($msg);   
    }

   /* 这是一个魔术方法，当一个对象或者类的不存在属性进行unset()时，
    * 注意：unset 用于释放一个变量所分配的内存空间
    * 如：$obj = new BaseController ;
    * unset($obj -> a) ;
    * 该方法会被自动调用,这样做很友好，可以避免系统报错
    */
    public function __unset($property_name){
        $msg = "属性 $property_name 不存在\n";
        self::reportingDog($msg);   
    }

    /* 当对这个类的对象的不存在的实例方法进行“调用”时，会自动调用该方法，
     * 这个方法有2个参数（必须带有的）：
     * $methodName 表示要调用的不存在的方法名;
     * $argument 是一个数组，表示要调用该不存在的方法时，所使用的实参数据，
     * /
    public function __call($methodName,$argument){
        $msg = "实例方法 $methodName 不存在\n";
        self::reportingDog($msg);   
    }
 
    static public function run()
    {       
        \core\lib\log::init();
        \core\lib\log::log($_SERVER);
        $route = new \core\lib\route();
        $ctrlClass = $route->ctrl;
        $action = $route->action;       
        $ctrlfile = APP.'/ctrl/'.$ctrlClass.'Ctrl.php';
        $ctrlClass = '\\'.MODULE.'\ctrl\\'.$ctrlClass.'Ctrl';
        if(is_file($ctrlfile)){         
            include $ctrlfile;          
            $ctrl = new $ctrlClass();
            $ctrl->$action();                   
        }else{  
            $msg = "控制器 $ctrlClass 不存在\n";       
            self::reportingDog($msg);           
        }
    }

    static public function load($class)
    {
        if(isset($classMap[$class])){
            return true;
        }else{
            $class  = str_replace('\\', '/', $class);
            $file = PHPMSFRAME.'/'.$class.'.php';
            if(is_file($file)){
                include $file;
                self::$classMap[$class] = $class; 
            }else{
                return false;
            }
        }
    }

    public function assign($name,$value){
        $this->assign[$name]=$value;
    }

    public function display($file){
        $file_path = APP.'/views/'.$file;
        if(is_file($file_path)){    
            /***********twig模板***********/
            $loader = new \Twig_Loader_Filesystem(APP.'/views');
            $twig = new \Twig_Environment($loader, array(
                'cache' => PHPMSFRAME.'/cache',
                'debug'=>DEBUG,
            ));                     
            $template = $twig->load($file);         
            $template->display($this->assign?$this->assign:'');
            /***********twig模板end***********/

            /***********原生模板***********/
            //extract($this->assign);
            //include $file_path;
            /***********原生模板end***********/
        }
    }

    static private function reportingDog($msg){
echo $msg."\n";     
$str = <<<ET
```
/**********************************************************************
 *               ii.                                         ;9ABH,          
 *              SA391,                                    .r9GG35&G          
 *              &#ii13Gh;                               i3X31i;:,rB1         
 *              iMs,:,i5895,                         .5G91:,:;:s1:8A         
 *               33::::,,;5G5,                     ,58Si,,:::,sHX;iH1        
 *                Sr.,:;rs13BBX35hh11511h5Shhh5S3GAXS:.,,::,,1AG3i,GG        
 *                .G51S511sr;;iiiishS8G89Shsrrsh59S;.,,,,,..5A85Si,h8        
 *               :SB9s:,............................,,,.,,,SASh53h,1G.       
 *            .r18S;..,,,,,,,,,,,,,,,,,,,,,,,,,,,,,....,,.1H315199,rX,       
 *          ;S89s,..,,,,,,,,,,,,,,,,,,,,,,,....,,.......,,,;r1ShS8,;Xi       
 *        i55s:.........,,,,,,,,,,,,,,,,.,,,......,.....,,....r9&5.:X1       
 *       59;.....,.     .,,,,,,,,,,,...        .............,..:1;.:&s       
 *      s8,..;53S5S3s.   .,,,,,,,.,..      i15S5h1:.........,,,..,,:99       
 *      93.:39s:rSGB@A;  ..,,,,.....    .SG3hhh9G&BGi..,,,,,,,,,,,,.,83      
 *      G5.G8  9#@@@@@X. .,,,,,,.....  iA9,.S&B###@@Mr...,,,,,,,,..,.;Xh     
 *      Gs.X8 S@@@@@@@B:..,,,,,,,,,,. rA1 ,A@@@@@@@@@H:........,,,,,,.iX:    
 *     ;9. ,8A#@@@@@@#5,.,,,,,,,,,... 9A. 8@@@@@@@@@@M;    ....,,,,,,,,S8    
 *     X3    iS8XAHH8s.,,,,,,,,,,...,..58hH@@@@@@@@@Hs       ...,,,,,,,:Gs   
 *    r8,        ,,,...,,,,,,,,,,.....  ,h8XABMMHX3r.          .,,,,,,,.rX:  
 *   :9, .    .:,..,:;;;::,.,,,,,..          .,,.               ..,,,,,,.59  
 *  .Si      ,:.i8HBMMMMMB&5,....                    .            .,,,,,.sMr
 *  SS       :: h@@@@@@@@@@#; .                     ...  .         ..,,,,iM5
 *  91  .    ;:.,1&@@@@@@MXs.                            .          .,,:,:&S
 *  hS ....  .:;,,,i3MMS1;..,..... .  .     ...                     ..,:,.99
 *  ,8; ..... .,:,..,8Ms:;,,,...                                     .,::.83
 *   s&: ....  .sS553B@@HX3s;,.    .,;13h.                            .:::&1
 *    SXr  .  ...;s3G99XA&X88Shss11155hi.                             ,;:h&,
 *     iH8:  . ..   ,;iiii;,::,,,,,.                                 .;irHA  
 *      ,8X5;   .     .......                                       ,;iihS8Gi
 *         1831,                                                 .,;irrrrrs&@
 *           ;5A8r.                                            .:;iiiiirrss1H
 *             :X@H3s.......                                .,:;iii;iiiiirsrh
 *              r#h:;,...,,.. .,,:;;;;;:::,...              .:;;;;;;iiiirrss1
 *             ,M8 ..,....,.....,,::::::,,...         .     .,;;;iiiiiirss11h
 *             8B;.,,,,,,,.,.....          .           ..   .:;;;;iirrsss111h
 *            i@5,:::,,,,,,,,.... .                   . .:::;;;;;irrrss111111
 *            9Bi,:,,,,......                        ..r91;;;;;iirrsss1ss1111
 *****************单身狗看着你不想说话***************************************/
```
ET;
        $Parsedown = new \Parsedown();
        echo $Parsedown->text($str); die;
    }
}

```