#include "bsp.h"
#include "bsp_custom.h"
#include "osasys.h"
#include "ostask.h"
#include "cmsis_os2.h"
#include "queue.h"
#include "ps_event_callback.h"
#include "ps_lib_api.h"
#include "cmisim.h"
#include "cmips.h"
#include "sockets.h"
#include "networkmgr.h"
#include "netdb.h"
#include "slpman.h"
#include "time.h"
// #include "MQTTClient.h"
#include "plat_config.h"
#include "hal_i2s.h"

// Download mp3 info the area of flash which is file system area
const uint8_t batteryCharging[] = {
    0xFF,0xF3,0x28,0xC4,0x00,0x0D,0x10,0x02,0xC4,0xF7,0x40,0x10,0x00,0x98,0x1A,0x80,
    0x01,0x80,0x48,0x3D,0xAD,0x10,0xDE,0x7C,0x42,0x20,0x28,0xA5,0xA2,0xAD,0x88,0x0B,
    0x68,0x7E,0xBE,0x40,0x10,0x2E,0x20,0x89,0xC5,0x76,0xD2,0x18,0x08,0x9A,0x0F,0x80,
    0xC5,0x04,0xC0,0x30,0x8F,0x2E,0x84,0x75,0x20,0x9D,0xB4,0x67,0xFF,0x41,0xFF,0xFC,
    0xBA,0xD5,0xCA,0x7D,0x3D,0x60,0xC1,0xD4,0xFF,0xF3,0x28,0xC4,0x06,0x0E,0x81,0xFA,
    0xC0,0x01,0x83,0x28,0x00,0x99,0x85,0xB4,0x2D,0x99,0xC7,0xAB,0xBB,0x9A,0x72,0x66,
    0x7C,0x4D,0xCB,0x5C,0xF5,0x17,0x99,0x8A,0x02,0x11,0x1C,0x4A,0x22,0x24,0x08,0x04,
    0x16,0x6B,0x94,0x82,0xC9,0x28,0x83,0xE5,0xAB,0x27,0xFF,0xB3,0x25,0x0C,0x9F,0xFF,
    0xFD,0x9F,0x12,0xDB,0xFF,0xFF,0xF2,0x9F,0x92,0xF5,0x54,0xE6,0x25,0xE1,0xF2,0x19,
    0xFF,0xF3,0x28,0xC4,0x07,0x0C,0x78,0xD2,0xBC,0x01,0xD3,0x78,0x01,0x14,0x02,0x34,
    0x21,0x29,0x22,0x5E,0x4D,0x9A,0xE6,0x2C,0xE1,0x86,0x00,0xEA,0x0A,0x5D,0x44,0xB9,
    0xA4,0x6A,0xE2,0xDE,0xB0,0x4E,0xF0,0x83,0xA5,0x19,0xA5,0x81,0x1A,0xB5,0xA3,0x7A,
    0x91,0x56,0xB2,0xEE,0x13,0xBF,0xB8,0xCA,0x96,0xF1,0xF8,0x1A,0xFF,0xFF,0x1F,0x80,
    0xA5,0xF5,0x2D,0x4B,0x3C,0x5A,0x16,0x80,0xFF,0xF3,0x28,0xC4,0x10,0x11,0x21,0x6E,
    0xD6,0x5E,0x6B,0x54,0x94,0x3B,0x9B,0xB9,0x61,0xF4,0x10,0x75,0x71,0xF8,0x25,0xCB,
    0x6A,0xF4,0x4D,0x5D,0xC0,0xC9,0x05,0xB8,0xBA,0x95,0x66,0x2C,0xA4,0x96,0x87,0x0C,
    0x83,0x77,0x33,0xFD,0x88,0x55,0x3F,0xF3,0x4F,0xFF,0xCE,0x24,0x3D,0xFE,0x67,0xFF,
    0xFF,0xFC,0x44,0xEB,0x32,0x27,0x7D,0x67,0x7E,0x9A,0x72,0x31,0x20,0x6A,0x49,0x24,
    0xFF,0xF3,0x28,0xC4,0x06,0x0D,0xE1,0x6E,0xE6,0x5F,0x4C,0x38,0x02,0x10,0x01,0x9D,
    0x3B,0x35,0xF5,0x9B,0xA7,0x66,0x43,0x49,0x6F,0xC8,0x66,0xCE,0xC5,0xF3,0xD3,0x37,
    0x31,0xC0,0xC0,0xAC,0x81,0xE9,0xF5,0x11,0x48,0x17,0xFF,0xC5,0x43,0x2B,0xFF,0x94,
    0x1B,0x9F,0xFF,0xDF,0xFF,0x41,0xD0,0xE7,0xFF,0x9C,0xFF,0xEB,0x11,0xF9,0x6A,0xC7,
    0xF2,0xD7,0x25,0x18,0x10,0x17,0x95,0x0A,0xFF,0xF3,0x28,0xC4,0x09,0x0E,0x90,0xF2,
    0xA0,0x01,0x9A,0x58,0x00,0x83,0x7C,0x1C,0x93,0x05,0x02,0x19,0x38,0x49,0x52,0xC1,
    0xD4,0xB8,0x72,0x83,0xF1,0xAB,0x4E,0x89,0xC7,0x61,0x63,0xED,0x8C,0x87,0x2A,0xE8,
    0xFB,0xFE,0x4C,0xEF,0xE5,0x16,0x55,0x4D,0xD7,0xA8,0xBF,0x64,0xFF,0x7A,0x8E,0xFE,
    0x18,0xFF,0xA8,0x30,0x73,0xE4,0x6A,0xC3,0xFB,0x9E,0x3F,0xCA,0xBE,0xAC,0x9F,0x24,
    0xFF,0xF3,0x28,0xC4,0x09,0x0F,0x0A,0x4A,0xC4,0x01,0x99,0x50,0x00,0xB7,0x10,0x33,
    0x08,0x7E,0x4E,0x75,0x97,0x80,0x5D,0x0F,0x4F,0x08,0x14,0xF4,0x38,0xA1,0x0A,0x22,
    0x12,0x35,0x82,0x06,0xDE,0xBF,0xC6,0x4D,0xAD,0xFF,0xF2,0xFD,0x5F,0xFF,0xFF,0xF7,
    0x53,0x9B,0xD3,0xA1,0xE7,0xE7,0xB7,0x2D,0xFF,0x4F,0xDD,0xBF,0xE4,0x69,0x28,0xF5,
    0xD5,0xFF,0x65,0x98,0x90,0x12,0x44,0x0C,0xFF,0xF3,0x28,0xC4,0x07,0x0E,0xF2,0x5A,
    0xC0,0x01,0xD4,0x68,0x00,0x43,0x11,0xC9,0x1C,0xD2,0xEA,0xD0,0x52,0xA8,0x4E,0x13,
    0x81,0xA9,0x82,0x00,0x83,0xFE,0xA5,0x92,0x63,0x8C,0xF7,0xFE,0x81,0x82,0x5F,0xFA,
    0x90,0x30,0x7F,0xFE,0x9A,0x3F,0xFA,0xD3,0x33,0x3D,0xFD,0xD0,0x42,0xA2,0x93,0x76,
    0xFD,0x32,0xF9,0x05,0xFF,0xD5,0xBF,0xFF,0xA8,0xC5,0xFD,0x48,0x4C,0x0D,0x0B,0x40,
    0xFF,0xF3,0x28,0xC4,0x06,0x0E,0x89,0xAA,0xD0,0x00,0x6B,0xC4,0x94,0xC8,0x00,0xC2,
    0x23,0xD7,0xFF,0x78,0x0F,0x18,0x0B,0xE1,0xE0,0x26,0x62,0x03,0x16,0xB9,0xA5,0x21,
    0xBF,0x7F,0x3B,0x1B,0x12,0xB6,0x48,0xDF,0xFD,0xD3,0xF3,0xA2,0x9B,0xFF,0xAF,0xFF,
    0xFF,0xFF,0xD1,0xA7,0x91,0x03,0x98,0x1A,0x0E,0x50,0x55,0xE4,0xD3,0xB5,0x1A,0x10,
    0x94,0x2A,0xFD,0x64,0xE0,0x07,0x81,0xA3,0xFF,0xF3,0x28,0xC4,0x06,0x0D,0x18,0x96,
    0xC8,0x00,0x6E,0x12,0x4C,0x17,0x35,0x3A,0x64,0xD9,0x7F,0xFD,0x49,0xF9,0x03,0xAD,
    0x11,0x04,0x4F,0x05,0x9B,0x8D,0xB6,0x2C,0x1A,0x10,0x86,0x50,0xA1,0x14,0xCC,0x24,
    0x2C,0x05,0x74,0xF7,0xFF,0xFE,0xE2,0x24,0x09,0x24,0x55,0x81,0x24,0x1E,0x0D,0x08,
    0x7F,0xA7,0xFD,0x55,0x37,0xFB,0x65,0xB6,0xD9,0x68,0x00,0x7B,0x06,0xA5,0x0E,0xA1,
    0xFF,0xF3,0x28,0xC4,0x0C,0x0C,0xD0,0x6E,0xED,0xBE,0x0B,0xD8,0x2A,0x1B,0xAD,0x62,
    0xE2,0x9A,0x5B,0x0A,0x49,0xC9,0x9F,0x77,0xF7,0xE2,0x84,0x0A,0x5E,0x75,0x2D,0xB1,
    0xCC,0x76,0xF5,0xB7,0x69,0xC0,0x27,0x2E,0x04,0x8E,0x90,0xA1,0xAB,0xBA,0x2C,0x71,
    0xE8,0xAA,0xCF,0xFA,0x55,0xFF,0x8C,0xD8,0xD8,0x08,0x4A,0x89,0xA3,0xAC,0xC0,0xB0,
    0xDC,0x12,0xC6,0x10,0x1E,0x53,0x49,0x48,0xFF,0xF3,0x28,0xC4,0x13,0x0F,0x91,0xAE,
    0xC8,0x00,0x58,0xC4,0x94,0xF7,0x9C,0xCF,0xA7,0x3F,0xFF,0xFF,0xFF,0xE7,0xA6,0xF9,
    0xEA,0xF7,0x20,0x76,0x72,0x33,0xAB,0x39,0x4B,0xA2,0xD2,0x72,0x30,0x73,0x28,0x41,
    0x9E,0x1B,0x32,0xE2,0x1D,0x60,0xE4,0x85,0x64,0xF5,0x85,0xC0,0x82,0x76,0x14,0x87,
    0xD5,0xF5,0xA8,0xE0,0xDD,0xE1,0xC3,0xA5,0x75,0xA8,0xCD,0x8A,0x6D,0xD8,0xAB,0x3C,
    0xFF,0xF3,0x28,0xC4,0x0F,0x0B,0xE0,0x8E,0xCC,0x00,0x16,0x1E,0x4C,0x87,0x72,0x87,
    0x84,0x11,0x59,0x4D,0x7F,0x4C,0x3C,0x52,0x38,0xC7,0xBB,0x57,0x20,0xFE,0xB1,0x1F,
    0x03,0x93,0x5A,0x43,0x4B,0x3B,0x46,0xAF,0xE2,0x22,0xA1,0xAF,0xF9,0x65,0x09,0x78,
    0x47,0xF2,0xA2,0x24,0x70,0x15,0xE1,0xCB,0x96,0xCE,0xD9,0xC7,0xF5,0x4B,0x19,0x41,
    0x08,0xFA,0x2F,0x38,0xD0,0xF5,0x6F,0xD7,0xFF,0xF3,0x28,0xC4,0x1A,0x0C,0xB0,0xDA,
    0xCC,0xCA,0x96,0x14,0x70,0xEE,0xEA,0x3B,0xC7,0x84,0x51,0x31,0xDA,0x24,0x7E,0x02,
    0x64,0xA6,0xFD,0x8F,0x24,0x7F,0x13,0xBB,0xFF,0xFF,0xFF,0xFF,0xFE,0x4D,0x01,0x8F,
    0xDF,0x5F,0x7E,0x00,0x1F,0x81,0xFA,0xCD,0xD5,0x07,0x09,0xF8,0xBA,0xB5,0xF5,0x6F,
    0xB6,0xC1,0x69,0x3D,0x9F,0xC5,0xF6,0xFF,0xE4,0x7C,0xC7,0x28,0xBF,0x69,0x30,0x1D,
    0xFF,0xF3,0x28,0xC4,0x22,0x0D,0x40,0xD6,0xEA,0x5E,0x6B,0xDA,0x70,0x20,0xB2,0x5D,
    0x4F,0xF3,0x23,0xDE,0x77,0xFF,0xFF,0xFF,0xFF,0xFF,0x06,0x8F,0x56,0x59,0xBE,0x14,
    0xD0,0x00,0xD6,0x9F,0xFE,0x38,0x03,0x81,0x7F,0xB2,0x85,0x62,0xF0,0x47,0x04,0x00,
    0xD5,0xE9,0x75,0x8F,0xA1,0x29,0x8F,0x3D,0xEF,0xE7,0xE2,0xAD,0xC5,0xF8,0x2C,0x97,
    0xE3,0xEB,0x31,0x7C,0x14,0xC1,0xC4,0x74,0xFF,0xF3,0x28,0xC4,0x28,0x0D,0x38,0xAE,
    0xD2,0x5E,0x1C,0xDE,0x4C,0xA5,0x4D,0xC2,0xFE,0xC7,0xFF,0xDF,0xFF,0xFF,0xFF,0xFF,
    0xFF,0x2A,0x10,0x17,0x1B,0x72,0xDA,0x00,0x02,0x81,0xD5,0x01,0xC5,0x60,0x82,0x88,
    0x4C,0x4D,0xB9,0xB7,0xAD,0xFF,0xE1,0x29,0x40,0xB1,0xE7,0x4C,0xCC,0xEE,0x78,0xE2,
    0x04,0x09,0x06,0x8F,0xE0,0x55,0xA4,0x42,0x87,0x36,0x08,0x9D,0xE7,0xBF,0xFF,0xFF,
    0xFF,0xF3,0x28,0xC4,0x2E,0x0C,0xC0,0x9A,0xDE,0x5E,0x13,0xD8,0x4E,0xFF,0xFF,0xFF,
    0xFF,0xEA,0x24,0x82,0xDF,0xA2,0x33,0xC2,0x96,0x20,0xA1,0xC8,0x80,0x96,0xC0,0x78,
    0x66,0x01,0x79,0x10,0x57,0x64,0xAA,0x99,0x16,0x43,0x2E,0x87,0xAA,0x6B,0xEB,0x45,
    0x4A,0x08,0x85,0xC3,0x57,0xFF,0xFB,0x4D,0x69,0xA6,0x8D,0x48,0x9B,0x7F,0xFF,0xE7,
    0xBC,0x8D,0x47,0x01,0xB4,0x02,0xAD,0xD2,0xFF,0xF3,0x28,0xC4,0x36,0x0B,0xE8,0xF2,
    0x90,0x38,0xA4,0xCE,0x70,0x48,0x79,0x86,0xB0,0xA8,0x19,0xBD,0x32,0xA0,0x52,0x61,
    0x8C,0x12,0x53,0x05,0x87,0xA9,0x58,0x68,0x2A,0x09,0xB9,0x43,0xCA,0x87,0x4E,0xB7,
    0xFB,0x38,0x57,0xA3,0xFF,0xFF,0xFF,0x4B,0x7A,0x3F,0xFE,0xBA,0x7F,0x52,0x4C,0x41,
    0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xFF,0xF3,0x28,0xC4,0x41,0x0B,0xA8,0x46,0x40,0x1E,0x4E,0x30,0x24,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xFF,0xF3,0x28,0xC4,0x4D,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xFF,0xF3,0x28,0xC4,0x88,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xFF,0xF3,0x28,0xC4,0xC3,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
    0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
};

const uint8_t rebooting[]={
    
    0xFF,0xF3,0x28,0xC4,0x00,0x0B,0xE0,0x06,0xB1,0x4D,0x40,0x10,0x00,0xE4,0x02,0x0E,
    0x0A,0x70,0x3F,0x0F,0x94,0x38,0x27,0x3E,0x0F,0xBC,0x10,0x58,0x60,0xBB,0xC8,0x14,
    0x38,0x27,0x86,0x14,0x70,0xBE,0xA7,0x17,0xF2,0xEF,0xDD,0xFE,0x20,0x70,0x20,0xEF,
    0x2E,0x0F,0x94,0x07,0xDF,0x5B,0xFF,0xD6,0x0F,0x9F,0xFF,0xFE,0x95,0xAF,0xEE,0xA5,
    0x4C,0x96,0xE2,0x38,0x13,0x80,0x35,0xC2,0xFF,0xF3,0x28,0xC4,0x0B,0x0F,0xF1,0xEE,
    0xDC,0x01,0x91,0x50,0x00,0x35,0x76,0x70,0x43,0x3D,0xD1,0x49,0xE6,0x67,0x93,0xE0,
    0xBA,0x16,0x8E,0xFD,0x3D,0x0D,0x5F,0xFF,0xD1,0x13,0xFF,0xFB,0x1A,0xF5,0x57,0x69,
    0x9C,0xF6,0x57,0x2F,0x5D,0x4E,0x3B,0xD7,0xCF,0x72,0x32,0x76,0x4A,0x13,0x0F,0x80,
    0x5C,0x9A,0xD7,0xFE,0x7D,0x49,0x29,0xEC,0x14,0xA9,0x20,0x7F,0xA7,0xF5,0xD6,0x66,
    0xFF,0xF3,0x28,0xC4,0x06,0x0E,0x89,0x62,0xC8,0xCB,0xD3,0x80,0x00,0x66,0x39,0x40,
    0x42,0x41,0x26,0x87,0xBA,0x42,0x20,0x82,0x0B,0x36,0x4E,0xC6,0x88,0x97,0x41,0xA4,
    0x1D,0x31,0x78,0xDB,0x6B,0x75,0x18,0x18,0x13,0xDF,0xFE,0xA7,0x45,0xBF,0xAF,0xBA,
    0x4E,0xEF,0xFB,0xBA,0x73,0x5F,0xE4,0x7F,0x13,0x3F,0xEB,0x77,0xFF,0xFF,0x9E,0x77,
    0xCA,0xAA,0x1E,0xF1,0xF2,0x0B,0x7F,0xF8,0xFF,0xF3,0x28,0xC4,0x06,0x0E,0xB8,0xDA,
    0xE6,0x5E,0x3B,0xCA,0x70,0xFF,0x81,0xF4,0xA9,0xA5,0xC4,0x60,0x05,0x5D,0x8E,0xA6,
    0x63,0xFD,0x50,0xCD,0x99,0x3D,0x7E,0x7B,0x53,0x42,0x1B,0x17,0xFF,0xFF,0x50,0x6F,
    0xFD,0x04,0x07,0x02,0xAE,0xD2,0x20,0x04,0x44,0x46,0xFB,0x96,0xE4,0x71,0x00,0x17,
    0xFF,0xA3,0xFF,0xFF,0x80,0x1B,0xFA,0x5C,0x3C,0x3B,0x20,0x26,0x03,0x92,0x49,0x24,
    0xFF,0xF3,0x28,0xC4,0x06,0x0E,0x81,0x06,0xBD,0xBF,0x53,0x38,0x00,0x00,0x7D,0x04,
    0x10,0x51,0x98,0xEB,0x0F,0x58,0x06,0xE8,0x45,0xCD,0x0F,0x9E,0x49,0x2B,0x27,0x59,
    0x40,0x47,0x41,0x70,0xC1,0x92,0x5F,0xDE,0x60,0xD8,0x96,0xFE,0x8B,0x1E,0x24,0x77,
    0xD0,0xF6,0x28,0x26,0x24,0x48,0xC2,0x37,0xFF,0x12,0xFF,0xF1,0xFD,0x1D,0xBF,0xFE,
    0x25,0xE6,0x5A,0x88,0xEB,0x4F,0xD0,0xE1,0xFF,0xF3,0x28,0xC4,0x07,0x0E,0x7A,0x4E,
    0xAC,0x01,0x98,0x10,0x00,0x62,0x30,0xDC,0xCD,0x90,0xF0,0xDA,0x90,0xF7,0x7A,0x3A,
    0xB1,0x5D,0x87,0x21,0x1F,0xF9,0x14,0xE7,0xE7,0xF6,0xA3,0x75,0xFF,0xFF,0x7F,0xFF,
    0xCE,0x77,0x57,0x9F,0xFF,0xFF,0x79,0x08,0xCE,0x46,0xFF,0xFF,0xFF,0x9C,0xE2,0x0E,
    0x03,0xE3,0x8C,0x1F,0xFF,0xFC,0xBF,0xD4,0xFE,0x2C,0xC8,0x70,0x90,0x08,0x20,0xCB,
    0xFF,0xF3,0x28,0xC4,0x08,0x0E,0x21,0xC2,0xD4,0x01,0x90,0x68,0x00,0x04,0x40,0x2F,
    0xA9,0x11,0x3D,0x51,0x50,0xC0,0x2C,0x59,0x01,0xA5,0x61,0x58,0x00,0xAC,0x50,0x67,
    0x48,0x6D,0x4D,0x84,0x8A,0x4E,0x0E,0x81,0xE6,0xAF,0x6D,0x0E,0xE8,0xFF,0xFE,0x83,
    0xFF,0xED,0x54,0xEA,0x5E,0x83,0xB2,0xBF,0xFF,0x43,0x97,0x0F,0x2E,0xAA,0x0C,0xBF,
    0x87,0xF7,0x74,0x86,0x60,0xF6,0x3C,0x59,0xFF,0xF3,0x28,0xC4,0x0A,0x0E,0x59,0x72,
    0xE0,0xCB,0xCD,0x50,0x02,0x4A,0xF3,0xA3,0x8C,0x59,0x0F,0x23,0x67,0x7A,0xC7,0x84,
    0x22,0xD0,0x0C,0x02,0x11,0x37,0xCC,0x30,0x54,0x25,0x1E,0xB7,0xF3,0x18,0xEF,0xF5,
    0xB2,0x7F,0xDD,0x7E,0x8C,0xA7,0x98,0x61,0x30,0x70,0x4F,0x0F,0x1A,0x54,0xDE,0x05,
    0x2C,0xC6,0xC5,0xBD,0x35,0x2B,0x67,0x87,0xF3,0x02,0xE0,0xC7,0x86,0xDC,0x4F,0x23,
    0xFF,0xF3,0x28,0xC4,0x0B,0x0D,0x11,0x7A,0xDC,0xCB,0x50,0x50,0x00,0xD3,0x4C,0x98,
    0x16,0x60,0x8E,0x49,0x93,0x55,0x7B,0x9A,0x16,0xC0,0x12,0x05,0x51,0xC7,0xF9,0x85,
    0xC8,0x4D,0x4F,0xFF,0xFF,0xFF,0xFF,0xAC,0xE3,0x90,0xEE,0x79,0x43,0x41,0x23,0xD5,
    0x13,0x2B,0xC8,0x78,0xB5,0x1A,0xD5,0xDE,0x5F,0x53,0xF6,0x22,0x60,0x90,0x4B,0xCD,
    0x5B,0xB6,0xEA,0xA7,0x7D,0xB7,0xD7,0x3F,0xFF,0xF3,0x28,0xC4,0x11,0x11,0x61,0xFA,
    0xB4,0x01,0x98,0x90,0x00,0x03,0x78,0x18,0x4E,0x4C,0x9E,0x74,0xDE,0x3A,0x45,0xC2,
    0x68,0xFF,0x7D,0x07,0xDF,0xFF,0xA9,0x2A,0x97,0xFF,0xFA,0x29,0x52,0x1C,0x9F,0xD6,
    0xFA,0xDF,0x3D,0x2F,0x15,0x90,0x75,0xA9,0xD7,0xAF,0xFB,0xFE,0x6A,0x55,0x4D,0x03,
    0x23,0xE0,0x57,0xDC,0x05,0x09,0xA7,0xFF,0xAA,0xA5,0xAA,0x91,0x66,0x77,0xA6,0x3F,
    0xFF,0xF3,0x28,0xC4,0x06,0x0E,0x41,0xB6,0xD0,0x01,0x82,0x28,0x00,0xB1,0xA3,0x45,
    0x76,0x61,0xC8,0x45,0xD5,0x3C,0xE4,0x9E,0x63,0x7F,0xA6,0xF7,0xED,0x35,0x6C,0xE2,
    0x68,0xA2,0xF8,0xB9,0x42,0x25,0x0A,0x04,0x9A,0x10,0x63,0x28,0xAC,0xCF,0x9D,0xC9,
    0x9D,0x4C,0x82,0x86,0x15,0x30,0xE4,0x91,0x3D,0x4F,0xFB,0x77,0x7F,0xFF,0xEB,0x16,
    0xFE,0x36,0x74,0x54,0xA5,0x98,0x6B,0xB9,0xFF,0xF3,0x28,0xC4,0x08,0x0B,0xF1,0x16,
    0xB0,0x01,0xC6,0x30,0x00,0x4F,0xB5,0xCD,0xDB,0x28,0xE2,0xD0,0x98,0xDD,0x8B,0xDF,
    0xF6,0xED,0x8F,0xD9,0x3F,0x39,0xEC,0xF0,0xD0,0xED,0x07,0xA7,0xC8,0x13,0x1E,0x64,
    0x93,0x97,0x63,0xC8,0xE1,0xC7,0x88,0x81,0xA0,0xED,0xCB,0xD5,0xA9,0xFF,0xFD,0x54,
    0x89,0xC0,0x40,0x9B,0x9D,0xC6,0xC8,0x59,0x3D,0x6A,0xC7,0x5C,0x1E,0x09,0xF6,0x68,
    0xFF,0xF3,0x28,0xC4,0x13,0x0C,0x68,0xF6,0xB0,0x00,0xC3,0xCC,0x71,0xFA,0xB9,0xB8,
    0x2D,0x87,0x02,0x9D,0xFB,0xCD,0xAE,0x28,0x86,0x30,0x4C,0xF4,0xC5,0x3E,0x54,0xB8,
    0xBD,0xB8,0x26,0x94,0x3F,0xF5,0xAF,0x30,0x49,0x22,0xE6,0x12,0xF1,0xB3,0x03,0x00,
    0xFE,0xFF,0x2D,0xC7,0x12,0x54,0x0E,0x52,0x04,0xDF,0xBB,0x17,0xAB,0x2D,0x10,0xEB,
    0x11,0x19,0xD6,0xA5,0xFE,0x4C,0xB1,0x60,0xFF,0xF3,0x28,0xC4,0x1C,0x0C,0x98,0xBE,
    0xBD,0x90,0xCE,0x18,0x4C,0x36,0x3B,0x19,0x42,0x7A,0xE9,0xB9,0xC9,0xCD,0x72,0x65,
    0xC5,0xAB,0x6B,0xB4,0x3F,0x30,0xE7,0x5E,0xF7,0x07,0x32,0x95,0x03,0x32,0x3B,0xC0,
    0xFF,0xFF,0xDD,0xC8,0x2D,0x35,0x43,0x2E,0x5E,0x04,0x80,0x86,0x71,0x94,0xE8,0xB6,
    0x05,0xD8,0x6A,0x14,0x71,0xFB,0xD5,0x94,0xF2,0xBD,0x39,0x16,0x99,0xAE,0xAD,0x90,
    0xFF,0xF3,0x28,0xC4,0x24,0x0C,0xE0,0xC6,0xC5,0x90,0xC3,0xC6,0x71,0x8A,0x64,0xA4,
    0xDA,0xAB,0x1B,0x06,0x31,0x25,0x6D,0xBB,0xB5,0xB1,0x00,0x1F,0xB5,0xFD,0xE1,0xBD,
    0x63,0x52,0x1F,0x33,0x39,0x3D,0xAD,0x04,0xC6,0x86,0x07,0x9E,0xFC,0x2F,0xD7,0x88,
    0x0F,0x48,0x37,0x95,0x31,0xF1,0xF3,0x44,0xF2,0x75,0x52,0xFA,0x2C,0xE6,0x0F,0x2D,
    0xC2,0xDD,0xA8,0xD5,0x9E,0xF8,0x18,0xF7,0xFF,0xF3,0x28,0xC4,0x2B,0x0C,0xA0,0x82,
    0xA8,0x00,0xCE,0x9E,0x48,0xB0,0x97,0xDE,0x2B,0x38,0x18,0x7E,0x95,0xFF,0xEF,0xEE,
    0xAF,0x9B,0x04,0x94,0xD0,0x2C,0x52,0xE3,0xDB,0x35,0x61,0x4F,0xFF,0xFF,0xFF,0xFF,
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF4,0x44,0xB4,0xE7,0x56,0xFF,0xFF,0xF4,0x4D,0x73,
    0x9C,0xE7,0x74,0x21,0x0F,0xE4,0x64,0xFF,0x5E,0x4A,0xD1,0x9F,0x3F,0xC8,0x74,0x00,
    0xFF,0xF3,0x28,0xC4,0x33,0x0D,0x23,0x0A,0xB4,0x00,0x78,0x44,0xB8,0x10,0x45,0xFF,
    0xFF,0x9F,0xFF,0xFF,0xFF,0xFF,0xE4,0xD9,0x54,0xAB,0x90,0x9F,0xA6,0xE9,0xE5,0xD9,
    0xAC,0x88,0xCC,0x45,0x29,0x8E,0xE1,0x0C,0xA2,0xDD,0x0E,0xD5,0x7A,0x21,0x24,0x44,
    0x45,0x51,0x34,0x7A,0xCA,0x8F,0x04,0x98,0xE6,0x52,0x89,0x07,0x04,0x7A,0xFA,0xC8,
    0x0C,0x60,0x30,0x85,0x74,0xDD,0x91,0xE7,0xFF,0xF3,0x28,0xC4,0x39,0x0B,0xAB,0x0E,
    0xC0,0x00,0x08,0x04,0xB9,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0x7F,0xFF,
    0x4B,0x39,0xBF,0xFF,0xAF,0x5E,0xCD,0x4C,0xDA,0x19,0x8E,0xA4,0x08,0xAA,0xC1,0x48,
    0xB5,0xD7,0x4F,0x7B,0x53,0x98,0xAD,0x04,0xA8,0x61,0xD9,0x22,0xB5,0xD5,0x7F,0x01,
    0xC7,0xC3,0xA9,0xC5,0x8C,0xBC,0x21,0x2D,0xC8,0x5B,0xC1,0x5C,0x2A,0x4C,0x65,0x4B,
    0xFF,0xF3,0x28,0xC4,0x45,0x0C,0x8A,0xFA,0xC4,0x00,0x10,0x44,0xB8,0xE6,0xA8,0x8F,
    0x00,0x67,0x3F,0xFF,0xFF,0xFF,0xFF,0xFD,0x0B,0x10,0x31,0xFF,0xFE,0xE8,0x5C,0x1A,
    0x7A,0xD5,0xF1,0xC0,0x94,0xEA,0x8F,0x00,0xE7,0x47,0x0A,0x80,0x08,0x85,0x28,0x79,
    0x9C,0x67,0x22,0x7D,0x5D,0x13,0x51,0xD8,0xEF,0xFF,0xFF,0xFF,0xFF,0xFE,0x93,0xA0,
    0xD8,0x22,0xEF,0xF7,0xFA,0x50,0x5C,0xE0,0xFF,0xF3,0x28,0xC4,0x4D,0x09,0x90,0x56,
    0xDC,0xCA,0x13,0xDE,0x26,0x98,0x77,0xF5,0xEB,0x81,0x01,0xE6,0x8C,0x01,0x09,0x40,
    0x6B,0x2C,0x8F,0xD7,0x4C,0xA2,0xC6,0x38,0x59,0x06,0xB5,0xC9,0x4E,0xA9,0x1F,0x64,
    0x76,0xFF,0xFF,0xFF,0xFF,0xFF,0xE9,0x40,0x99,0x22,0xA8,0xFF,0xF2,0x2F,0x26,0x2C,
    0x11,0x41,0x9F,0xB6,0xFA,0x95,0x40,0x79,0xFE,0x2D,0x0B,0x6D,0xCA,0x2C,0x9B,0xA7,
    0xFF,0xF3,0x28,0xC4,0x61,0x0A,0x80,0x5A,0xCC,0x00,0x3B,0xDE,0x24,0x0B,0xF0,0xBD,
    0x3C,0x53,0xA0,0xA3,0x40,0x17,0x12,0x16,0x89,0x3C,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,
    0xFF,0xFF,0xFF,0xFF,0xFF,0xCA,0xCA,0x02,0xFF,0x47,0xF2,0x2A,0xD4,0x48,0x2A,0x64,
    0xEF,0xFC,0xEA,0x15,0x06,0x02,0x00,0xD6,0x3A,0x0A,0x83,0x11,0x44,0x4F,0x8C,0x32,
    0x90,0x39,0x85,0x74,0xC0,0x43,0xD4,0x0A,0xFF,0xF3,0x28,0xC4,0x72,0x0B,0x10,0x66,
    0xC8,0xCA,0x2B,0xD8,0x28,0xF7,0x27,0xB0,0x23,0x99,0x72,0xBA,0xBF,0xFF,0xFF,0xFF,
    0xFF,0x85,0x45,0x04,0x8F,0xFF,0xFD,0x62,0x84,0xBF,0x5D,0x51,0x65,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0x80,0x0C,0x11,0xDA,0xB8,0x2A,0x79,0x44,0x94,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0x8A,0x0A,0xE0,0x5A,
    0x40,0x44,0x1B,0xDE,0x24,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0x99,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
};

const uint8_t serverConnecting[] = {
    
    0xFF,0xF3,0x28,0xC4,0x00,0x0B,0xE0,0x02,0xE6,0x37,0x40,0x10,0x02,0x89,0x12,0x56,
    0xAF,0xE8,0x27,0xC1,0x73,0xE2,0x70,0x39,0xF2,0x05,0x0E,0x02,0x00,0xF8,0x3E,0x1F,
    0xA8,0xE1,0x05,0x4F,0x97,0x5B,0xF7,0x1C,0xFE,0x53,0xAF,0x89,0xFF,0x5F,0xF5,0x9F,
    0x28,0xEE,0x43,0xF8,0x63,0x87,0xFF,0xE5,0xDE,0x73,0x77,0xF9,0x75,0xAF,0xED,0x42,
    0xB4,0xD3,0x0B,0x56,0x05,0xB0,0xCE,0x41,0xFF,0xF3,0x28,0xC4,0x0B,0x0E,0xC1,0xF2,
    0xE0,0x01,0x90,0x38,0x00,0xDC,0x91,0xC2,0xE6,0x79,0xB3,0x59,0x63,0xE2,0x5E,0x22,
    0x03,0x7F,0xD9,0xFB,0xFF,0xFF,0xFF,0x45,0xB3,0xFA,0x8D,0xD9,0x3A,0x88,0x8E,0xDB,
    0xA9,0xA6,0x9E,0xAC,0xFF,0xF9,0x2F,0x39,0x8D,0x24,0xC2,0x07,0x81,0x4D,0xA9,0xAA,
    0xF9,0xCE,0x77,0x7B,0xE8,0x03,0x32,0xA5,0x62,0xED,0xAD,0xBB,0x01,0xFD,0xC9,0x9E,
    0xFF,0xF3,0x28,0xC4,0x0B,0x0F,0x89,0xE3,0x22,0x5F,0xC5,0x38,0x02,0x34,0x38,0x06,
    0x35,0x58,0xB5,0xB3,0xC7,0x00,0x60,0x94,0x77,0xFF,0x1C,0x34,0xDF,0xFE,0xC7,0xB3,
    0x7F,0xE6,0x2D,0x8D,0xB7,0xD5,0x63,0xE3,0xCA,0x35,0x22,0x8F,0xFD,0xDA,0x69,0xBF,
    0xF9,0x8A,0xC3,0xA4,0x5B,0xCC,0x80,0x80,0xAE,0xE5,0xFA,0x2B,0x7F,0xED,0x7F,0xCA,
    0x2A,0xFD,0x75,0x31,0xB1,0x38,0x1E,0xD8,0xFF,0xF3,0x28,0xC4,0x07,0x0E,0xC1,0x5A,
    0xBC,0x00,0xA4,0x84,0x94,0x18,0xB6,0x60,0x34,0xC4,0x88,0x26,0x83,0x54,0xEF,0x91,
    0xC2,0x78,0x00,0x98,0x26,0x08,0x32,0xFF,0xE9,0x95,0xCD,0x7F,0xF9,0xD0,0xDF,0xFA,
    0x33,0xFF,0xA2,0x10,0x38,0x18,0x00,0x10,0xA6,0xF0,0x40,0x16,0x1F,0xEB,0x58,0x2B,
    0xF5,0xCF,0x72,0x84,0x8B,0x1E,0xD6,0x4C,0x11,0x1A,0x80,0xB0,0x1F,0xED,0x37,0xFC,
    0xFF,0xF3,0x28,0xC4,0x07,0x0F,0x01,0x86,0xD6,0x5E,0x6A,0x04,0x94,0x01,0xF6,0x4D,
    0x59,0xC1,0x24,0x02,0xE4,0xBA,0x39,0x4C,0xBD,0x9F,0xFE,0x4A,0x05,0x40,0xD4,0x77,
    0xFD,0xF6,0x90,0x5A,0x34,0xAF,0xCF,0xC8,0xB3,0x4A,0x5F,0xF5,0x60,0xC0,0x42,0x9F,
    0xD1,0x9E,0xEA,0x53,0x2B,0x75,0xF4,0x7A,0x0A,0x7F,0x8B,0x7E,0x5B,0xF0,0x55,0xDF,
    0x22,0x1A,0x1A,0x01,0xEE,0xFF,0xFF,0xFF,0xFF,0xF3,0x28,0xC4,0x06,0x0E,0xA0,0xC2,
    0xDE,0x5F,0x46,0x18,0x00,0x1C,0x01,0xFF,0xF9,0xEB,0x4B,0xEC,0x0C,0x02,0xDF,0x46,
    0x95,0x1E,0x0C,0x30,0xA3,0xB7,0x12,0x14,0x11,0x11,0x08,0xCD,0xCE,0x9B,0xFB,0x98,
    0x70,0x38,0xD6,0x01,0x08,0x40,0xA1,0xD2,0x6D,0x52,0x97,0x5C,0xA0,0x20,0x88,0x62,
    0xA7,0x56,0xCC,0xBA,0xDE,0xD2,0x9F,0xFF,0xF9,0x2A,0xA5,0xE8,0x12,0x11,0x08,0xC0,
    0xFF,0xF3,0x28,0xC4,0x06,0x0E,0x39,0x6E,0xE0,0x01,0x8D,0x68,0x00,0xC0,0x13,0xC1,
    0x90,0x07,0x89,0xA1,0x1A,0x64,0x4A,0x14,0x23,0x50,0x1A,0x62,0xC0,0x25,0x89,0x44,
    0xD3,0x40,0xB1,0xD6,0x22,0xD4,0x98,0x82,0x12,0xE8,0x2B,0x9E,0xD2,0xB5,0x6D,0xFF,
    0xFF,0xAF,0xFA,0x1C,0xC0,0xDF,0xD0,0x36,0x7F,0xD3,0x45,0x94,0x59,0xFF,0xD1,0xD1,
    0x02,0xCA,0x13,0x8E,0x8B,0x6D,0x14,0x01,0xFF,0xF3,0x28,0xC4,0x08,0x0D,0x99,0x77,
    0x26,0x5F,0xCD,0x28,0x02,0xFB,0xA5,0x9B,0x85,0x38,0xF1,0x35,0xFE,0x80,0xF4,0x25,
    0x92,0x7F,0x9C,0xE1,0x30,0x08,0x5B,0xFA,0x87,0xC6,0xB7,0xFF,0xFE,0x88,0xCE,0x5F,
    0xD4,0xEE,0x47,0x31,0x8C,0x67,0x90,0x84,0x30,0xA8,0x93,0xF5,0x19,0x73,0xDF,0x2E,
    0x2B,0xFF,0xFD,0x6A,0xFD,0x13,0xA9,0x13,0x81,0x60,0x14,0xC8,0xF5,0x50,0x33,0x16,
    0xFF,0xF3,0x28,0xC4,0x0C,0x0D,0x21,0x86,0xD0,0x00,0x6C,0x04,0x94,0x78,0x68,0x65,
    0x44,0xBF,0x33,0x0F,0xCC,0x2C,0xF0,0x8F,0x93,0x65,0x5B,0xA6,0x6A,0x8F,0xFB,0x14,
    0xBF,0xCE,0x9F,0xF4,0x2F,0xF4,0x21,0x45,0x2B,0x59,0x64,0x08,0x00,0x1C,0x44,0x0A,
    0xD2,0x5E,0x79,0xFB,0x7E,0xAA,0x28,0x62,0x2A,0x96,0x20,0x3D,0x50,0xA8,0x98,0x17,
    0x84,0x30,0x2E,0x94,0x4D,0xF1,0x37,0x06,0xFF,0xF3,0x28,0xC4,0x12,0x0C,0x78,0xAE,
    0xD1,0x94,0x3B,0xC4,0x4C,0x13,0x7C,0x23,0xA7,0x0F,0x87,0x6D,0x27,0x29,0x05,0x15,
    0xBF,0x85,0x12,0xEE,0xAF,0x67,0xAC,0x35,0xD4,0x0D,0x1E,0xC2,0x41,0xD0,0x6B,0xD9,
    0xD6,0xDF,0xFF,0xFB,0x13,0xFA,0xA3,0x98,0x02,0x62,0x07,0x92,0xF6,0xC3,0x75,0x29,
    0x12,0x30,0xC8,0x44,0x50,0x1A,0x73,0x4A,0x94,0x5D,0xED,0x26,0x12,0x89,0x67,0x2C,
    0xFF,0xF3,0x28,0xC4,0x1B,0x0C,0xF8,0x7A,0xB4,0x00,0x9E,0x30,0x48,0xEC,0x6B,0xC9,
    0xF4,0x9C,0xEE,0xFF,0xFE,0xAE,0x36,0xD9,0x7E,0x0F,0xFD,0xAF,0xFF,0xD3,0x22,0x59,
    0x6E,0xFF,0xFE,0xE0,0x64,0x34,0x18,0xE9,0xC2,0x4C,0x06,0xF0,0x34,0x51,0xDA,0xD6,
    0x20,0x80,0xBE,0x03,0xE8,0x00,0xE8,0xA4,0xCF,0x5D,0x22,0xC7,0xAD,0x5D,0xA1,0x67,
    0x28,0x95,0x41,0x1C,0x4E,0xEF,0xD9,0xFF,0xFF,0xF3,0x28,0xC4,0x22,0x0B,0x28,0x66,
    0xC8,0xCA,0x03,0xDE,0x28,0xFF,0xF4,0x3D,0x00,0x40,0x88,0x5A,0x85,0xA3,0xFF,0x45,
    0xFC,0x95,0x01,0x90,0x21,0x0F,0x94,0x52,0x72,0x34,0x07,0x68,0x5C,0x99,0xBB,0xCB,
    0xA6,0x20,0x14,0x0B,0x19,0x6A,0xAC,0x8D,0x30,0x6F,0xA2,0x9F,0xD9,0xBE,0xAD,0xFA,
    0xFF,0xFF,0xFF,0xFF,0xFB,0xDF,0xD0,0xE4,0xE6,0x02,0x14,0x40,0xF8,0xB8,0x88,0x59,
    0xFF,0xF3,0x28,0xC4,0x30,0x0C,0xE1,0xC6,0xC4,0x00,0x94,0x04,0x94,0xDF,0xF5,0x54,
    0x85,0x15,0xD0,0xE9,0x96,0x80,0x05,0x14,0x01,0xD6,0x81,0x99,0x80,0x27,0xC1,0xDC,
    0x15,0xD0,0xE2,0x56,0xB0,0x06,0x82,0xE1,0x20,0xB6,0x71,0x51,0xA1,0xC4,0xDF,0x53,
    0x4D,0x67,0xE7,0x50,0xEF,0x9D,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xF4,0x74,0x62,
    0xB0,0x61,0x4F,0x6F,0xFF,0xA9,0x10,0x27,0xFF,0xF3,0x28,0xC4,0x37,0x0D,0x31,0xCB,
    0x06,0x5E,0x6A,0x84,0x96,0x1D,0xDA,0xED,0x86,0xDB,0x01,0xF7,0xA4,0x1D,0x83,0x91,
    0x7F,0xB9,0x73,0x52,0x98,0xAC,0x5C,0x17,0x5F,0xFC,0xC9,0x23,0x10,0xC8,0x8C,0x9C,
    0x4E,0x07,0x0F,0xEF,0x98,0x07,0xC1,0xF3,0xFD,0x05,0x0E,0x7F,0xFF,0xD2,0xC7,0x7F,
    0xFD,0xBF,0xFA,0x3F,0xFE,0x53,0x1A,0x41,0xFD,0xEF,0x99,0x65,0x2B,0x7E,0x0C,0x30,
    0xFF,0xF3,0x28,0xC4,0x3D,0x0D,0x30,0x7A,0xEE,0x5E,0x6E,0x10,0x4A,0x16,0x0B,0x0E,
    0x8B,0x76,0xB6,0xF1,0xFC,0x47,0x72,0xDC,0xA5,0x7B,0xCB,0xB7,0xCB,0xE8,0xF6,0xFF,
    0xBF,0xFF,0xFF,0xFF,0xFE,0xEC,0xBD,0xAE,0xA8,0xCB,0x53,0xE8,0x3A,0x45,0x7B,0xAF,
    0xFF,0x3D,0xC8,0xD6,0xAD,0xEC,0xE7,0x64,0xDC,0x94,0x66,0xA3,0x6A,0x62,0xF5,0x4D,
    0xA4,0xCE,0x20,0x2A,0xEC,0xA7,0x45,0x77,0xFF,0xF3,0x28,0xC4,0x43,0x13,0x1B,0x12,
    0xA4,0x00,0xC0,0x8A,0xB9,0x21,0xE8,0x2C,0x38,0xC3,0x42,0x83,0xA7,0x93,0x4A,0xFF,
    0xFF,0xCF,0xFF,0x09,0xB9,0x6B,0x8E,0x14,0x61,0xC9,0x0B,0xD5,0xD7,0x88,0x4E,0x53,
    0x90,0x30,0xC6,0x2E,0x0B,0x03,0x0E,0xCC,0xE9,0xF9,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
    0xC9,0xFF,0xC8,0xDF,0xC8,0x42,0x1E,0xAE,0x76,0x46,0xFF,0xFF,0xFD,0xE8,0xEA,0x17,
    0xFF,0xF3,0x28,0xC4,0x31,0x0D,0x2A,0x42,0xBC,0x00,0xC1,0xC4,0xB8,0xFF,0xFF,0xFC,
    0x95,0xFC,0xFA,0x96,0x91,0x64,0x10,0x10,0x01,0x48,0xA4,0xC1,0x5C,0xD4,0xC8,0xD8,
    0xF5,0x9E,0x16,0xA0,0x0B,0xB4,0x85,0xDF,0xF4,0x06,0xD3,0x7F,0xEA,0xFF,0xE9,0xFF,
    0xD7,0xFF,0xA9,0x9F,0xF4,0x38,0x87,0xB9,0xE9,0x9E,0x11,0x2B,0xFF,0xE5,0xFE,0x5F,
    0xEB,0x3F,0xFF,0xFF,0xF5,0xAA,0xFA,0x8C,0xFF,0xF3,0x28,0xC4,0x37,0x0D,0x09,0xEA,
    0xBC,0x00,0xA4,0xCE,0x98,0x8C,0x4D,0x89,0xA0,0xF8,0x00,0x59,0x50,0x7C,0xA5,0x66,
    0x53,0x22,0xEF,0x99,0x81,0x58,0x3E,0xC4,0xF6,0xC9,0x7A,0x88,0x61,0x11,0x6F,0xFF,
    0xFF,0xD7,0xFF,0xFF,0xF9,0x5B,0xFF,0x56,0xF5,0x2E,0x84,0x0A,0x06,0x6B,0x9C,0xB2,
    0xBF,0x43,0xE9,0xA1,0x01,0xDA,0xAA,0xFA,0x0D,0x8B,0x80,0xF3,0x04,0x8D,0x29,0x37,
    0xFF,0xF3,0x28,0xC4,0x3D,0x0C,0xD1,0xBE,0xBC,0x00,0xA4,0x0A,0x94,0x0D,0xD0,0x85,
    0x59,0xDE,0x39,0xD4,0xC6,0x8E,0x52,0x02,0xA1,0x50,0xE9,0xEB,0xD3,0xEE,0xD4,0xAA,
    0x7F,0x5F,0xD1,0x9C,0xFF,0x39,0xF4,0x7C,0x93,0x1F,0x44,0xAA,0x1D,0xC8,0xFA,0x1C,
    0x3B,0xF3,0xAD,0xD1,0xCE,0xBE,0x2F,0x5B,0x2E,0x8B,0x91,0x22,0x2C,0x4A,0xA3,0xE6,
    0x15,0x14,0x5A,0x07,0x01,0x89,0x17,0x49,0xFF,0xF3,0x28,0xC4,0x44,0x0B,0xF8,0x96,
    0xA8,0x00,0x3E,0x10,0x4C,0x6D,0x4B,0x56,0x5F,0x9B,0xBE,0xE5,0xBD,0x24,0x75,0x05,
    0x04,0x02,0x43,0x01,0x15,0x7B,0x89,0x0F,0x84,0x6A,0x6C,0xDE,0x74,0x95,0x66,0xA1,
    0xD4,0x8C,0xD0,0xD6,0x01,0xCA,0x65,0xC4,0x89,0x3E,0x38,0x60,0x5C,0x00,0x7D,0x81,
    0x75,0x18,0x38,0x25,0x0E,0xD4,0x28,0xC7,0x28,0xA9,0x18,0x12,0xC4,0xFF,0xEF,0xF7,
    0xFF,0xF3,0x28,0xC4,0x4F,0x14,0x19,0x4E,0xA4,0x00,0x7A,0x06,0x70,0xB9,0x6A,0x41,
    0xFF,0xC7,0xFE,0xBC,0x15,0x0D,0x9C,0x03,0x68,0x85,0x19,0x02,0x34,0x42,0x42,0xEC,
    0x5B,0x70,0x61,0x97,0xCA,0xBF,0xFB,0x19,0xA1,0x52,0xDE,0x9A,0xC4,0xA0,0x18,0x70,
    0x95,0x91,0x0E,0x04,0x0D,0xA1,0x26,0xC0,0x44,0x9C,0x64,0x08,0xD3,0xBE,0xE5,0xFF,
    0x5E,0x7A,0x5A,0xF0,0xD7,0xFE,0xBA,0xEC,0xFF,0xF3,0x28,0xC4,0x39,0x0D,0xE0,0xE2,
    0xC0,0xCA,0x4A,0x46,0x70,0xA4,0xC5,0x70,0x0E,0x88,0x33,0x4B,0x99,0xD6,0x97,0xCB,
    0x59,0xE9,0x8B,0x08,0x0A,0xA4,0x24,0xB8,0x8D,0x76,0x92,0x35,0xE1,0xC1,0x36,0x05,
    0xDB,0x62,0xB8,0x0B,0x32,0x3D,0x6A,0x3A,0xF3,0x70,0x51,0xE5,0xA6,0x42,0x80,0x40,
    0xAD,0x3A,0x2A,0xFA,0xC3,0x1E,0x02,0xEA,0x06,0xF0,0x40,0x13,0x14,0xDA,0x49,0xD3,
    0xFF,0xF3,0x28,0xC4,0x3C,0x0B,0x90,0xA6,0xBC,0x00,0x96,0x58,0x4C,0x92,0x73,0x14,
    0x23,0x50,0x85,0x78,0xFE,0x4E,0x7B,0xD2,0x21,0xAA,0xE4,0x31,0xC2,0xBA,0x2F,0xA5,
    0x69,0xC6,0xA4,0x64,0x81,0x8A,0xC1,0x9A,0xE7,0x22,0x5A,0x80,0x03,0xC0,0x3F,0x5F,
    0x87,0xD4,0x89,0x96,0xE4,0xD0,0xDC,0x1D,0x63,0xAB,0xAE,0x41,0x50,0xD8,0x10,0x93,
    0x10,0x13,0x89,0x93,0x88,0x08,0x62,0x7F,0xFF,0xF3,0x28,0xC4,0x48,0x0A,0xA0,0x9E,
    0xB4,0x00,0x9E,0x5E,0x4C,0x0B,0x2D,0x61,0xB0,0xA4,0x0C,0x38,0xB9,0x79,0x65,0x8A,
    0x36,0x79,0x4A,0x4C,0xD9,0xA7,0x82,0x08,0x8A,0x6D,0x3C,0x02,0x14,0x12,0xB7,0x6C,
    0x00,0x1B,0x01,0xFC,0xBC,0x0E,0x10,0x5A,0xDF,0xBE,0x90,0x23,0xE2,0x71,0xFA,0x41,
    0x44,0x0E,0x34,0x8B,0xA8,0xB3,0xD7,0xEC,0x47,0x78,0xB3,0xB3,0x78,0x17,0xDF,0xF0,
    0xFF,0xF3,0x28,0xC4,0x58,0x0C,0xC0,0xAA,0xA8,0xF0,0xCE,0x58,0x4D,0x18,0x16,0x7F,
    0x07,0xFD,0x9F,0xFF,0xFF,0xFF,0xFF,0xFE,0x2B,0xFF,0xF6,0xAE,0x11,0xFC,0xE1,0x14,
    0x04,0xA0,0xD8,0x90,0x7F,0xF2,0xAF,0x56,0xBB,0x2A,0x30,0xC9,0x8E,0x53,0xC3,0x50,
    0x15,0x4D,0x6A,0x6F,0xF6,0xA8,0x63,0xB8,0x24,0x5A,0xFA,0xCE,0x42,0xD0,0x90,0x0C,
    0x40,0x94,0x3F,0xBE,0x54,0x50,0x4B,0x58,0xFF,0xF3,0x28,0xC4,0x60,0x0D,0x40,0xC6,
    0xEA,0x5E,0x6B,0x5E,0x72,0xE5,0x04,0x47,0x81,0xFE,0x3F,0xF3,0xCF,0xE5,0x0D,0x20,
    0x28,0x11,0xA9,0xCA,0xB0,0x46,0x63,0x71,0x38,0xDC,0x2D,0x83,0x9B,0x6E,0x11,0x4A,
    0x9D,0x0E,0x14,0xB3,0x96,0x79,0xD7,0x6B,0x3F,0x9F,0x33,0x95,0x08,0xD4,0x2F,0x3D,
    0x48,0x2C,0x16,0x0D,0x33,0xF6,0xE3,0x8B,0x35,0x17,0xD6,0x64,0xC2,0x00,0x02,0x10,
    0xFF,0xF3,0x28,0xC4,0x66,0x0B,0xB8,0xC2,0xA8,0x00,0x96,0x98,0x4D,0x0F,0x09,0x50,
    0x5A,0x5C,0x88,0x2C,0xA1,0xC8,0x3B,0xDE,0x23,0x65,0x42,0x31,0xC4,0xD7,0x69,0x65,
    0x4F,0x18,0x68,0xB9,0x99,0x12,0xC3,0xB4,0xF7,0x27,0x41,0xC2,0x0A,0xE0,0x24,0x44,
    0xB2,0x49,0xD6,0x92,0x0A,0x32,0x65,0xD2,0x7B,0x3A,0xD9,0x5F,0xEE,0xC8,0x27,0x5B,
    0x24,0xBF,0xF7,0x64,0xFE,0x8D,0x66,0x3F,0xFF,0xF3,0x28,0xC4,0x72,0x0C,0xE8,0xDA,
    0xAC,0x29,0x59,0x48,0x00,0x14,0x48,0x94,0xEF,0xDE,0x5D,0x07,0xD4,0x11,0x11,0x67,
    0xBC,0xE7,0x97,0x28,0xE4,0x05,0x42,0xE2,0xF3,0xA2,0x5F,0xFF,0x01,0xA4,0xCA,0x96,
    0x52,0x0D,0x89,0x45,0xA0,0x50,0x28,0xB4,0x0A,0x2D,0xB6,0xDB,0x2C,0x60,0x0C,0xB7,
    0x6D,0xDC,0x71,0x5D,0x8E,0x4F,0xDD,0xC9,0xFE,0x77,0xA7,0xDA,0xD9,0xD0,0xC4,0xFF,
    0xFF,0xF3,0x28,0xC4,0x79,0x16,0x71,0x3A,0x78,0x13,0x9B,0x68,0x00,0xFC,0xAE,0x21,
    0xFF,0x3F,0x23,0x21,0xD1,0x48,0xC4,0x4F,0x6F,0xB9,0x11,0x5A,0xCE,0xA7,0x12,0x14,
    0x60,0xE8,0x30,0x06,0x21,0xFE,0xFC,0x84,0x53,0xB9,0x09,0x38,0xB9,0x62,0x66,0x17,
    0xB2,0xA9,0x8E,0x3C,0x82,0xD6,0x6C,0x9B,0x6A,0x4C,0x8C,0xD8,0x7C,0xEC,0x07,0x51,
    0x70,0x41,0x70,0xE5,0xD8,0xE2,0x6E,0xF1,0xFF,0xF3,0x28,0xC4,0x5A,0x18,0x2B,0x22,
    0xEE,0x5F,0x82,0x28,0x02,0x70,0x71,0x41,0x10,0x40,0xF8,0x25,0x1B,0x6D,0xB6,0xC3,
    0x6D,0xB6,0xD5,0xD1,0xE2,0x5C,0xD2,0xBA,0xD1,0x74,0x84,0xAA,0x5E,0xDB,0xF4,0xFF,
    0x2A,0x2A,0xF7,0xF5,0xF5,0x92,0xFB,0x77,0x7B,0xFD,0x4A,0xBA,0x3E,0x67,0x42,0x33,
    0x59,0x32,0xCE,0xE5,0x65,0x63,0xAA,0x80,0xE6,0x50,0xE5,0x05,0x81,0x91,0x55,0x8E,
    0xFF,0xF3,0x28,0xC4,0x34,0x16,0xC3,0x13,0x0E,0x5F,0xC2,0x28,0x03,0xA6,0x17,0x62,
    0x21,0x99,0x4C,0xA5,0xB9,0x81,0x0E,0x2A,0x2A,0x61,0x53,0x15,0xC5,0x81,0x14,0x84,
    0x15,0x0D,0x71,0x76,0x52,0x32,0xCC,0x95,0xB7,0xFF,0xA2,0xA3,0xEA,0xAA,0x47,0x2A,
    0xA3,0xA0,0xB6,0xE6,0x1A,0x39,0x76,0xDB,0x6D,0xAC,0x8D,0x81,0xD0,0x4E,0x51,0xDE,
    0x13,0xC2,0x1D,0x0D,0x49,0x43,0x6A,0x59,0xFF,0xF3,0x28,0xC4,0x14,0x0E,0x00,0x5F,
    0x0E,0x5E,0x08,0xC6,0x2A,0xE5,0x97,0x41,0x15,0x80,0x50,0xB7,0xFA,0x75,0xCE,0xCD,
    0x56,0x89,0x87,0xFB,0x16,0xB0,0x63,0xA6,0xB7,0x88,0x48,0x93,0x7F,0xEF,0xB6,0xE4,
    0xB8,0x68,0xAB,0x82,0x5F,0xFF,0xF9,0xE2,0xE8,0xFD,0xEB,0xBF,0xF9,0x46,0xD1,0xF0,
    0x31,0x0A,0x89,0x9C,0xCA,0x20,0x68,0x65,0xEA,0x5C,0x85,0xA4,0x09,0x10,0x94,0x9B,
    0xFF,0xF3,0x28,0xC4,0x17,0x0F,0xB2,0x56,0xC0,0x00,0xC3,0x44,0xB8,0x2F,0xE8,0x2F,
    0xE8,0x59,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x4F,0xF4,0x6B,0x23,0x1C,0xEB,
    0x29,0xD0,0x89,0xCE,0xFF,0xDE,0xEF,0x46,0xAC,0xE0,0xC2,0xB8,0x44,0x61,0x1F,0xFF,
    0x2F,0x8D,0x53,0xD4,0x41,0xFF,0xFF,0xFA,0x8E,0x02,0x01,0x01,0x46,0x81,0x6B,0x52,
    0xB5,0xB5,0xDE,0x5F,0xF0,0x32,0x84,0xFC,0xFF,0xF3,0x28,0xC4,0x13,0x0C,0xC1,0xEE,
    0xC8,0x00,0xC3,0x44,0x98,0x64,0xA0,0x5C,0x2E,0x17,0x11,0x4B,0xFF,0xFF,0xFF,0xFF,
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0x8D,0x94,0xA5,0x65,0x12,0x59,0x61,0x6A,0xAA,
    0xEA,0x96,0x0D,0x21,0x29,0x81,0x01,0xE7,0xF8,0xED,0xE9,0xE5,0xF6,0x35,0xB6,0x32,
    0xE8,0x32,0xD6,0x42,0xB9,0x68,0xDF,0x6E,0x7E,0xCD,0x06,0x5D,0x46,0x6F,0xFF,0xFF,
    0xFF,0xF3,0x28,0xC4,0x1B,0x0B,0xC0,0x5E,0xCC,0xCB,0x4F,0x10,0x02,0xFF,0xFF,0xFF,
    0x4B,0x54,0x6C,0x4E,0x18,0x68,0xA5,0xAF,0x30,0xD6,0x23,0x59,0x00,0x12,0xFF,0xFF,
    0xE9,0x82,0x9A,0x96,0xDA,0xA7,0xE4,0x62,0x78,0x56,0x88,0x9E,0x80,0x69,0x9F,0x38,
    0x90,0x80,0xE1,0x64,0xA0,0x83,0xEA,0x89,0x64,0xD8,0x5A,0x0E,0x9C,0xE7,0xAE,0xFA,
    0x2F,0xAD,0x67,0x23,0xFF,0xA3,0xAF,0xFF,0xFF,0xF3,0x28,0xC4,0x27,0x15,0xEA,0xA6,
    0x8C,0x01,0x98,0x38,0x01,0xFF,0x9A,0xBE,0x94,0xFE,0xC9,0x44,0x38,0xE0,0x5A,0x22,
    0xBE,0x93,0x9C,0x77,0xFF,0x07,0x25,0x87,0x0A,0xCD,0x38,0xB9,0x54,0x07,0xC7,0x1A,
    0x44,0x74,0x6A,0x50,0x75,0x0E,0x52,0x85,0xCE,0xFF,0xF3,0x9B,0xD3,0x41,0xE2,0x8F,
    0x77,0xFF,0x0A,0x9C,0x68,0x22,0x00,0x6B,0x80,0xC0,0x7C,0x07,0xEC,0x71,0x22,0x56,
    0xFF,0xF3,0x28,0xC4,0x0A,0x0A,0x58,0x65,0xDC,0x7F,0xC6,0x08,0x00,0x0A,0x01,0x48,
    0xD4,0x58,0x91,0x2B,0x05,0x00,0xA4,0x69,0x14,0x58,0xEA,0x2A,0xFD,0x47,0xB9,0x6A,
    0x7F,0xFF,0xFF,0xC4,0xBF,0xFF,0xFF,0xFF,0xAC,0xEF,0xF9,0xD2,0xB5,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0x1B,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0x56,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0x91,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
};

const uint8_t serverConnectSucceed[] = {
    
    0xFF,0xF3,0x28,0xC4,0x00,0x0B,0x00,0x02,0xB5,0x6F,0x41,0x10,0x02,0x59,0x52,0x10,
    0x13,0x83,0xEE,0x58,0xA2,0x8C,0xAC,0x81,0x7B,0x16,0x17,0x88,0x2A,0xCA,0x19,0x53,
    0x8F,0xEA,0x1A,0x3C,0xFF,0x1A,0x2B,0x13,0xBD,0x73,0x3D,0xEB,0x07,0xE5,0x2A,0xFF,
    0xCF,0xFF,0xBD,0x1A,0x7F,0xFD,0x4E,0xFF,0x90,0x9E,0x95,0x55,0xBB,0x5D,0xA0,0x8E,
    0xF7,0x74,0x4B,0x3F,0x3B,0x75,0x2F,0x6B,0xFF,0xF3,0x28,0xC4,0x0F,0x0E,0xB1,0x5E,
    0xC4,0x01,0x82,0x10,0x00,0x23,0x33,0x13,0x42,0x90,0x1A,0xD1,0x20,0xA8,0x93,0x9E,
    0x56,0x77,0x3A,0x59,0x5F,0x9D,0x79,0x61,0x85,0x17,0xB6,0x70,0xE3,0xA7,0xDE,0x69,
    0xDB,0x5A,0x52,0x89,0x6A,0x2E,0x04,0x62,0x77,0x20,0x54,0x73,0xFF,0xD7,0xA3,0xDF,
    0xA1,0xFF,0xE7,0xFC,0x73,0x70,0x15,0x63,0x8C,0xB9,0xA8,0xD9,0xE7,0xE5,0xF0,0xE5,
    0xFF,0xF3,0x28,0xC4,0x0F,0x0E,0xE8,0xCE,0xC0,0x01,0xCF,0x30,0x00,0x05,0x42,0x01,
    0xE7,0xA5,0x31,0xE0,0x05,0xA7,0xFE,0xF7,0x32,0x41,0x21,0xF9,0xE7,0xD4,0x6B,0x4E,
    0x32,0x4D,0x50,0x68,0x55,0xBA,0xD9,0x0D,0x2B,0x44,0xCB,0x8D,0x4B,0x3E,0x49,0x2B,
    0x1A,0x64,0x51,0xBD,0x5E,0xEF,0xD5,0xFD,0x7F,0x5A,0xA0,0x04,0x92,0x88,0x20,0x1F,
    0xBA,0x9C,0x7C,0x00,0xBC,0x62,0x34,0x9A,0xFF,0xF3,0x28,0xC4,0x0E,0x10,0x78,0xA2,
    0xBD,0x94,0x6E,0x5E,0x4C,0x95,0xF1,0xA5,0xA5,0x9A,0x88,0x08,0x91,0x39,0xF3,0x16,
    0x01,0x5B,0x65,0x2C,0xB0,0x62,0xF6,0xE2,0xD8,0x1A,0x67,0x1A,0x6D,0x5D,0x09,0x89,
    0xC9,0x72,0x6B,0x02,0x20,0x91,0xA7,0xCA,0x80,0x80,0xC0,0xC2,0xCB,0x0F,0xA1,0xE8,
    0x5F,0xFF,0x7F,0xFF,0xFF,0xFF,0xA7,0xC5,0xD7,0x41,0x10,0x23,0xFA,0x0C,0xC6,0xC0,
    0xFF,0xF3,0x28,0xC4,0x07,0x0E,0x80,0xB2,0xB4,0xCA,0x56,0x5E,0x4C,0x12,0x4A,0xA0,
    0x79,0xAC,0xEA,0x04,0xB7,0xBE,0x53,0xAE,0x91,0x01,0xE7,0x26,0x26,0xB2,0x8F,0x8A,
    0x41,0x19,0x7D,0x5B,0x0D,0x64,0xA4,0x6E,0x08,0xF8,0x99,0xC6,0x81,0x67,0xA9,0x23,
    0x29,0x44,0xB4,0xE9,0xFC,0x77,0xC1,0xAF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE9,
    0x0C,0x08,0xC0,0x06,0x50,0x00,0xB2,0x81,0xFF,0xF3,0x28,0xC4,0x08,0x0F,0x30,0xC2,
    0xE2,0x5E,0x0E,0x0E,0x4E,0xF7,0x8A,0xE3,0x4A,0x4A,0xF0,0x71,0xE3,0x9C,0xD7,0x39,
    0xFB,0xB9,0x0D,0x02,0x41,0x27,0xE8,0x70,0xF0,0x16,0x18,0xFC,0x78,0xE8,0xA8,0x68,
    0x37,0x77,0x40,0x20,0xD0,0xB7,0xFF,0xFF,0xFF,0xFF,0xFD,0x56,0x38,0xCB,0x3F,0xA4,
    0x24,0x3C,0x22,0x0E,0xC2,0xA4,0x8A,0x0B,0x8B,0xA1,0x24,0x28,0x5A,0x76,0x80,0x2D,
    0xFF,0xF3,0x28,0xC4,0x06,0x0E,0x20,0x92,0xD5,0xBE,0x13,0xDE,0x4E,0xA0,0x7D,0x41,
    0x93,0xE3,0x8F,0x91,0x5B,0xAF,0x4F,0x8C,0x65,0xE3,0x7A,0x24,0x8C,0xC4,0xFE,0x97,
    0xAE,0xE0,0x5E,0x6C,0x1C,0x61,0x48,0xEA,0x92,0xD5,0x02,0x62,0x71,0xA8,0x94,0x75,
    0xFF,0xFF,0xFF,0xFF,0xFC,0xD8,0x33,0xE9,0xFA,0x3A,0x56,0x93,0xD7,0x3D,0x31,0x65,
    0x10,0x03,0xA4,0x97,0xFE,0x00,0xFA,0x34,0xFF,0xF3,0x28,0xC4,0x08,0x0C,0xF8,0xD6,
    0xD6,0x58,0x6B,0xF0,0x71,0x11,0x61,0x03,0x01,0x34,0x63,0x57,0x70,0xF7,0x4B,0x35,
    0xB9,0x05,0x40,0x5E,0x99,0x57,0xD7,0xFF,0x3D,0x80,0xE4,0x50,0x02,0xA8,0xDA,0x53,
    0x8F,0x72,0x93,0x0E,0xDC,0xA2,0x76,0xDD,0xFB,0x12,0x9B,0xF8,0x7E,0xB9,0x5D,0xE4,
    0x76,0xB6,0x17,0x2B,0x92,0xDB,0x40,0xA0,0x01,0xC7,0xF1,0x66,0x96,0x40,0x05,0x34,
    0xFF,0xF3,0x28,0xC4,0x0F,0x0F,0x70,0xE7,0x02,0x5E,0x45,0x12,0x72,0xD1,0xF4,0x16,
    0x78,0x83,0x81,0x88,0x44,0x0D,0x8F,0x17,0x9F,0xEA,0x20,0x05,0xB3,0x55,0x9E,0x86,
    0x6C,0xFF,0x13,0x41,0x50,0x32,0xC0,0xA5,0x84,0x49,0xBB,0x5B,0x3C,0x4C,0xD3,0x3A,
    0x03,0x58,0x11,0x1A,0xC2,0xE0,0xF9,0xFF,0xFF,0xFF,0xFE,0x42,0x19,0x36,0xCD,0xDA,
    0xED,0xB6,0xDA,0x81,0xC1,0x39,0x72,0x81,0xFF,0xF3,0x28,0xC4,0x0C,0x0D,0x11,0x27,
    0x02,0x5E,0x11,0x84,0x72,0x01,0x1D,0x1F,0x5A,0xF8,0xE6,0xA3,0xD1,0x6D,0xFE,0xAB,
    0x83,0x0E,0x96,0xF8,0x63,0x3F,0xF4,0x35,0x17,0xFA,0xFF,0x94,0x29,0x9F,0xE7,0x79,
    0xBF,0xF8,0xDF,0xF1,0x70,0xD2,0x2F,0xB9,0x7A,0x19,0xFF,0xFF,0xE5,0x2A,0xED,0x0F,
    0x92,0xE4,0x16,0xE8,0x0B,0x3F,0xFF,0xFD,0x7F,0xFF,0xFF,0xFF,0xFD,0x3F,0xEB,0x4B,
    0xFF,0xF3,0x28,0xC4,0x12,0x10,0xD3,0x16,0xB4,0x00,0x08,0x4A,0xB9,0xEF,0x54,0x91,
    0xBF,0x57,0x23,0x32,0x96,0x8C,0xFA,0x9C,0x84,0x6E,0xC7,0x9E,0x46,0x1A,0x3F,0x44,
    0x53,0xA3,0x10,0x92,0x1E,0x74,0x64,0x64,0x6B,0x1E,0x4A,0x10,0x8D,0xD0,0xEA,0x66,
    0x39,0xC0,0x71,0x61,0x46,0x71,0x30,0x3C,0x8A,0x26,0x10,0x61,0x11,0x69,0xEA,0xF5,
    0xFF,0xCC,0x67,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF3,0x28,0xC4,0x09,0x0D,0xA3,0x12,
    0xC8,0x00,0x08,0x4A,0xB9,0xFF,0xFF,0xFF,0xFF,0xAF,0xFF,0xDF,0x6A,0xB1,0x2A,0x8C,
    0x55,0xD3,0xEC,0xAF,0x22,0xF7,0x57,0x65,0x6A,0x88,0x87,0xC4,0xC0,0x48,0xB8,0x98,
    0xA4,0x82,0x8D,0xED,0xA3,0xF4,0x96,0x82,0xC9,0xF4,0x3A,0xD0,0x78,0xB2,0x8F,0x65,
    0x48,0x99,0x1A,0x3D,0x01,0x97,0xFF,0xD4,0xBD,0x05,0x80,0xF8,0x07,0x97,0xBE,0xE7,
    0xFF,0xF3,0x28,0xC4,0x0D,0x0C,0xE2,0x6E,0xD4,0xCA,0x58,0x44,0xB8,0xF7,0xFF,0xFF,
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEA,0xF3,0x53,0xB2,0xB5,0x9F,0xFE,0xF5,
    0xDC,0x8F,0x45,0x6E,0xEC,0xEC,0xA8,0x83,0x20,0x14,0x48,0xF6,0x7F,0x6F,0x26,0x5A,
    0x45,0x84,0x81,0x9A,0xFF,0xD7,0xE3,0x8D,0x5A,0x7A,0xD5,0xD0,0x98,0x52,0x6A,0x15,
    0x35,0xE8,0x78,0x4A,0x39,0xE6,0xA8,0xE0,0xFF,0xF3,0x28,0xC4,0x14,0x0D,0x09,0xD2,
    0xC0,0x00,0xC9,0xC4,0x94,0x38,0x19,0xFF,0xCC,0xFF,0xA3,0xB7,0xFF,0xFF,0xFF,0xFF,
    0xFF,0xFF,0xFF,0xFD,0xA3,0xB0,0x18,0x7A,0xAA,0xAB,0x16,0x4B,0x83,0x54,0x8B,0x82,
    0x2B,0x62,0xFF,0xFF,0xF4,0x55,0xAD,0x2A,0x9C,0x10,0xA4,0xEF,0xE6,0x5C,0xEB,0x63,
    0xAC,0xDE,0xCA,0xF9,0xCC,0xF1,0xC4,0xFA,0xDC,0x98,0x2B,0xC9,0x82,0x5F,0xEB,0xFF,
    0xFF,0xF3,0x28,0xC4,0x1A,0x0C,0xB0,0x62,0xB8,0x00,0x06,0x1E,0x28,0xFF,0xFF,0x36,
    0x28,0x16,0xA8,0xDA,0x9A,0xC2,0x28,0xBD,0x96,0x47,0x0B,0x04,0x81,0xD0,0xE1,0x62,
    0x34,0xE8,0xB1,0x17,0xE9,0xA5,0xF8,0x6D,0xA3,0x9C,0x8E,0xA6,0xB2,0x69,0xF5,0x2B,
    0x3A,0xE1,0x42,0x1B,0x81,0xCC,0x71,0x5C,0x06,0x17,0x0B,0x96,0x7E,0x05,0x11,0x7F,
    0xFF,0xFF,0xFF,0xB9,0xE2,0x04,0x52,0xA0,0xFF,0xF3,0x28,0xC4,0x22,0x0B,0xD8,0x5A,
    0xC0,0x00,0x06,0x1E,0x24,0xC9,0xC0,0x19,0xF4,0x10,0x5A,0x7B,0x56,0xE0,0x89,0x78,
    0x38,0x82,0x6A,0xFF,0xFD,0x37,0x9D,0x65,0xC0,0x18,0xC7,0x03,0xC3,0x7C,0xCB,0x27,
    0x83,0x44,0x9F,0x07,0x51,0x0A,0xA5,0xA1,0xDA,0x50,0x48,0xF7,0xFF,0xFF,0xFF,0xFF,
    0xFF,0x86,0x85,0xC7,0x99,0x4B,0x3F,0xD3,0x1E,0x1A,0x34,0x6C,0x7B,0x7F,0xA2,0x89,
    0xFF,0xF3,0x28,0xC4,0x2D,0x0A,0xF0,0x5E,0xC4,0x01,0x4F,0x10,0x00,0x41,0x19,0x4B,
    0xB3,0x7A,0x1A,0x6A,0x3F,0x2D,0x15,0x16,0x58,0x37,0x24,0x32,0x4C,0xEC,0xB4,0x48,
    0xA4,0xF2,0x41,0xE2,0x61,0x20,0x60,0x21,0x09,0x4D,0x07,0xC3,0x57,0x74,0x67,0x5E,
    0x72,0xFF,0xFF,0xE9,0x7F,0xFF,0x9F,0xFA,0xFF,0xFF,0x79,0xE7,0x98,0x68,0xD4,0xB5,
    0x7A,0x1C,0x36,0x2B,0xFF,0x2C,0x44,0xF3,0xFF,0xF3,0x28,0xC4,0x3C,0x16,0xA2,0x96,
    0x9C,0x01,0x98,0x38,0x00,0x07,0x09,0xBB,0x0D,0xC4,0x71,0x39,0x02,0x28,0xAD,0x34,
    0xD3,0x7A,0x58,0xB3,0xB1,0xBF,0x9A,0xAD,0x38,0x68,0x38,0x61,0x77,0xE7,0x84,0x47,
    0x84,0x42,0x59,0x6A,0xE4,0xDD,0x77,0x7F,0x4B,0x25,0xDF,0x64,0x90,0x12,0xB1,0x99,
    0xC6,0xBB,0x26,0x65,0xEE,0x85,0xD3,0x3D,0xCA,0x06,0x58,0xF3,0xEE,0xE2,0x40,0x0B,
    0xFF,0xF3,0x28,0xC4,0x1C,0x13,0x12,0x5A,0xA8,0x01,0x98,0x50,0x00,0x8D,0xDB,0xF8,
    0x96,0x21,0xE4,0xFF,0xF9,0xE6,0x13,0xFF,0xFE,0x93,0xCD,0x52,0x7F,0xFF,0xE7,0x98,
    0xAE,0x48,0x6F,0xFF,0xFE,0x50,0x92,0x40,0x48,0x37,0x20,0x24,0x26,0xDF,0xFF,0x7F,
    0xFC,0x90,0x90,0x78,0x3C,0x24,0x1E,0x38,0x54,0xD7,0xFF,0xFF,0x42,0x6A,0xFF,0xFD,
    0xFF,0xB3,0x89,0x7A,0xC7,0x86,0x16,0x64,0xFF,0xF3,0x28,0xC4,0x0A,0x0E,0x99,0xDE,
    0xD4,0x01,0x98,0x38,0x00,0x95,0x02,0xE1,0x49,0xDA,0xB5,0x20,0x12,0x86,0x8B,0x42,
    0x8C,0x78,0x1F,0x1D,0x07,0xA2,0xF5,0x2F,0x35,0x4C,0xA2,0x0B,0x69,0xFD,0xBD,0xFF,
    0xFF,0xD7,0xFF,0xFF,0xFE,0x8A,0x69,0xC6,0x3D,0x34,0xA6,0xDD,0xA8,0xEA,0x5D,0x95,
    0xBB,0x56,0xCD,0x56,0x25,0x55,0xFF,0xFF,0xD6,0x52,0xA1,0x1C,0x11,0x62,0x83,0x79,
    0xFF,0xF3,0x28,0xC4,0x0A,0x0E,0x81,0xBA,0xC8,0x01,0xD8,0x38,0x00,0x6F,0x51,0xE2,
    0xA9,0x60,0xD8,0xCD,0x34,0xBA,0x9B,0x29,0x28,0xC0,0xAC,0x63,0xFA,0x01,0x20,0x45,
    0x1B,0xC5,0x2F,0xF5,0x29,0xFA,0x9F,0xFD,0xFF,0x4F,0xFF,0xFF,0xFF,0xA2,0xA1,0x86,
    0x68,0x36,0x1E,0x67,0xC9,0x03,0x78,0x89,0xBA,0x10,0x97,0x96,0xE8,0x1A,0x6B,0x35,
    0x9B,0x6D,0x85,0xD8,0x01,0xF7,0x52,0x20,0xFF,0xF3,0x28,0xC4,0x0B,0x0D,0x38,0xA7,
    0x26,0x5E,0x54,0x16,0x4E,0x15,0x01,0xA0,0x9F,0x4B,0x54,0x81,0x1E,0x34,0x3A,0xD6,
    0xA4,0x18,0x95,0x13,0x2F,0xE1,0x25,0xCB,0x4F,0xC5,0xF2,0x8D,0x07,0x1F,0x22,0xEC,
    0x35,0xAF,0xDF,0xFF,0xFD,0x75,0x83,0x46,0xDC,0xF9,0xD3,0xD6,0x9E,0x6F,0xD2,0xFF,
    0xFF,0xCF,0x38,0x9C,0xF8,0x70,0x63,0x84,0xDC,0x39,0x5C,0x3F,0x97,0x30,0xBB,0x65,
    0xFF,0xF3,0x28,0xC4,0x11,0x0C,0x90,0x96,0xB4,0x01,0x5A,0x40,0x00,0x81,0x25,0xEC,
    0x73,0x98,0x63,0x72,0xDC,0x3B,0x24,0x05,0xA4,0x26,0xFB,0x48,0xA9,0xC1,0x5E,0x22,
    0x24,0xF8,0xB1,0xE7,0x7F,0xFF,0xFD,0xA2,0x22,0x4D,0x2C,0x1D,0x6D,0x83,0xAA,0x1B,
    0xED,0xF8,0x6D,0x8D,0x47,0xF7,0x97,0xF8,0x02,0x10,0x70,0x4F,0x0C,0x3D,0xFF,0x16,
    0xBD,0x6E,0x33,0xCF,0x0C,0x1C,0xEA,0x02,0xFF,0xF3,0x28,0xC4,0x19,0x12,0xC3,0x16,
    0xB4,0xCB,0x99,0x28,0x01,0x93,0x91,0x4E,0xC2,0x22,0xA8,0x23,0xEA,0xF3,0xD8,0xCA,
    0x86,0x4F,0x77,0xBF,0x47,0xA5,0xFF,0xFF,0xFF,0xFF,0xFF,0x45,0x35,0xBB,0xB9,0xD4,
    0x78,0xA7,0xFF,0xD7,0xFD,0x53,0xE4,0x33,0x48,0x55,0x27,0xFF,0xFF,0x7D,0xFA,0x76,
    0x8E,0x13,0x31,0xE8,0x73,0x0E,0x08,0xFA,0x17,0x59,0x70,0x36,0x00,0x04,0x40,0x7C,
    0xFF,0xF3,0x28,0xC4,0x09,0x0C,0xA1,0xD6,0xB8,0x01,0xCD,0x10,0x00,0x11,0xB3,0x72,
    0xFA,0x69,0xB7,0xAD,0x3F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEB,0xDE,
    0x9A,0x38,0xCF,0x45,0x7A,0x87,0xB8,0xB3,0xCB,0x1D,0x0A,0x34,0xE8,0xC2,0x5B,0xBF,
    0x2B,0xAD,0xC8,0x52,0x90,0x99,0x2A,0xFA,0xD2,0x5A,0xCC,0x89,0xA0,0x1E,0x00,0x0D,
    0xF0,0xD2,0x6C,0x59,0x22,0x24,0x96,0x87,0xFF,0xF3,0x28,0xC4,0x11,0x0C,0x91,0x9A,
    0xB8,0x00,0xA2,0x84,0x94,0x4E,0x42,0xA0,0x18,0x0D,0x83,0x43,0x15,0xFF,0x22,0x10,
    0x8D,0xFF,0x45,0xFF,0xEA,0xFF,0xFF,0xFF,0xFF,0xFA,0x28,0x00,0x85,0xE2,0xA4,0x0E,
    0x2E,0xA3,0x45,0x3F,0xEA,0x52,0xAA,0xFA,0x9F,0x51,0x98,0x88,0x01,0xA9,0x54,0x1C,
    0xC4,0xD4,0xB7,0xD2,0x7B,0x11,0x20,0x3D,0x9C,0xAE,0xB7,0xFA,0xAA,0x1C,0xB3,0x4F,
    0xFF,0xF3,0x28,0xC4,0x19,0x0D,0x01,0xFE,0xB8,0x00,0xA4,0xCE,0x98,0xFE,0x7F,0xFF,
    0xCC,0xFF,0xEA,0xFF,0xFA,0x0F,0x9F,0xFE,0xE2,0x30,0x09,0x09,0xDF,0xFB,0x31,0xAD,
    0xFF,0x43,0x9C,0xBF,0xB9,0xB6,0x76,0x13,0x3C,0x3F,0xF3,0xFF,0xC0,0x3C,0x08,0xDF,
    0x37,0x02,0x6A,0x22,0x5D,0x96,0xFD,0x7A,0xA5,0xA0,0x78,0x8F,0x67,0x6B,0x9E,0xFE,
    0xCA,0x49,0xAC,0xF8,0x6B,0xF7,0x7F,0x5E,0xFF,0xF3,0x28,0xC4,0x20,0x0C,0x68,0xA2,
    0xDD,0x94,0x0B,0x56,0x4C,0x2A,0x1D,0x42,0xC5,0x06,0xBD,0xAF,0x62,0x87,0x0D,0x0F,
    0x87,0x3C,0x2E,0x60,0xF9,0xC1,0x05,0x8E,0x41,0x7D,0x45,0x82,0x87,0x8D,0x86,0x8C,
    0xF8,0x8C,0x78,0xEF,0xF7,0x6F,0xFC,0x2E,0x16,0x0C,0xC1,0x32,0x65,0x0A,0x88,0x80,
    0xA0,0xB1,0xD0,0xA0,0xF0,0x90,0x50,0x0A,0x12,0x11,0x09,0x00,0x58,0x59,0xE1,0xA0,
    0xFF,0xF3,0x28,0xC4,0x29,0x0B,0xF0,0x06,0xC8,0x00,0x00,0x46,0x00,0xA8,0x08,0x90,
    0x49,0xAA,0xD2,0x49,0xEA,0xD0,0x10,0x05,0x02,0x30,0x0C,0x21,0x54,0x82,0x29,0x75,
    0x97,0xDF,0x7A,0xA5,0xE1,0xAC,0xF6,0xFE,0xB8,0x1B,0x36,0xC6,0xEE,0x35,0xF7,0xFD,
    0x39,0x1D,0x0E,0x85,0x30,0x89,0x19,0x97,0x42,0xDD,0xE5,0xB9,0xA5,0x32,0x8D,0x77,
    0xFF,0xFA,0xD9,0xA6,0xA5,0xF4,0x92,0x02,0xFF,0xF3,0x28,0xC4,0x34,0x0C,0x21,0x6A,
    0xBC,0x00,0x39,0x84,0x94,0x00,0x04,0x51,0x60,0x20,0xAC,0x9C,0x47,0xC0,0x30,0xDC,
    0xF6,0x95,0x4E,0x21,0x99,0x29,0x3A,0xF4,0xA6,0x60,0x30,0x4F,0x32,0x66,0x8B,0xB0,
    0x80,0x38,0x2D,0x76,0xE7,0x10,0xB6,0xEF,0x77,0xF3,0x73,0x61,0xEF,0xBD,0xDC,0xA6,
    0x62,0x40,0x77,0x2D,0xF4,0xCA,0x00,0x0B,0xA0,0x6E,0x61,0xB9,0xB9,0x14,0x49,0xBC,
    0xFF,0xF3,0x28,0xC4,0x3E,0x0C,0x71,0x02,0xC0,0x00,0x8B,0x0C,0x70,0x0C,0x2E,0x3F,
    0x34,0xC9,0x3D,0x8C,0xDB,0x8C,0x5C,0xFD,0x2E,0x2D,0xCA,0x2C,0xFF,0x20,0x08,0x92,
    0x5F,0xF7,0x00,0x91,0xCD,0xEF,0x25,0x7C,0xFF,0x9B,0x54,0xFE,0x54,0x0C,0x49,0x28,
    0x4D,0x82,0xBB,0xF8,0xFE,0x77,0x1B,0x50,0x0A,0xC1,0x14,0xAD,0x47,0xC8,0xDB,0x9F,
    0x22,0xA8,0x88,0x43,0xD6,0x57,0x12,0xDB,0xFF,0xF3,0x28,0xC4,0x47,0x0C,0xB8,0xFE,
    0xB4,0x00,0x9B,0xCC,0x71,0xFD,0xBA,0x95,0x2A,0xC0,0x01,0xC9,0xF7,0xE9,0x63,0x46,
    0x27,0xFF,0x59,0xEF,0x04,0x24,0x8D,0x4B,0x01,0x5E,0x65,0x46,0xB2,0x4F,0xAE,0x08,
    0x50,0x6B,0x96,0xDA,0x00,0x14,0x01,0xEA,0x59,0x80,0x7B,0x43,0xAC,0x02,0xAE,0x07,
    0xF8,0x6D,0xEB,0x21,0xA4,0x41,0xD1,0x51,0xD2,0x50,0xBC,0x91,0xB7,0xA0,0x10,0x14,
    0xFF,0xF3,0x28,0xC4,0x4F,0x0B,0x70,0x96,0xA0,0x00,0xD6,0x12,0x4C,0x92,0x94,0x4D,
    0xB1,0x50,0x54,0xC8,0x85,0xC5,0x9F,0x2A,0x0B,0x7F,0xFF,0xFF,0xFF,0xFF,0xBE,0x56,
    0x02,0x01,0x50,0x30,0x02,0x12,0x18,0x81,0x36,0x88,0x16,0x29,0x6A,0xC0,0x06,0x8B,
    0x14,0xAB,0x63,0x8F,0x93,0xF8,0xB8,0x1A,0xFA,0x44,0xF7,0xDE,0x77,0x10,0xCA,0x8F,
    0x16,0x60,0xB9,0x43,0xD7,0xD5,0xF0,0x6E,0xFF,0xF3,0x28,0xC4,0x5C,0x0C,0xF0,0x9A,
    0xDA,0x5F,0x54,0x10,0x02,0xF0,0xE1,0x00,0xD0,0x00,0xDC,0x7A,0xBE,0x16,0x8E,0x39,
    0x04,0x30,0x8A,0x8B,0x8F,0x7F,0xF8,0xA5,0xCB,0x04,0x40,0x76,0x19,0xBE,0xFD,0x7F,
    0xCD,0xD0,0x30,0xD7,0xF6,0xF9,0x4B,0xCE,0x4E,0xB7,0xFF,0xD3,0x76,0xBA,0xB2,0xBF,
    0xFA,0x6A,0x98,0x96,0x4D,0x4A,0xB0,0x89,0x3E,0xEC,0xF6,0x94,0xE9,0xC4,0x26,0x9F,
    0xFF,0xF3,0x28,0xC4,0x63,0x15,0x11,0x62,0x80,0xDD,0x9B,0x90,0x00,0xC5,0x2A,0x5D,
    0xE7,0x04,0x2A,0x42,0x78,0xC1,0xA8,0x50,0x91,0xED,0xD9,0x77,0x22,0x64,0x54,0x2E,
    0x10,0xC2,0xC1,0x4C,0x36,0x5C,0xC3,0x0B,0x9E,0x0C,0x0F,0x56,0x38,0xEE,0xC7,0x21,
    0xA4,0x9E,0x42,0xDB,0x68,0x5C,0xC9,0x10,0x3E,0xF4,0xC4,0x45,0xC1,0xA5,0x87,0x69,
    0x66,0x9D,0xBA,0xDF,0xC9,0x15,0x4B,0xB3,0xFF,0xF3,0x28,0xC4,0x49,0x16,0x98,0xEE,
    0xB0,0x01,0x98,0xD0,0x00,0xB9,0x81,0x40,0x44,0x45,0xB4,0xA1,0xC9,0xFF,0xFF,0xFF,
    0xFF,0xFF,0xB0,0x7B,0xFF,0xFD,0x15,0x90,0x02,0xD5,0x6B,0xFF,0xFB,0x60,0x15,0xCC,
    0x15,0xB1,0x99,0x98,0xC2,0x8F,0x34,0xE8,0x2D,0xEB,0x3C,0x44,0x04,0x70,0x1F,0x8B,
    0x10,0xF5,0x72,0x45,0x01,0x79,0x36,0xFB,0x8E,0x90,0x04,0xDA,0x4C,0xF4,0x6B,0xD6,
    0xFF,0xF3,0x28,0xC4,0x29,0x13,0x92,0xB2,0xF6,0x3F,0xCD,0x38,0x02,0x58,0xA7,0xD9,
    0x50,0x6E,0x5F,0xFD,0x1C,0xA0,0xD0,0xEF,0xCE,0x73,0xD1,0x0D,0xFD,0x9C,0xC3,0xFF,
    0xA2,0x33,0xFF,0xFF,0xF9,0xC6,0xBF,0x55,0xEA,0x4D,0x5F,0xFD,0x9F,0xFA,0x5C,0x83,
    0xAB,0x7A,0x95,0x19,0xA9,0x61,0x0A,0xFF,0xFF,0xFF,0x81,0xFB,0x79,0xE5,0x88,0x8D,
    0xA0,0x40,0x20,0x91,0x3A,0x76,0xE5,0x6C,0xFF,0xF3,0x28,0xC4,0x15,0x11,0xDA,0x57,
    0x06,0x5E,0x5B,0x44,0xBB,0x74,0x68,0x0A,0x24,0xBF,0xE4,0xD1,0x84,0xFA,0x15,0x98,
    0x97,0x03,0x90,0x52,0x36,0x3E,0xFB,0xA4,0xA7,0x62,0x9B,0xBF,0xFB,0xFF,0xE6,0x27,
    0xFE,0xEF,0xFF,0x5F,0xFD,0x7F,0xFF,0xFF,0x56,0x6F,0xF2,0x8D,0xBE,0x91,0x91,0xF1,
    0xFD,0xDF,0xD2,0x6B,0xDF,0x4A,0xFD,0x4A,0xA2,0x1D,0x69,0x8B,0x6D,0x86,0x17,0x00,
    0xFF,0xF3,0x28,0xC4,0x08,0x0D,0x40,0xEE,0xF6,0x5E,0x39,0xD4,0x72,0x9F,0x24,0xE6,
    0xD0,0x08,0x81,0x21,0x59,0x96,0x7B,0x12,0x0C,0x00,0xA0,0x67,0xB6,0x87,0x9A,0x02,
    0xA6,0x23,0xE4,0x43,0xE2,0x66,0x16,0x84,0x10,0xEB,0xFF,0xC7,0x8F,0xEB,0x7F,0xDD,
    0xFF,0xFD,0x7F,0xFF,0xF4,0xFA,0xCE,0x7A,0x46,0x95,0x11,0x89,0x2B,0x8B,0x6C,0x30,
    0x18,0x01,0xE9,0x31,0x0F,0xC0,0x51,0xA0,0xFF,0xF3,0x28,0xC4,0x0E,0x0E,0x50,0xEE,
    0xE6,0x5E,0x3B,0xCE,0x72,0xEB,0x77,0xFE,0xD5,0x62,0x28,0x78,0x68,0xCF,0x9B,0xEB,
    0x77,0xC6,0x39,0xC0,0x05,0x3D,0xB3,0x8C,0x5C,0xF1,0x30,0x96,0xF6,0xFA,0x8A,0x8F,
    0x7F,0x9D,0xFF,0xCB,0x1F,0xFF,0xFF,0xFF,0xE5,0x4C,0x94,0x01,0x03,0x40,0x53,0xA6,
    0x6A,0x00,0x30,0x18,0xDF,0x80,0x07,0x00,0x7D,0x49,0x5C,0x92,0x22,0x80,0x4A,0x84,
    0xFF,0xF3,0x28,0xC4,0x0F,0x0C,0xF0,0xF2,0xA5,0xBE,0x6B,0x4A,0x70,0xA9,0xB4,0xD9,
    0x9F,0x98,0x92,0x00,0xAD,0x09,0x52,0x4E,0xA4,0x96,0xD5,0x28,0x0A,0x2A,0x24,0xF9,
    0x5B,0x62,0x96,0x22,0x2A,0xC6,0xD7,0x88,0x94,0xEF,0x57,0xFF,0xFF,0xFF,0xFF,0xFA,
    0x56,0x5A,0x43,0x4F,0x66,0xF3,0x62,0x28,0x0A,0xAA,0x44,0x98,0x60,0x33,0x12,0x90,
    0x1A,0xC0,0xB0,0x2E,0xE4,0x4E,0x31,0x7A,0xFF,0xF3,0x28,0xC4,0x16,0x0D,0x08,0x96,
    0x24,0x02,0x66,0x1E,0x4C,0x9A,0x23,0x0C,0x17,0xA1,0x6D,0x33,0x90,0xB6,0x88,0x17,
    0x7B,0x48,0xD9,0x7B,0x47,0xD8,0x02,0xB3,0x5A,0x45,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,
    0xFF,0x6A,0xC8,0xD5,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0x1C,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0x57,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0x92,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x4C,0x41,0x4D,
    0x45,0x33,0x2E,0x39,0x39,0x2E,0x35,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xFF,0xF3,0x28,0xC4,0xC4,0x00,0x00,0x03,
    0x48,0x00,0x00,0x00,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
    
};

void downloadFile()
{
	uint32_t status;
	OSAFILE fp = OsaFopen("test1.mp3", "r");
	if (fp)
	{
		OsaFclose(fp);
		return;
	}
    // Create file 
    OSAFILE fp1 = OsaFopen("test1.mp3", "wb+");//BatteryCharging.mp3

    // Write mp3 data into file
    status = OsaFwrite((uint8_t *)batteryCharging, sizeof(batteryCharging), 1, fp1);
    if (status == 0)
    {
        while (1);
    }

    // After writing, close it
    OsaFclose(fp1);


    // Create file 
    fp1 = OsaFopen("test2.mp3", "wb+");//BatteryCharging.mp3

    // Write mp3 data into file
    status = OsaFwrite((uint8_t *)rebooting, sizeof(rebooting), 1, fp1);
    if (status == 0)
    {
        while (1);
    }

    // After writing, close it
    OsaFclose(fp1);


    // Create file
    fp1 = OsaFopen("test3.mp3", "wb+");//BatteryCharging.mp3

    // Write mp3 data into file
    status = OsaFwrite((uint8_t *)serverConnecting, sizeof(serverConnecting), 1, fp1);
    if (status == 0)
    {
        while (1);
    }

    // After writing, close it
    OsaFclose(fp1);

    // Create file
    fp1 = OsaFopen("test4.mp3", "wb+");//BatteryCharging.mp3

    // Write mp3 data into file
    status = OsaFwrite((uint8_t *)serverConnectSucceed, sizeof(serverConnectSucceed), 1, fp1);
    if (status == 0)
    {
        while (1);
    }

    // After writing, close it
    OsaFclose(fp1);
}







