#ifndef __CMS_NET_LIGHT_H__
#define __CMS_NET_LIGHT_H__
/******************************************************************************
 ******************************************************************************
 Copyright:      - 2017- Copyrights of AirM2M Ltd.
 File name:      - cmsnetlight.h
 Description:    - the head file for cmsnetlight.c
 History:        - 03/30/2020, Originated by xlhu
 ******************************************************************************
******************************************************************************/
#include "cms_util.h"
#include "osasys.h"

/******************************************************************************
 *****************************************************************************
 * MARCO
 *****************************************************************************
******************************************************************************/


/******************************************************************************
 *****************************************************************************
 * STRUCT
 *****************************************************************************
******************************************************************************/

/******************************************************************************
 *****************************************************************************
 * ENUM
 *****************************************************************************
******************************************************************************/
typedef enum CmsNetlightMode_Tag
{
    NET_LIGHT_DISABLE = 0,
    NET_LIGHT_ENABLE = 1
}
CmsNetlightMode;

typedef enum NetlightFlickerMode_Tag
{
	NETLIGHT_FLICKER_NONE = 0,
	NETLIGHT_FLICKER_FAST = 1,
	NETLIGHT_FLICKER_SLOW = 2,
}
NetlightFlickerMode;


/******************************************************************************
 ******************************************************************************
 * External global variable
 ******************************************************************************
******************************************************************************/



/******************************************************************************
 *****************************************************************************
 * Functions
 *****************************************************************************
******************************************************************************/
CmsRetId cmsNetlightMonitorCmiInd(const SignalBuf *indSignalPtr);
CmsRetId cmsNetlightMonitorCmiCnf(const SignalBuf *cnfSignalPtr);


#endif

