#include "cameraDrv.h"

camI2cCfg_t gc032A_2sdrRegInfo[] = 
{
    {0xf3,0x83},
    {0xf5,0x0c},
    {0xf7,0x01},// gavin 20160820
    {0xf8,0x01},
    {0xf9,0x4e},
    {0xfa,0x10}, // gavin 20160820
    {0xfc,0x02},
    {0xfe,0x02},
    {0x81,0x03},
    {0xfe,0x00},
    {0x77,0x64},
    {0x78,0x40},
    {0x79,0x60},
    /*Analog&Cisctl*/
    {0xfe,0x00},
    {0x03,0x01},
    {0x04,0xc2},
    {0x05,0x01},
    {0x06,0xb8},
    {0x07,0x00},
    {0x08,0x08},
    {0x0a,0x00},
    {0x0c,0x00},
    {0x0d,0x01},
    {0x0e,0xe8},
    {0x0f,0x02},
    {0x10,0x88},
    {0x17,0x54},
    {0x19,0x08},
    {0x1a,0x0a},
    {0x1f,0x40},
    {0x20,0x30},
    {0x2e,0x80},
    {0x2f,0x2b},
    {0x30,0x1a},
    {0xfe,0x02},
    {0x03,0x02},
    {0x05,0xd7},
    {0x06,0x60},
    {0x08,0x80},
    {0x12,0x89},
    
    /*SPI*/
    {0xfe,0x03},
    {0x51,0x01},
    {0x52,0x58}, // DDR Disable gavin 20160820
    {0x53,0x24}, // Disable CRC 
    {0x54,0x20},
    {0x55,0x00},
    {0x59,0x10},
    {0x5a,0x00},
    {0x5b,0x80},
    {0x5c,0x02},
    {0x5d,0xe0},
    {0x5e,0x01},
    {0x64,0x04}, //SCK Always OFF , gavin 20160820
    
    /*blk*/
    {0xfe,0x00},
    {0x18,0x02},
    {0xfe,0x02},
    {0x40,0x22},
    {0x45,0x00},
    {0x46,0x00},
    {0x49,0x20},
    {0x4b,0x3c},
    {0x50,0x20},
    {0x42,0x10},
    
    /*isp*/
    {0xfe,0x01},
    {0x0a,0xc5},
    {0x45,0x00},
    {0xfe,0x00},
    {0x40,0xff},
    {0x41,0x25},
    {0x42,0xcf},
    {0x43,0x10},
    {0x44,0x83},
    {0x46,0x22},
    {0x49,0x03},
    {0x52,0x02},
    {0x54,0x00},
    {0xfe,0x02},
    {0x22,0xf6},
    
    /*Shading*/
    {0xfe,0x01},
    {0xc1,0x38},
    {0xc2,0x4c},
    {0xc3,0x00},
    {0xc4,0x32},
    {0xc5,0x24},
    {0xc6,0x16},
    {0xc7,0x08},
    {0xc8,0x08},
    {0xc9,0x00},
    {0xca,0x20},
    {0xdc,0x8a},
    {0xdd,0xa0},
    {0xde,0xa6},
    {0xdf,0x75},
    
    /*AWB*//*20170110*/
    {0xfe, 0x01},
    {0x7c, 0x09},
    {0x65, 0x06},
    {0x7c, 0x08},
    {0x56, 0xf4},
    {0x66, 0x0f},
    {0x67, 0x84},
    {0x6b, 0x80},
    {0x6d, 0x12},
    {0x6e, 0xb0},
    {0xfe, 0x01},
    {0x90, 0x00},
    {0x91, 0x00},
    {0x92, 0xf4},
    {0x93, 0xd5},
    {0x95, 0x0f},
    {0x96, 0xf4},
    {0x97, 0x2d},
    {0x98, 0x0f},
    {0x9a, 0x2d},
    {0x9b, 0x0f},
    {0x9c, 0x59},
    {0x9d, 0x2d},
    {0x9f, 0x67},
    {0xa0, 0x59},
    {0xa1, 0x00},
    {0xa2, 0x00},
    {0x86, 0x00},
    {0x87, 0x00},
    {0x88, 0x00},
    {0x89, 0x00},
    {0xa4, 0x00},
    {0xa5, 0x00},
    {0xa6, 0xd4},
    {0xa7, 0x9f},
    {0xa9, 0xd4},
    {0xaa, 0x9f},
    {0xab, 0xac},
    {0xac, 0x9f},
    {0xae, 0xd4},
    {0xaf, 0xac},
    {0xb0, 0xd4},
    {0xb1, 0xa3},
    {0xb3, 0xd4},
    {0xb4, 0xac},
    {0xb5, 0x00},
    {0xb6, 0x00},
    {0x8b, 0x00},
    {0x8c, 0x00},
    {0x8d, 0x00},
    {0x8e, 0x00},
    {0x94, 0x50},
    {0x99, 0xa6},
    {0x9e, 0xaa},
    {0xa3, 0x0a},
    {0x8a, 0x00},
    {0xa8, 0x50},
    {0xad, 0x55},
    {0xb2, 0x55},
    {0xb7, 0x05},
    {0x8f, 0x00},
    {0xb8, 0xb3},
    {0xb9, 0xb6},
    
    /*CC*/
    {0xfe,0x01},
    {0xd0,0x40},
    {0xd1,0xf8},
    {0xd2,0x00},
    {0xd3,0xfa},
    {0xd4,0x45},
    {0xd5,0x02},
    {0xd6,0x30},
    {0xd7,0xfa},
    {0xd8,0x08},
    {0xd9,0x08},
    {0xda,0x58},
    {0xdb,0x02},
    {0xfe,0x00},
    
    /*Gamma*/
    {0xfe,0x00},
    {0xba,0x00},
    {0xbb,0x04},
    {0xbc,0x0a},
    {0xbd,0x0e},
    {0xbe,0x22},
    {0xbf,0x30},
    {0xc0,0x3d},
    {0xc1,0x4a},
    {0xc2,0x5d},
    {0xc3,0x6b},
    {0xc4,0x7a},
    {0xc5,0x85},
    {0xc6,0x90},
    {0xc7,0xa5},
    {0xc8,0xb5},
    {0xc9,0xc2},
    {0xca,0xcc},
    {0xcb,0xd5},
    {0xcc,0xde},
    {0xcd,0xea},
    {0xce,0xf5},
    {0xcf,0xff},
    
    /*Auto Gamma*/                      
    {0xfe,0x00},
    {0x5a,0x08},
    {0x5b,0x0f},
    {0x5c,0x15},
    {0x5d,0x1c},
    {0x5e,0x28},
    {0x5f,0x36},
    {0x60,0x45},
    {0x61,0x51},
    {0x62,0x6a},
    {0x63,0x7d},
    {0x64,0x8d},
    {0x65,0x98},
    {0x66,0xa2},
    {0x67,0xb5},
    {0x68,0xc3},
    {0x69,0xcd},
    {0x6a,0xd4},
    {0x6b,0xdc},
    {0x6c,0xe3},
    {0x6d,0xf0},
    {0x6e,0xf9},
    {0x6f,0xff},
    
    /*Gain*/
    {0xfe,0x00},
    {0x70,0x50},
    
    /*AEC*/
    {0xfe,0x00},
    {0x4f,0x01},
    {0xfe,0x01},
    {0x0d,0x00},//08 add 20170110  
    {0x12,0xa0},
    {0x13,0x3a},
    {0x44,0x04},
    {0x1f,0x30},
    {0x20,0x40},
    {0x26,0x9a},
    {0x3e,0x20},
    {0x3f,0x2d},
    {0x40,0x40},
    {0x41,0x5b},
    {0x42,0x82},
    {0x43,0xb7},
    {0x04,0x0a},
    {0x02,0x79},
    {0x03,0xc0},
    
    /*measure window*/
    {0xfe,0x01},
    {0xcc,0x08},
    {0xcd,0x08},
    {0xce,0xa4},
    {0xcf,0xec},
    
    /*DNDD*/
    {0xfe,0x00},
    {0x81,0xb8},
    {0x82,0x12},
    {0x83,0x0a},
    {0x84,0x01},
    {0x86,0x50},
    {0x87,0x18},
    {0x88,0x10},
    {0x89,0x70},
    {0x8a,0x20},
    {0x8b,0x10},
    {0x8c,0x08},
    {0x8d,0x0a},
    
    /*Intpee*/
    {0xfe,0x00},
    {0x8f,0xaa},
    {0x90,0x9c},
    {0x91,0x52},
    {0x92,0x03},
    {0x93,0x03},
    {0x94,0x08},
    {0x95,0x44},
    {0x97,0x00},
    {0x98,0x00},
    
    /*ASDE*/
    {0xfe,0x00},
    {0xa1,0x30},
    {0xa2,0x41},
    {0xa4,0x30},
    {0xa5,0x20},
    {0xaa,0x30},
    {0xac,0x32},
    
    /*YCP*/
    {0xfe,0x00},
    {0xd1,0x3c},
    {0xd2,0x3c},
    {0xd3,0x38},
    {0xd6,0xf4},
    {0xd7,0x1d},
    {0xdd,0x73},
    {0xde,0x84},
    {0xfe,0x00},
    {0x05,0x01},
    {0x06,0xad},
    {0x07,0x00},
    {0x08,0x10},
    {0xfe,0x01},
    {0x25,0x00},
    {0x26,0x4d},
    {0x27,0x01},
    {0x28,0xce},
    {0x29,0x03},
    {0x2a,0x02},
    {0x2b,0x03},
    {0x2c,0x9c},
    {0x2d,0x04},
    {0x2e,0x36},
    {0x2f,0x04},
    {0x30,0xd0},
    {0x31,0x05},
    {0x32,0x6a},
    {0x33,0x06},
    {0x34,0x04},
    {0xfe,0x00},
};

camI2cCfg_t gc032A_1sdrRegInfo[] = 
{
    {0xf3,0x83}, //sync_output_en data_output_en
	{0xf5,0x0c},
	{0xf7,0x01},
	{0xf8,0x01},
	{0xf9,0x4e},
	{0xfa,0x30},
	{0xfc,0x02},
	{0xfe,0x02},
	{0x81,0x03}, // doesn't show 0x81 addr
	/*Analog*/
	{0xfe,0x00},
	{0x03,0x01}, // exposure high
	{0x04,0xc2}, // exposure low
	{0x05,0x01},
	{0x06,0x91},
	{0x07,0x00},
	{0x08,0x10},
	{0x0a,0x04},
	{0x0c,0x04},
	{0x0d,0x01},
	{0x0e,0xe8}, // height: 488
	{0x0f,0x02},	
	{0x10,0x88},	// width: 652    VGA: 640*480
	{0x17,0x54},
	{0x19,0x04},
	{0x1a,0x0a},
	{0x1f,0x40},
	{0x20,0x30},
	{0x2e,0x80},
	{0x2f,0x2b},
	{0x30,0x1a},
	{0xfe,0x02},
	{0x03,0x02},
	{0x05,0xd7},
	{0x06,0x60},
	{0x08,0x80},
	{0x12,0x89},
	/*blk*/
	{0xfe,0x00},
	{0x18,0x02},
	{0xfe,0x02},
	{0x40,0x22},
	{0x45,0x00},
	{0x46,0x00},
	{0x49,0x20},
	{0x4b,0x3c},
	{0x50,0x20},
	{0x42,0x10},
	/*isp*/
	{0xfe,0x01},
	{0x0a,0xc5},
	{0x45,0x00},
	{0xfe,0x00},
	{0x40,0xff},
	{0x41,0x25},
	{0x42,0x83},
	{0x43,0x10},
	{0x44,0x83},
	{0x46,0x26},
	{0x49,0x03},
	{0x4f,0x01},
	{0xde,0x84},
	{0xfe,0x02},
	{0x22,0xf6},
	/*Shading*/
	{0xfe,0x00},
	{0x77,0x65},
	{0x78,0x40},
	{0x79,0x52},
	{0xfe,0x01},
	{0xc1,0x3c},
	{0xc2,0x50},
	{0xc3,0x00},
	{0xc4,0x32},
	{0xc5,0x24},
	{0xc6,0x16},
	{0xc7,0x08},
	{0xc8,0x08},
	{0xc9,0x00},
	{0xca,0x20},
	{0xdc,0x7a},
	{0xdd,0x7a},
	{0xde,0xa6},
	{0xdf,0x60},
	/*AWB*/
	{0xfe,0x01},
	{0x7c,0x09},
	{0x65,0x06},
	{0x7c,0x08},
	{0x56,0xf4},
	{0x66,0x0f},
	{0x67,0x84},
	{0x6b,0x80},
	{0x6d,0x12},
	{0x6e,0xb0},
	{0x86,0x00},
	{0x87,0x00},
	{0x88,0x00},
	{0x89,0x00},
	{0x8a,0x00},
	{0x8b,0x00},
	{0x8c,0x00},
	{0x8d,0x00},
	{0x8e,0x00},
	{0x8f,0x00},
	{0x90,0xef},
	{0x91,0xe1},
	{0x92,0x0c},
	{0x93,0xef},
	{0x94,0x65},
	{0x95,0x1f},
	{0x96,0x0c},
	{0x97,0x2d},
	{0x98,0x20},
	{0x99,0xaa},
	{0x9a,0x3f},
	{0x9b,0x2c},
	{0x9c,0x5f},
	{0x9d,0x3e},
	{0x9e,0xaa},
	{0x9f,0x67},
	{0xa0,0x60},
	{0xa1,0x00},
	{0xa2,0x00},
	{0xa3,0x0a},
	{0xa4,0xb6},
	{0xa5,0xac},
	{0xa6,0xc1},
	{0xa7,0xac},
	{0xa8,0x55},
	{0xa9,0xc3},
	{0xaa,0xa4},
	{0xab,0xba},
	{0xac,0xa8},
	{0xad,0x55},
	{0xae,0xc8},
	{0xaf,0xb9},
	{0xb0,0xd4},
	{0xb1,0xc3},
	{0xb2,0x55},
	{0xb3,0xd8},
	{0xb4,0xce},
	{0xb5,0x00},
	{0xb6,0x00},
	{0xb7,0x05},
	{0xb8,0xd6},
	{0xb9,0x8c},
	/*CC*/
	{0xfe,0x01},
	{0xd0,0x40},
	{0xd1,0xf8},
	{0xd2,0x00},
	{0xd3,0xfa},
	{0xd4,0x45},
	{0xd5,0x02},
	{0xd6,0x30},
	{0xd7,0xfa},
	{0xd8,0x08},
	{0xd9,0x08},
	{0xda,0x58},
	{0xdb,0x02},
	{0xfe,0x00},
	/*Gamma*/
	{0xfe,0x00},
	{0xba,0x00},
	{0xbb,0x04},
	{0xbc,0x0a},
	{0xbd,0x0e},
	{0xbe,0x22},
	{0xbf,0x30},
	{0xc0,0x3d},
	{0xc1,0x4a},
	{0xc2,0x5d},
	{0xc3,0x6b},
	{0xc4,0x7a},
	{0xc5,0x85},
	{0xc6,0x90},
	{0xc7,0xa5},
	{0xc8,0xb5},
	{0xc9,0xc2},
	{0xca,0xcc},
	{0xcb,0xd5},
	{0xcc,0xde},
	{0xcd,0xea},
	{0xce,0xf5},
	{0xcf,0xff},
	/*Auto Ga*/
	{0xfe,0x00},
	{0x5a,0x08},
	{0x5b,0x0f},
	{0x5c,0x15},
	{0x5d,0x1c},
	{0x5e,0x28},
	{0x5f,0x36},
	{0x60,0x45},
	{0x61,0x51},
	{0x62,0x6a},
	{0x63,0x7d},
	{0x64,0x8d},
	{0x65,0x98},
	{0x66,0xa2},
	{0x67,0xb5},
	{0x68,0xc3},
	{0x69,0xcd},
	{0x6a,0xd4},
	{0x6b,0xdc},
	{0x6c,0xe3},
	{0x6d,0xf0},
	{0x6e,0xf9},
	{0x6f,0xff},
	/*Gain*/
	{0xfe,0x00},
	{0x70,0x50},
	/*AEC*/
	{0xfe,0x00},
	{0x4f,0x01},
	{0xfe,0x01},
	{0x12,0xa0},
	{0x13,0x3a},
	{0x44,0x04},
	{0x1f,0x30},
	{0x20,0x40},
	{0x26,0x14},
	{0x27,0x01},
	{0x28,0xf4},
	{0x29,0x02},
	{0x2a,0x3a},
	{0x2b,0x02},
	{0x2c,0xac},
	{0x2d,0x02},
	{0x2e,0xf8},
	{0x2f,0x0b},
	{0x30,0x6e},
	{0x31,0x0e},
	{0x32,0x70},
	{0x33,0x12},
	{0x34,0x0c},
	{0x3c,0x00},
	{0x3e,0x20},
	{0x3f,0x2d},
	{0x40,0x40},
	{0x41,0x5b},
	{0x42,0x82},
	{0x43,0xb7},
	{0x04,0x0a},
	{0x02,0x79},
	{0x03,0xc0},
	/*measure*/
	{0xcc,0x08},
	{0xcd,0x08},
	{0xce,0xa4},
	{0xcf,0xec},
	/*DNDD*/
	{0xfe,0x00},
	{0x81,0xb8},
	{0x82,0x12},
	{0x83,0x0a},
	{0x84,0x01},
	{0x86,0x50},
	{0x87,0x18},
	{0x88,0x10},
	{0x89,0x70},
	{0x8a,0x20},
	{0x8b,0x10},
	{0x8c,0x08},
	{0x8d,0x0a},
	/*Intpee*/
	{0xfe,0x00},
	{0x8f,0xaa},
	{0x90,0x9c},
	{0x91,0x52},
	{0x92,0x03},
	{0x93,0x03},
	{0x94,0x08},
	{0x95,0x44},
	{0x97,0x00},
	{0x98,0x00},
	/*ASDE*/
	{0xfe,0x00},
	{0xa1,0x30},
	{0xa2,0x41},
	{0xa4,0x30},
	{0xa5,0x20},
	{0xaa,0x30},
	{0xac,0x32},
	/*YCP*/
	{0xfe,0x00},
	{0xd1,0x3c},
	{0xd2,0x3c},
	{0xd3,0x38},
	{0xd6,0xf4},
	{0xd7,0x1d},
	{0xdd,0x73},
	{0xde,0x84},
	/*SPI*/
	{0xfe,0x03},	// registers in REGF3
	{0x51,0x01},
	{0x52,0x0a},	// Y: 266
	{0x53,0x20}, // ֻ2bit0x20?
	{0x54,0x20},	// X: 0x220 = 544
	{0x55,0x00},
	{0x59,0x10},
	{0x5a,0x00}, // sync format
	{0x5b,0x80},
	{0x5c,0x02},	// image width640
	{0x5d,0xe0},
	{0x5e,0x01},	// image height480
};

uint16_t gc032aGetRegCnt(char* regName)
{
    if (strcmp(regName, "gc032a_2sdr") == 0)
    {
        return (sizeof(gc032A_2sdrRegInfo) / sizeof(gc032A_2sdrRegInfo[0]));
    }
    else if (strcmp(regName, "gc032a_1sdr") == 0)
    {
        return (sizeof(gc032A_1sdrRegInfo) / sizeof(gc032A_1sdrRegInfo[0]));
    }

    return 0;
}


