## 1. Setup and Use NextAuth.js in Next.js 13 App Directory

In this tutorial, I'll walk you through setting up authentication in your Next.js 13 app directory using NextAuth.js. It's worth noting that while we use the NextAuth package in this tutorial, you may be using the Auth.js package by the time you read this, as the libraries are now interchangeable.

![Setup and Use NextAuth.js in Next.js 13 App Directory](https://codevoweb.com/wp-content/uploads/2023/03/Setup-and-Use-NextAuth.js-in-Next.js-13-App-Directory.webp)

### Topics Covered

- Setup the Next.js 13 Project
- Setup Next Auth API Route
    - Create Reusable Buttons
- Three Ways of Getting the NextAuth Session Data
    - Get the Session in a Server Component
    - Get the Session in an API Route
    - Get the Session in a Client Component
- Integrate a Database
    - Setup PostgreSQL
    - Setup Prisma ORM
- Implement the NextAuth Authentication Code
- Store Custom Keys in the JWT
- Different Ways to Protect Routes
    - Client-Side Route Protection
    - Server-Side Route Protection
    - Protect an API Route
    - Middleware Route Protection
- Implement the Account Registration Logic
    - Create the API Route to Register Users
    - Create the Form Component
    - Create the Account Registration Page

Read the entire article here: [https://codevoweb.com/setup-and-use-nextauth-in-nextjs-13-app-directory/](https://codevoweb.com/setup-and-use-nextauth-in-nextjs-13-app-directory/)

## 2. Next.js - Use Custom Login and SignUp Pages for NextAuth.js

In this article, you will learn how to integrate custom login and signup pages with NextAuth.js in the new Next.js 13 app directory. Am going to assume that you have already set up NextAuth in your project and that you are only looking for a way to integrate your custom login and signup pages.

![Next.js - Use Custom Login and SignUp Pages for NextAuth.js](https://codevoweb.com/wp-content/uploads/2023/05/Next.js-13-Use-Custom-Login-and-SignUp-Pages-for-NextAuth.js.webp)

### Topics Covered

- Run the NextAuth Project on your Computer
- Test the NextAuth Project
    - Register an Account
    - Log into your Account
    - Access a Protected Page
- Configure the NextAuth API Endpoint
- Create the Custom Login Page
    - Create the Login Form
    - Create the Login Page
- Create the Custom SignUp Page
    - Create the SignUp Form
    - Create the Account Registration Page
- Create the API Handler for Account Registration
- Conclusion

Read the entire article here: [https://codevoweb.com/nextjs-use-custom-login-and-signup-pages-for-nextauth-js/](https://codevoweb.com/nextjs-use-custom-login-and-signup-pages-for-nextauth-js/)

## 3. Next.js - Add Google and GitHub OAuth2 using NextAuth.js

In this article, you will learn how to integrate Google and GitHub OAuth providers with NextAuth.js in the new Next.js 13 app directory. It's worth noting that I am using a specific pull request recommended by the NextAuth team that is compatible with the new Next.js 13 app directory.

![Next.js - Add Google and GitHub OAuth2 using NextAuth.js](https://codevoweb.com/wp-content/uploads/2023/05/Next.js-Add-Google-and-GitHub-OAuth2-using-NextAuth.js.webp)

### Topics Covered

- Run the NextAuth Project Locally
- Explore the GitHub and Google OAuth Flow
    - Sign in with Google OAuth2
    - Sign in with GitHub OAuth
- Configure NextAuth with Google and GitHub OAuth
- Implement the Google and GitHub OAuth2
    - Create the Client-Side Form
    - Create the Server-Side Page Component
- How to Generate the Google OAuth2 Credentials
- How to Generate the GitHub OAuth Credentials
- Conclusion

Read the entire article here: [https://codevoweb.com/nextjs-add-google-and-github-oauth2-using-nextauth-js/](https://codevoweb.com/nextjs-add-google-and-github-oauth2-using-nextauth-js/)


