# mma-fighter-finder
> mma 선수들의 정보를 제공하는 사이트

### 링크
- [실행화면](#실행화면)
- [프로젝트를 마치고](#프로젝트를-마치고)

## 실행화면
- 선수 검색 화면  
	- ![](https://user-images.githubusercontent.com/54667577/110948555-d6f16c80-8384-11eb-9e2c-75afc74554db.png)
	- ![](https://user-images.githubusercontent.com/54667577/110948546-d527a900-8384-11eb-8fda-ae3ea57ceba5.png)

- 전체 실행화면 
	- ![](https://user-images.githubusercontent.com/54667577/110946940-dce64e00-8382-11eb-9960-b6a30bf2f1fd.gif)


## 프로젝트를 마치고
### 1. 첫 리액트 프로젝트로, 전부터 생각했었던 격투기 선수들의 전적을 찾아주는 사이트를 개발해보았다.
2021년 3월 경에 간단하게 리액트로 제작한 첫 프로젝트였는데, 생각보다 정말로 의미 있는 개발이었다. 첫 토이 프로젝트이기 때문이기도 하지만, 실제로 꾸준히 쓰이는 결과물이라서 더욱 그렇다. 격투기 선수들의 전적을 볼 수 있는 사이트가 적고, 그마저도 접근성이 불편하다고 생각되어서 한번 만들어본 사이트인데, 격투기를 좋아하는 친구들 사이에선 종종 사용하고 있다.

그래서 사이트를 방치하지 않고, 문제가 생길 때 마다 최대한 고치려고 하는 중이다. 처음에 반응형을 지원하지 지원하지 않다가 반응형으로 개발하기도 하였으며, 서버에 문제가 생길 때마다 최대한 에러를 픽스하려고 한다.

### 2. 생각보다 정말 간단한 개발이어서, contextAPI와 같은 상태관리 툴을 사용하지 않았던 점이 조금 아쉬웠다.
기술보다는 처음에 이 아이디어로 꼭 만들어보고 싶다고 생각하고 만들어서 개발을 시작했는데, 막상 생각해보니 서버에서 데이터를 가져와서 뿌려주기만 하면 되는 앱이라서 기술적으로는 너무 아쉬웠다.

이러한 아쉬움들이 쌓여서 나중에 [todo 앱](https://todo.woog2roid.dev)을 [프론트(react)](https://github.com/woog2roid/todo-frontend)와 [백(express)](https://github.com/woog2roid/todo-backend) 풀스택으로 개발하기도 하였다. 후에도 진행했던 토이 프로젝트에서도 프로젝트를 진행하며 배우는 점이 아쉬웠었으며, 백엔드도 배워보고 싶었기에 하게 되었다. 

### 3. [woog2roid/mma-api](https://github.com/woog2roid/mma-api)를 이용해서 api 서버를 제작하였다.
원래 쓰려고 생각한 [오픈소스 mma-api](https://github.com/valish/mma-api)가 있었는데 돌아가질 않아서, [fork해서 아주 약간 손을 봤다](https://github.com/woog2roid/mma-api-deprecated). 하지만 백에서 크롤링을 하여서 데이터를 보내주다보니, sherdog의 양식이 바뀌어서 다시 api를 작성하기도 했다.

최근(2022년 6월 경)에도 사이트가 작동하지 않는다하여 확인해보니 googleIt에서 제대로 크롤링을 해주지 못하고 있어서 사이트가 작동하지 않고 있다. 확실히 크롤링을 통해서 서버에서 데이터를 수집해서 보내주다보니, 안정적이지는 못한 것 같다.

### 4. 처음으로 배포를 하면서 많이 배우게 된 계기가 되었다.
Github Pages를 통해 프론트를 배포를 하고 [https://server.woog2roid.dev](https://server.woog2roid.dev)라는 개인 도메인을 가진 백엔드에서 데이터를 주는 구조를 가지게 배포를 하면서 많은 시행착오들이 있었다. 어떻게 해야 백엔드를 배포할 수 있을까에서 시작하여 무료 클라우드 서버에 노드를 돌리는 것으로 시작하여, 서버가 https 연결이 되지 않아서 이용이 불편하다는 점이 마음에 걸려 결국 개인 도메인을 구매하고 let's encrypt를 이용하여 https 연결을 지원하였다.