/*
 * Copyright 2022-2023 Wonderflow Design Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// eslint-disable-next-line import/no-extraneous-dependencies
import Color from 'tinycolor2';

export default {
  name: 'color/hslvalue',
  type: 'value',
  matcher: (prop: any) => prop.attributes.category === 'color',
  transformer: (token: any) => {
    const color = Color(token.value);
    const o = color.toHsl();
    const vals = `${Math.round(o.h)} ${Math.round(o.s * 100)}% ${Math.round(o.l * 100)}%`;

    if (color.getAlpha() === 1) {
      return `${vals}`;
    }

    return `${vals} / ${o.a}`;
  },
};
