/*
 * Copyright 2023-2024 Wonderflow Design Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

export const channels = [
  {
    channel: 'amazon.ca',
    '1 star': 159,
    '2 stars': 51,
    '3 stars': 66,
    '4 stars': 157,
    '5 stars': 150,
  },
  {
    channel: 'amazon.co.uk',
    '1 star': 33,
    '2 stars': 8,
    '3 stars': 18,
    '4 stars': 18,
    '5 stars': 241,
  },
  {
    channel: 'amazon.com',
    '1 star': 679,
    '2 stars': 284,
    '3 stars': 370,
    '4 stars': 866,
    '5 stars': 830,
  },
  {
    channel: 'amazon.com.au',
    '1 star': 0,
    '2 stars': 0,
    '3 stars': 1,
    '4 stars': 0,
    '5 stars': 3,
  },
  {
    channel: 'amazon.de',
    '1 star': 21,
    '2 stars': 6,
    '3 stars': 11,
    '4 stars': 12,
    '5 stars': 86,
  },
  {
    channel: 'amazon.es',
    '1 star': 0,
    '2 stars': 0,
    '3 stars': 0,
    '4 stars': 0,
    '5 stars': 6,
  },
  {
    channel: 'amazon.fr',
    '1 star': 18,
    '2 stars': 3,
    '3 stars': 9,
    '4 stars': 10,
    '5 stars': 78,
  },
  {
    channel: 'amazon.in',
    '1 star': 16,
    '2 stars': 4,
    '3 stars': 9,
    '4 stars': 7,
    '5 stars': 66,
  },
  {
    channel: 'amazon.it',
    '1 star': 22,
    '2 stars': 4,
    '3 stars': 9,
    '4 stars': 11,
    '5 stars': 98,
  },
  {
    channel: 'amazon.nl',
    '1 star': 4,
    '2 stars': 0,
    '3 stars': 1,
    '4 stars': 3,
    '5 stars': 23,
  },
  {
    channel: 'bedbathandbeyond.com',
    '1 star': 421,
    '2 stars': 236,
    '3 stars': 529,
    '4 stars': 3217,
    '5 stars': 3554,
  },
  {
    channel: 'bestbuy.ca',
    '1 star': 388,
    '2 stars': 242,
    '3 stars': 562,
    '4 stars': 3548,
    '5 stars': 3863,
  },
  {
    channel: 'canadiantire.ca',
    '1 star': 311,
    '2 stars': 193,
    '3 stars': 468,
    '4 stars': 3108,
    '5 stars': 3448,
  },
  {
    channel: 'darty.com',
    '1 star': 0,
    '2 stars': 0,
    '3 stars': 0,
    '4 stars': 0,
    '5 stars': 5,
  },
  {
    channel: 'myer.com.au',
    '1 star': 286,
    '2 stars': 181,
    '3 stars': 452,
    '4 stars': 2984,
    '5 stars': 3350,
  },
  {
    channel: 'otto.de',
    '1 star': 19,
    '2 stars': 18,
    '3 stars': 56,
    '4 stars': 56,
    '5 stars': 184,
  },
  {
    channel: 'productreview.com.au',
    '1 star': 19,
    '2 stars': 13,
    '3 stars': 9,
    '4 stars': 20,
    '5 stars': 130,
  },
  {
    channel: 'target.com',
    '1 star': 349,
    '2 stars': 206,
    '3 stars': 484,
    '4 stars': 3264,
    '5 stars': 3635,
  },
  {
    channel: 'wayfair.com',
    '1 star': 128,
    '2 stars': 64,
    '3 stars': 120,
    '4 stars': 588,
    '5 stars': 766,
  },
];

export const channelsB = [
  {
    channel: 'bestbuy.ca',
    '1 star': { value: 388, percentage: 10 },
    '2 stars': { value: 242, percentage: 8 },
    '3 stars': { value: 562, percentage: 12 },
    '4 stars': { value: 3548, percentage: 21 },
    '5 stars': { value: 3863, percentage: 87 },
    overlay: { value: 3.8, percentage: 7 },
  },
  {
    channel: 'amazon.com',
    '1 star': { value: 339, percentage: 10 },
    '2 stars': { value: 208, percentage: 10 },
    '3 stars': { value: 418, percentage: 24 },
    '4 stars': { value: 3218, percentage: 18 },
    '5 stars': { value: 3637, percentage: 67 },
    overlay: { value: 3.6, percentage: 6 },
  },
  {
    channel: 'bedbathandbeyond.com',
    '1 star': { value: 421, percentage: 13 },
    '2 stars': { value: 234, percentage: 2 },
    '3 stars': { value: 529, percentage: 0 },
    '4 stars': { value: 3216, percentage: 28 },
    '5 stars': { value: 3541, percentage: 76 },
    overlay: { value: 1, percentage: 3 },
  },
  {
    channel: 'canadiant.ca',
    '1 star': { value: 310, percentage: 1 },
    '2 stars': { value: 193, percentage: 0 },
    '3 stars': { value: 468, percentage: 2 },
    '4 stars': { value: 3109, percentage: 41 },
    '5 stars': { value: 3444, percentage: 54 },
    overlay: { value: 3.4, percentage: 5 },
  },
  {
    channel: 'myer.max.au',
    '1 star': { value: 286, percentage: 2 },
    '2 stars': { value: 181, percentage: 0 },
    '3 stars': { value: 511, percentage: 4 },
    '4 stars': { value: 2912, percentage: 5 },
    '5 stars': { value: 3086, percentage: 12 },
    overlay: { value: 1.8, percentage: 1 },
  },
];

export const nestedChannels = [
  {
    name: 'bestbuy.ca',
    values: [
      {
        value: 388,
        valueInfo: 0,
        label: 'bestbuy.ca',
        label2: 1,
      },
      {
        value: 242,
        valueInfo: 0,
        label: 'bestbuy.ca',
        label2: 2,
      },
      {
        value: 562,
        valueInfo: 0,
        label: 'bestbuy.ca',
        label2: 3,
      },
      {
        value: 3548,
        valueInfo: 2,
        label: 'bestbuy.ca',
        label2: 4,
      },
      {
        value: 38635,
        valueInfo: 17,
        label: 'bestbuy.ca',
        label2: 5,
      },
    ],
  },
  {
    name: 'target.com',
    values: [
      {
        value: 349,
        valueInfo: 0,
        label: 'target.com',
        label2: 1,
      },
      {
        value: 206,
        valueInfo: 0,
        label: 'target.com',
        label2: 2,
      },
      {
        value: 484,
        valueInfo: 0,
        label: 'target.com',
        label2: 3,
      },
      {
        value: 3264,
        valueInfo: 1,
        label: 'target.com',
        label2: 4,
      },
      {
        value: 36357,
        valueInfo: 16,
        label: 'target.com',
        label2: 5,
      },
    ],
  },
  {
    name: 'bedbathandbeyond.com',
    values: [
      {
        value: 421,
        valueInfo: 0,
        label: 'bedbathandbeyond.com',
        label2: 1,
      },
      {
        value: 236,
        valueInfo: 0,
        label: 'bedbathandbeyond.com',
        label2: 2,
      },
      {
        value: 529,
        valueInfo: 0,
        label: 'bedbathandbeyond.com',
        label2: 3,
      },
      {
        value: 3217,
        valueInfo: 1,
        label: 'bedbathandbeyond.com',
        label2: 4,
      },
      {
        value: 35541,
        valueInfo: 16,
        label: 'bedbathandbeyond.com',
        label2: 5,
      },
    ],
  },
  {
    name: 'canadiantire.ca',
    values: [
      {
        value: 311,
        valueInfo: 0,
        label: 'canadiantire.ca',
        label2: 1,
      },
      {
        value: 193,
        valueInfo: 0,
        label: 'canadiantire.ca',
        label2: 2,
      },
      {
        value: 468,
        valueInfo: 0,
        label: 'canadiantire.ca',
        label2: 3,
      },
      {
        value: 3108,
        valueInfo: 1,
        label: 'canadiantire.ca',
        label2: 4,
      },
      {
        value: 34484,
        valueInfo: 16,
        label: 'canadiantire.ca',
        label2: 5,
      },
    ],
  },
  {
    name: 'myer.com.au',
    values: [
      {
        value: 286,
        valueInfo: 0,
        label: 'myer.com.au',
        label2: 1,
      },
      {
        value: 181,
        valueInfo: 0,
        label: 'myer.com.au',
        label2: 2,
      },
      {
        value: 452,
        valueInfo: 0,
        label: 'myer.com.au',
        label2: 3,
      },
      {
        value: 2984,
        valueInfo: 1,
        label: 'myer.com.au',
        label2: 4,
      },
      {
        value: 33501,
        valueInfo: 15,
        label: 'myer.com.au',
        label2: 5,
      },
    ],
  },
];
