/*
 * Copyright 2023 Wonderflow Design Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { CustomColumnsType, OptionalDataTypes } from './types';

const firstData = {
  firstName: 'Gianni',
  lastName: 'Morandi',
  address: 'Via Roma, 1, Treno',
  uid: 3456789542556789,
  info: 123123.12,
};

export const mockedColumns: CustomColumnsType<Record<string, unknown>> = [
  {
    id: 'firstName',
    Header: 'First Name',
    accessor: (row: any) => row.firstName,
  },
  {
    id: 'lastName',
    Header: 'Last Name',
    accessor: (row: any) => row.lastName,
  },
  {
    id: 'address',
    Header: 'Address',
    accessor: (row: any) => row.address,
  },
  {
    id: 'uid',
    Header: 'UID',
    accessor: (row: any) => row.uid,
    minWidth: 200,
    align: 'end',
  },
  {
    id: 'info',
    Header: 'Info',
    accessor: (row: any) => row.info,
    disableSortBy: true,
    align: 'end',
    minWidth: 180,
  },
];

export const mockedData: Array<Record<string, unknown> & OptionalDataTypes<Record<string, unknown>>> = [
  {
    ...firstData,
    subRows: [
      {
        firstName: 'ciao',
        lastName: 'Stuffo',
        address: 'Via Roma, 15 Monza',
        uid: 123123,
        info: 12,
        subRows: [
          {
            firstName: '1',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
            subRows: [
              {
                firstName: '1',
                lastName: 'Stuffo',
                address: 'Via Roma, 15 Monza',
                uid: 123123,
                info: 12,
                subRows: [
                  {
                    firstName: '1',
                    lastName: 'Stuffo',
                    address: 'Via Roma, 15 Monza',
                    uid: 123123,
                    info: 12,
                    subRows: [
                      {
                        firstName: '1',
                        lastName: 'Stuffo',
                        address: 'Via Roma, 15 Monza',
                        uid: 123123,
                        info: 12,
                        subRows: [
                          {
                            firstName: '1',
                            lastName: 'Stuffo',
                            address: 'Via Roma, 15 Monza',
                            uid: 123123,
                            info: 12,
                            subRows: [
                              {
                                firstName: '1',
                                lastName: 'Stuffo',
                                address: 'Via Roma, 15 Monza',
                                uid: 123123,
                                info: 12,
                                subRows: [
                                  {
                                    firstName: '1',
                                    lastName: 'Stuffo',
                                    address: 'Via Roma, 15 Monza',
                                    uid: 123123,
                                    info: 12,
                                    subRows: [
                                      {
                                        firstName: '1',
                                        lastName: 'Stuffo',
                                        address: 'Via Roma, 15 Monza',
                                        uid: 123123,
                                        info: 12,
                                      },
                                      {
                                        firstName: '2',
                                        lastName: 'Stuffo',
                                        address: 'Via Roma, 15 Monza',
                                        uid: 123123,
                                        info: 12,
                                      },
                                      {
                                        firstName: '3',
                                        lastName: 'Stuffo',
                                        address: 'Via Roma, 15 Monza',
                                        uid: 123123,
                                        info: 12,
                                      },
                                    ],
                                  },
                                  {
                                    firstName: '2',
                                    lastName: 'Stuffo',
                                    address: 'Via Roma, 15 Monza',
                                    uid: 123123,
                                    info: 12,
                                  },
                                  {
                                    firstName: '3',
                                    lastName: 'Stuffo',
                                    address: 'Via Roma, 15 Monza',
                                    uid: 123123,
                                    info: 12,
                                  },
                                ],
                              },
                              {
                                firstName: '2',
                                lastName: 'Stuffo',
                                address: 'Via Roma, 15 Monza',
                                uid: 123123,
                                info: 12,
                              },
                              {
                                firstName: '3',
                                lastName: 'Stuffo',
                                address: 'Via Roma, 15 Monza',
                                uid: 123123,
                                info: 12,
                              },
                            ],
                          },
                          {
                            firstName: '2',
                            lastName: 'Stuffo',
                            address: 'Via Roma, 15 Monza',
                            uid: 123123,
                            info: 12,
                          },
                          {
                            firstName: '3',
                            lastName: 'Stuffo',
                            address: 'Via Roma, 15 Monza',
                            uid: 123123,
                            info: 12,
                          },
                        ],
                      },
                      {
                        firstName: '2',
                        lastName: 'Stuffo',
                        address: 'Via Roma, 15 Monza',
                        uid: 123123,
                        info: 12,
                      },
                      {
                        firstName: '3',
                        lastName: 'Stuffo',
                        address: 'Via Roma, 15 Monza',
                        uid: 123123,
                        info: 12,
                      },
                    ],
                  },
                  {
                    firstName: '2',
                    lastName: 'Stuffo',
                    address: 'Via Roma, 15 Monza',
                    uid: 123123,
                    info: 12,
                  },
                  {
                    firstName: '3',
                    lastName: 'Stuffo',
                    address: 'Via Roma, 15 Monza',
                    uid: 123123,
                    info: 12,
                  },
                ],
              },
              {
                firstName: '2',
                lastName: 'Stuffo',
                address: 'Via Roma, 15 Monza',
                uid: 123123,
                info: 12,
              },
              {
                firstName: '3',
                lastName: 'Stuffo',
                address: 'Via Roma, 15 Monza',
                uid: 123123,
                info: 12,
              },
            ],
          },
          {
            firstName: '2',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
          {
            firstName: '3',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
        ],
      },
    ],
  },
  {
    firstName: 'Simone',
    lastName: 'Lastname',
    address: 'Via Roma, 12, Bologna',
    uid: '345367890',
    canBeDeleted: true,
    info: 123.96,
  },
  {
    firstName: 'Matteo',
    lastName: 'Staffone',
    address: 'Via Roma, 13, Genova',
    uid: 23456789,
    info: <code>23456789</code>,
    subRows: [
      {
        firstName: '1',
        lastName: 'Stuffo',
        address: 'Via Roma, 15 Monza',
        uid: 123123,
        info: 12,
      },
      {
        firstName: '2',
        lastName: 'Stuffo',
        address: 'Via Roma, 15 Monza',
        uid: 123123,
        info: 12,
        subRows: [
          {
            firstName: '1',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
            subRows: [
              {
                firstName: '1',
                lastName: 'Stuffo',
                address: 'Via Roma, 15 Monza',
                uid: 123123,
                info: 12,
              },
              {
                firstName: '2',
                lastName: 'Stuffo',
                address: 'Via Roma, 15 Monza',
                uid: 123123,
                info: 12,
              },
              {
                firstName: '3',
                lastName: 'Stuffo',
                address: 'Via Roma, 15 Monza',
                uid: 123123,
                info: 12,
              },
            ],
          },
          {
            firstName: '2',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
          {
            firstName: '3',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
        ],
      },
      {
        firstName: '3',
        lastName: 'Stuffo',
        address: 'Via Roma, 15 Monza',
        uid: 123123,
        info: 12,
        subRows: [
          {
            firstName: '1',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
          {
            firstName: '2',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
          {
            firstName: '3',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
        ],
      },
    ],
  },
  {
    firstName: 'Emanuele',
    lastName: 'Staffo',
    address: 'Via Roma, 14, Milano',
    uid: '2345678',
    info: 1234,
  },
  {
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
    subRows: [
      {
        firstName: 'ciao',
        lastName: 'Stuffo',
        address: 'Via Roma, 15 Monza',
        uid: 123123,
        info: 12,
      },
    ],
  },
  {
    firstName: 'Luca',
    lastName: 'Morandi',
    address: 'Via Roma, 1, Treno',
    uid: 3456795423556789,
    info: 123123.12,
    subRows: [
      {
        firstName: 'ciao',
        lastName: 'Stuffo',
        address: 'Via Roma, 15 Monza',
        uid: 123123,
        info: 12,
      },
    ],
  },
  {
    firstName: 'Mattia',
    lastName: 'Lastname',
    address: 'Via Roma, 12, Bologna',
    uid: 345367890,
    info: 123.96,
  },
  {
    firstName: 'Morfeo',
    lastName: 'Staffone',
    address: 'Via Roma, 13, Genova',
    uid: 3434235,
    info: 12.1213,
  },
  {
    firstName: 'Gianluca',
    lastName: 'Staffo',
    address: 'Via Roma, 14, Milano',
    uid: 2345678,
    info: 1234,
  },
  {
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
  {
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
  {
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
  {
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
  {
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
  {
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
  {
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
];

export const mockedDataWithIds = [
  {
    ...firstData,
    id: '1',
    subRows: [
      {
        id: '1.1',
        firstName: 'ciao',
        lastName: 'Stuffo',
        address: 'Via Roma, 15 Monza',
        uid: 123123,
        info: 12,
        subRows: [
          {
            id: '1.1.1',
            firstName: '1',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
            subRows: [
              {
                id: '1.1.1.1',
                firstName: '1',
                lastName: 'Stuffo',
                address: 'Via Roma, 15 Monza',
                uid: 123123,
                info: 12,
                subRows: [
                  {
                    id: '1.1.1.1.1',
                    firstName: '1',
                    lastName: 'Stuffo',
                    address: 'Via Roma, 15 Monza',
                    uid: 123123,
                    info: 12,
                    subRows: [
                      {
                        id: '1.1.1.1.1.1',
                        firstName: '1',
                        lastName: 'Stuffo',
                        address: 'Via Roma, 15 Monza',
                        uid: 123123,
                        info: 12,
                        subRows: [
                          {
                            id: '1.1.1.1.1.1.1',
                            firstName: '1',
                            lastName: 'Stuffo',
                            address: 'Via Roma, 15 Monza',
                            uid: 123123,
                            info: 12,
                            subRows: [
                              {
                                id: '1.1.1.1.1.1.1.1',
                                firstName: '1',
                                lastName: 'Stuffo',
                                address: 'Via Roma, 15 Monza',
                                uid: 123123,
                                info: 12,
                                subRows: [
                                  {
                                    id: '1.1.1.1.1.1.1.1.1',
                                    firstName: '1',
                                    lastName: 'Stuffo',
                                    address: 'Via Roma, 15 Monza',
                                    uid: 123123,
                                    info: 12,
                                    subRows: [
                                      {
                                        id: '1.1.1.1.1.1.1.1.1.1',
                                        firstName: '1',
                                        lastName: 'Stuffo',
                                        address: 'Via Roma, 15 Monza',
                                        uid: 123123,
                                        info: 12,
                                      },
                                      {
                                        id: '1.1.1.1.1.1.1.1.1.2',
                                        firstName: '2',
                                        lastName: 'Stuffo',
                                        address: 'Via Roma, 15 Monza',
                                        uid: 123123,
                                        info: 12,
                                      },
                                      {
                                        id: '1.1.1.1.1.1.1.1.1.3',
                                        firstName: '3',
                                        lastName: 'Stuffo',
                                        address: 'Via Roma, 15 Monza',
                                        uid: 123123,
                                        info: 12,
                                      },
                                    ],
                                  },
                                  {
                                    id: '1.1.1.1.1.1.1.1.2',
                                    firstName: '2',
                                    lastName: 'Stuffo',
                                    address: 'Via Roma, 15 Monza',
                                    uid: 123123,
                                    info: 12,
                                  },
                                  {
                                    id: '1.1.1.1.1.1.1.1.3',
                                    firstName: '3',
                                    lastName: 'Stuffo',
                                    address: 'Via Roma, 15 Monza',
                                    uid: 123123,
                                    info: 12,
                                  },
                                ],
                              },
                              {
                                id: '1.1.1.1.1.1.1.2',
                                firstName: '2',
                                lastName: 'Stuffo',
                                address: 'Via Roma, 15 Monza',
                                uid: 123123,
                                info: 12,
                              },
                              {
                                id: '1.1.1.1.1.1.1.3',
                                firstName: '3',
                                lastName: 'Stuffo',
                                address: 'Via Roma, 15 Monza',
                                uid: 123123,
                                info: 12,
                              },
                            ],
                          },
                          {
                            id: '1.1.1.1.1.1.2',
                            firstName: '2',
                            lastName: 'Stuffo',
                            address: 'Via Roma, 15 Monza',
                            uid: 123123,
                            info: 12,
                          },
                          {
                            id: '1.1.1.1.1.1.3',
                            firstName: '3',
                            lastName: 'Stuffo',
                            address: 'Via Roma, 15 Monza',
                            uid: 123123,
                            info: 12,
                          },
                        ],
                      },
                      {
                        id: '1.1.1.1.1.2',
                        firstName: '2',
                        lastName: 'Stuffo',
                        address: 'Via Roma, 15 Monza',
                        uid: 123123,
                        info: 12,
                      },
                      {
                        id: '1.1.1.1.1.3',
                        firstName: '3',
                        lastName: 'Stuffo',
                        address: 'Via Roma, 15 Monza',
                        uid: 123123,
                        info: 12,
                      },
                    ],
                  },
                  {
                    id: '1.1.1.1.2',
                    firstName: '2',
                    lastName: 'Stuffo',
                    address: 'Via Roma, 15 Monza',
                    uid: 123123,
                    info: 12,
                  },
                  {
                    id: '1.1.1.1.3',
                    firstName: '3',
                    lastName: 'Stuffo',
                    address: 'Via Roma, 15 Monza',
                    uid: 123123,
                    info: 12,
                  },
                ],
              },
              {
                id: '1.1.1.2',
                firstName: '2',
                lastName: 'Stuffo',
                address: 'Via Roma, 15 Monza',
                uid: 123123,
                info: 12,
              },
              {
                id: '1.1.1.3',
                firstName: '3',
                lastName: 'Stuffo',
                address: 'Via Roma, 15 Monza',
                uid: 123123,
                info: 12,
              },
            ],
          },
          {
            id: '1.1.2',
            firstName: '2',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
          {
            id: '1.1.3',
            firstName: '3',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
        ],
      },
    ],
  },
  {
    id: '2',
    firstName: 'Simone',
    lastName: 'Lastname',
    address: 'Via Roma, 12, Bologna',
    uid: '345367890',
    canBeDeleted: true,
    info: 123.96,
  },
  {
    id: '3',
    firstName: 'Matteo',
    lastName: 'Staffone',
    address: 'Via Roma, 13, Genova',
    uid: 23456789,
    info: <code>23456789</code>,
    subRows: [
      {
        id: '3.1',
        firstName: '1',
        lastName: 'Stuffo',
        address: 'Via Roma, 15 Monza',
        uid: 123123,
        info: 12,
      },
      {
        id: '3.2',
        firstName: '2',
        lastName: 'Stuffo',
        address: 'Via Roma, 15 Monza',
        uid: 123123,
        info: 12,
        subRows: [
          {
            id: '3.2.1',
            firstName: '1',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
            subRows: [
              {
                id: '3.2.1.1',
                firstName: '1',
                lastName: 'Stuffo',
                address: 'Via Roma, 15 Monza',
                uid: 123123,
                info: 12,
              },
              {
                id: '3.2.1.2',
                firstName: '2',
                lastName: 'Stuffo',
                address: 'Via Roma, 15 Monza',
                uid: 123123,
                info: 12,
              },
              {
                id: '3.2.1.3',
                firstName: '3',
                lastName: 'Stuffo',
                address: 'Via Roma, 15 Monza',
                uid: 123123,
                info: 12,
              },
            ],
          },
          {
            id: '3.2.2',
            firstName: '2',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
          {
            id: '3.2.3',
            firstName: '3',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
        ],
      },
      {
        id: '3.3',
        firstName: '3',
        lastName: 'Stuffo',
        address: 'Via Roma, 15 Monza',
        uid: 123123,
        info: 12,
        subRows: [
          {
            id: '3.3.1',
            firstName: '1',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
          {
            id: '3.3.2',
            firstName: '2',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
          {
            id: '3.3.3',
            firstName: '3',
            lastName: 'Stuffo',
            address: 'Via Roma, 15 Monza',
            uid: 123123,
            info: 12,
          },
        ],
      },
    ],
  },
  {
    id: '4',
    firstName: 'Emanuele',
    lastName: 'Staffo',
    address: 'Via Roma, 14, Milano',
    uid: '2345678',
    info: 1234,
  },
  {
    id: '5',
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
    subRows: [
      {
        id: '5.1',
        firstName: 'ciao',
        lastName: 'Stuffo',
        address: 'Via Roma, 15 Monza',
        uid: 123123,
        info: 12,
      },
    ],
  },
  {
    id: '6',
    firstName: 'Luca',
    lastName: 'Morandi',
    address: 'Via Roma, 1, Treno',
    uid: 3456795423556789,
    info: 123123.12,
    subRows: [
      {
        id: '6.1',
        firstName: 'ciao',
        lastName: 'Stuffo',
        address: 'Via Roma, 15 Monza',
        uid: 123123,
        info: 12,
      },
    ],
  },
  {
    id: '7',
    firstName: 'Mattia',
    lastName: 'Lastname',
    address: 'Via Roma, 12, Bologna',
    uid: 345367890,
    info: 123.96,
  },
  {
    id: '8',
    firstName: 'Morfeo',
    lastName: 'Staffone',
    address: 'Via Roma, 13, Genova',
    uid: 3434235,
    info: 12.1213,
  },
  {
    id: '9',
    firstName: 'Gianluca',
    lastName: 'Staffo',
    address: 'Via Roma, 14, Milano',
    uid: 2345678,
    info: 1234,
  },
  {
    id: '10',
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
  {
    id: '11',
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
  {
    id: '12',
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
  {
    id: '13',
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
  {
    id: '14',
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
  {
    id: '15',
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
  {
    id: '16',
    firstName: 'Simone',
    lastName: 'Stuffo',
    address: 'Via Roma, 15 Monza',
    uid: 123123,
    info: 12,
  },
];
