/*
 * Copyright 2022-2023 Wonderflow Design Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import clsx from 'clsx';
import { forwardRef } from 'react';

import { Polymorphic } from '@/components';

import * as styles from './container.module.css';

export type ContainerProps = {
  /**
   * Set the horizontal max-width of the container.
   */
  dimension?: 'full' | 'extra-small' | 'small' | 'medium' | 'large' | 'extra-large' | 'fixed';
  /**
   * Set or remove the container's predefined horizontal padding.
   */
  padding?: boolean;
}

type PolymorphicContainer = Polymorphic.ForwardRefComponent<'div', ContainerProps>;

export const Container = forwardRef(({
  children,
  className,
  dimension = 'full',
  padding = true,
  as: Wrapper = 'div',
  ...otherProps
}, forwardedRef) => (
  <Wrapper
    ref={forwardedRef}
    className={clsx(styles.Container, className)}
    data-container-dimension={dimension}
    data-container-padding={padding}
    {...otherProps}
  >
    {children}
  </Wrapper>
)) as PolymorphicContainer;
